/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.tutor.bpmapi.createBPMActivity;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.FlowObject;

class createBPMGateway
extends createBPMActivity {
    createBPMGateway(FlowObject bpmnFlowObject, NodeContainer container, LinkedList<ConversionMessage> messages) {
        this.setMessages(messages);
        this.setBpmnFlowObject(bpmnFlowObject);
        this.setContainer(container);
    }

    @Override
    public void create() throws ProjectException {
        oracle.tutor.bpmn.Gateway bpmnGateway = (oracle.tutor.bpmn.Gateway)this.getBpmnFlowObject();
        ExclusiveGateway bpmGateway = null;
        switch (bpmnGateway.getGatewayType()) {
            case XOR_DATA: {
                bpmGateway = this.getContainer().createExclusiveGateway();
                break;
            }
            case XOR_EVENT: {
                bpmGateway = this.getContainer().createEventBasedGateway();
                break;
            }
            case COMPLEX: {
                bpmGateway = this.getContainer().createComplexGateway();
                break;
            }
            case AND: {
                bpmGateway = this.getContainer().createParallelGateway();
                break;
            }
            case OR: {
                bpmGateway = this.getContainer().createInclusiveGateway();
            }
        }
        if (bpmnGateway.getInflows().size() <= 1 && bpmnGateway.getOutflows().size() > 1) {
            ((Gateway)bpmGateway).setDirection(GatewayDirection.DIVERGING);
        } else if (bpmnGateway.getInflows().size() > 1 && bpmnGateway.getOutflows().size() <= 1) {
            ((Gateway)bpmGateway).setDirection(GatewayDirection.CONVERGING);
        } else if (bpmnGateway.getInflows().size() > 1 && bpmnGateway.getOutflows().size() > 1) {
            this.getMessages().add(new ConversionMessage(bpmnGateway.getID(), bpmnGateway.getName() + " is converted to a diverging gateway"));
            ((Gateway)bpmGateway).setDirection(GatewayDirection.DIVERGING);
        } else {
            ((Gateway)bpmGateway).setDirection(GatewayDirection.UNSPECIFIED);
        }
        createBPMGateway.setCommonAttributes((FlowNode)bpmGateway, bpmnGateway);
        this.getContainer().addChild((ProjectObject)bpmGateway);
    }
}

