/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.TransitionUserNameFeature;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.tutor.bpmapi.Utils;
import oracle.bpm.tutor.bpmapi.createBPMGraphicalElements;
import oracle.tutor.bpmn.Association;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.MessageFlow;
import oracle.tutor.bpmn.Pool;

class createBPMFlows
extends createBPMGraphicalElements {
    private LinkedList<ConversionMessage> _messages;
    private static final Logger _sLog = Logger.getLogger(createBPMFlows.class.getName());

    public createBPMFlows(BusinessProcessDiagram bpd, Process bpmProcess, LinkedList<ConversionMessage> messages) {
        this.setBpd(bpd);
        this.setBpmProcess(bpmProcess);
        this._messages = messages;
    }

    @Override
    public void create(Pool poolToExport) throws ProjectException {
        for (ConnectingObject bpmnFlow : this.getBpd().getAllFlows().values()) {
            FlowNode bpmTo;
            FlowObject bpmnTo;
            if (bpmnFlow instanceof MessageFlow) {
                this._messages.add(new ConversionMessage(bpmnFlow.getID(), bpmnFlow.getName() + ": Message flow removed as message flows are not supported yet."));
                _sLog.info("MessageFlow \"" + bpmnFlow.getID() + "\" removed as MessageFlows not allowed in BPM.");
                continue;
            }
            FlowObject bpmnFrom = bpmnFlow.getFrom() instanceof FlowObject ? (FlowObject)bpmnFlow.getFrom() : null;
            FlowObject flowObject = bpmnTo = bpmnFlow.getTo() instanceof FlowObject ? (FlowObject)bpmnFlow.getTo() : null;
            if (!Utils.isInPool(bpmnFrom, poolToExport) || !Utils.isInPool(bpmnTo, poolToExport)) continue;
            FlowNode bpmFrom = bpmnFrom != null ? Utils.findNode(bpmnFrom.getID(), (NodeContainer)this.getBpmProcess()) : null;
            FlowNode flowNode = bpmTo = bpmnTo != null ? Utils.findNode(bpmnTo.getID(), (NodeContainer)this.getBpmProcess()) : null;
            if (bpmFrom == null || bpmTo == null) {
                String txt = bpmFrom == null ? "source " : "target";
                _sLog.warning("flow with ID \"" + bpmnFlow.getID() + "\" cannot be created as " + (bpmFrom == null ? "source" : "target") + " is null.\n");
            }
            if (bpmFrom == null || bpmTo == null) continue;
            SequenceFlow bpmFlow = null;
            Process container = this.getBpmProcess();
            if (bpmnFrom.getParentSubProcess() != null) {
                Subprocess bpmFromNode = (Subprocess)Utils.findNode(bpmnFrom.getParentSubProcess().getID(), (NodeContainer)this.getBpmProcess());
                container = bpmFromNode;
            }
            if (bpmnFlow instanceof oracle.tutor.bpmn.SequenceFlow || bpmnFlow instanceof Association && bpmnFrom instanceof Event && ((Event)bpmnFrom).getTrigger() == Event.Trigger.COMPENSATION) {
                if (bpmnFlow instanceof Association && bpmnFrom instanceof Event && ((Event)bpmnFrom).getTrigger() == Event.Trigger.COMPENSATION) {
                    this._messages.add(new ConversionMessage(bpmnFlow.getID(), bpmnFlow.getName() + ": association flow is converted to a sequence flow."));
                }
                bpmFlow = container.createSequenceFlow(bpmFrom, bpmTo);
                bpmFlow.setDefaultLabel(bpmnFlow.getName());
                if (!"".equals(bpmnFlow.getName())) {
                    ((TransitionUserNameFeature)bpmFlow.getFeature(TransitionUserNameFeature.class)).setValue(bpmnFlow.getName());
                }
                if (bpmnFlow instanceof oracle.tutor.bpmn.SequenceFlow && ((oracle.tutor.bpmn.SequenceFlow)bpmnFlow).isConditional().booleanValue()) {
                    bpmFlow = bpmFlow.toConditionalFlow();
                    if (((oracle.tutor.bpmn.SequenceFlow)bpmnFlow).getConditionExpression() != null) {
                        ((ConditionalFlow)bpmFlow).setCondition((Expression)new XPathExpression(((oracle.tutor.bpmn.SequenceFlow)bpmnFlow).getConditionExpression()));
                    }
                } else if (bpmnFlow instanceof oracle.tutor.bpmn.SequenceFlow && ((oracle.tutor.bpmn.SequenceFlow)bpmnFlow).isDefault().booleanValue()) {
                    bpmFlow.setDefault(true);
                }
            }
            container.addChild(bpmFlow);
        }
    }
}

