/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.tutor.bpmapi.Utils;
import oracle.bpm.tutor.bpmapi.createBPMActivity;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;

class createBPMEvent
extends createBPMActivity {
    private static final Logger _sLog = Logger.getLogger(createBPMEvent.class.getName());

    createBPMEvent(FlowObject bpmnFlowObject, NodeContainer container, LinkedList<ConversionMessage> messages) {
        this.setMessages(messages);
        this.setBpmnFlowObject(bpmnFlowObject);
        this.setContainer(container);
    }

    @Override
    public void create() throws ProjectException {
        Event bpmnEvent = (Event)this.getBpmnFlowObject();
        Object bpmEvent = null;
        EventTriggerType bpmTriggerType = createBPMEvent.getTriggerType(bpmnEvent);
        if (!this._isValidTriggerType(bpmnEvent.getTrigger())) {
            if (bpmnEvent.getTarget() == null) {
                this.getMessages().add(new ConversionMessage(bpmnEvent.getID(), bpmnEvent.getName() + ": " + bpmnEvent.getTrigger().name() + " trigger not supported. Converting trigger to NONE type"));
            }
            _sLog.warning("Trigger type : " + bpmnEvent.getTrigger().name() + ", not supported. Converting trigger to NONE type");
            bpmTriggerType = EventTriggerType.NONE;
        }
        switch (bpmnEvent.getEventType()) {
            case START: {
                bpmEvent = this.getContainer().createStartEvent(bpmTriggerType);
                break;
            }
            case END: {
                bpmEvent = this.getContainer().createEndEvent(bpmTriggerType);
                break;
            }
            case INTERMEDIATE: {
                if (bpmnEvent.getTarget() != null) {
                    if (this._isValidBoundaryEvent(bpmnEvent.getTrigger())) {
                        bpmEvent = this.getContainer().createBoundaryEvent(bpmTriggerType, null);
                        break;
                    }
                    bpmTriggerType = EventTriggerType.ERROR;
                    this.getMessages().add(new ConversionMessage("2." + bpmnEvent.getID(), bpmnEvent.getName() + " : " + bpmnEvent.getTrigger().name() + ", not a valid trigger type for boundary event. Converting to Error trigger type"));
                    bpmEvent = this.getContainer().createBoundaryEvent(bpmTriggerType, null);
                    break;
                }
                bpmEvent = bpmnEvent.getDirection() == Event.Direction.CATCH ? this.getContainer().createIntermediateCatchEvent(bpmTriggerType) : this.getContainer().createIntermediateThrowEvent(bpmTriggerType);
            }
        }
        createBPMEvent.setCommonAttributes(bpmEvent, bpmnEvent);
        if (bpmnEvent.getTarget() != null) {
            Activity bpmTarget = (Activity)Utils.findNode(bpmnEvent.getTarget().getID(), this.getContainer());
            ((BoundaryEvent)bpmEvent).setBoundaryActivity(bpmTarget);
            ((BoundaryEvent)bpmEvent).setCancelActivity(bpmnEvent.getInterrupting().booleanValue());
        }
        this.getContainer().addChild((ProjectObject)bpmEvent);
    }

    static EventTriggerType getTriggerType(Event bpmnEvent) {
        EventTriggerType bpmTriggerType = EventTriggerType.NONE;
        switch (bpmnEvent.getTrigger()) {
            case NONE: {
                bpmTriggerType = EventTriggerType.NONE;
                break;
            }
            case MESSAGE: {
                bpmTriggerType = EventTriggerType.MESSAGE;
                break;
            }
            case TIMER: {
                bpmTriggerType = EventTriggerType.TIMER;
                break;
            }
            case CONDITIONAL: {
                bpmTriggerType = EventTriggerType.CONDITIONAL;
                break;
            }
            case SIGNAL: {
                bpmTriggerType = EventTriggerType.SIGNAL;
                break;
            }
            case MULTIPLE: {
                bpmTriggerType = EventTriggerType.MULTIPLE;
                break;
            }
            case ERROR: {
                bpmTriggerType = EventTriggerType.ERROR;
                break;
            }
            case CANCEL: {
                bpmTriggerType = EventTriggerType.CANCEL;
                break;
            }
            case COMPENSATION: {
                bpmTriggerType = EventTriggerType.COMPENSATION;
                break;
            }
            case LINK: {
                bpmTriggerType = EventTriggerType.LINK;
                break;
            }
            case TERMINATE: {
                bpmTriggerType = EventTriggerType.TERMINATE;
                break;
            }
            default: {
                bpmTriggerType = EventTriggerType.NONE;
            }
        }
        return bpmTriggerType;
    }

    private boolean _isValidBoundaryEvent(Event.Trigger bpmnTrigger) {
        return bpmnTrigger == Event.Trigger.MESSAGE || bpmnTrigger == Event.Trigger.ERROR || bpmnTrigger == Event.Trigger.TIMER;
    }

    private boolean _isValidTriggerType(Event.Trigger bpmnTrigger) {
        boolean isValid = true;
        if (bpmnTrigger == Event.Trigger.CONDITIONAL || bpmnTrigger == Event.Trigger.MULTIPLE || bpmnTrigger == Event.Trigger.CANCEL || bpmnTrigger == Event.Trigger.COMPENSATION || bpmnTrigger == Event.Trigger.LINK) {
            isValid = false;
        }
        return isValid;
    }
}

