/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.bpmapi.Utils;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Resource;
import oracle.tutor.bpmn.Subprocess;

abstract class createBPMActivity {
    private FlowObject _bpmnFlowObject = null;
    private NodeContainer _container = null;
    private LinkedList<ConversionMessage> _messages;
    private static final Logger _Log = Logger.getLogger(createBPMActivity.class.getName());
    private static int _sUnknownNameCount;

    createBPMActivity() {
    }

    public abstract void create() throws ProjectException;

    public static void setCommonAttributes(FlowNode bpmNode, FlowObject bpmnNode) {
        bpmNode.setId(Utils.transformToBPMId(bpmnNode.getID()));
        if (bpmnNode.getName() != null && !"".equals(bpmnNode.getName())) {
            bpmNode.setDefaultLabel(bpmnNode.getName());
        } else if (bpmnNode.getName() == null || "".equals(bpmnNode.getName())) {
            _Log.info("name not found for activity : " + bpmnNode.getID() + ".\n");
            bpmNode.setDefaultLabel("" + ++_sUnknownNameCount);
            _Log.info("setting arbitary name : " + _sUnknownNameCount + "\n");
        }
        if (bpmnNode.getDocumentation() != null) {
            bpmNode.setDefaultDescription(bpmnNode.getDocumentation());
        }
        if (bpmnNode instanceof Activity) {
            Activity tempBpmnActivity = (Activity)bpmnNode;
            int ctr = 1;
            for (Resource resource : tempBpmnActivity.getResources()) {
                bpmNode.addAnnotation("Resource/Role " + ctr++, resource.getName(), true);
            }
        }
        for (Map.Entry<String, Object> entry : bpmnNode.getAttributes().entrySet()) {
            String value = entry.getValue() != null ? (entry.getValue() instanceof String ? (String)entry.getValue() : entry.getValue().toString()) : null;
            if (value == null) continue;
            bpmNode.addAnnotation(entry.getKey(), value, true);
        }
        Process bpmProcess = bpmNode.getProcess();
        if (bpmnNode.getLane() != null) {
            LaneUtils.setLaneForFlowNode((Lane)Utils.findBPMLane(bpmnNode.getLane().getID(), bpmProcess), (FlowNode)bpmNode);
        }
        if (bpmnNode instanceof Subprocess) {
            Subprocess tempSp = (Subprocess)bpmnNode;
            if (Math.round(tempSp.getExpandedHeight()) != 0L && Math.round(tempSp.getExpandedWidth()) != 0L) {
                bpmNode.setHeight(Math.round((float)tempSp.getExpandedHeight()));
                bpmNode.setWidth(Math.round((float)tempSp.getExpandedWidth()));
            } else {
                bpmNode.setHeight(Math.round(bpmnNode.getHeight()));
                bpmNode.setWidth(Math.round(bpmnNode.getWidth()));
            }
        }
        bpmNode.setX(Math.round(bpmnNode.getX()));
        bpmNode.setY(Math.round(bpmnNode.getY()));
    }

    public FlowObject getBpmnFlowObject() {
        return this._bpmnFlowObject;
    }

    public void setBpmnFlowObject(FlowObject bpmnFlowObject) {
        this._bpmnFlowObject = bpmnFlowObject;
    }

    public NodeContainer getContainer() {
        return this._container;
    }

    public void setContainer(NodeContainer container) {
        this._container = container;
    }

    public LinkedList<ConversionMessage> getMessages() {
        return this._messages;
    }

    public void setMessages(LinkedList<ConversionMessage> messages) {
        this._messages = messages;
    }

    static void initAnonymousCtr() {
        _sUnknownNameCount = 0;
    }
}

