/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.List;
import java.util.logging.Logger;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.bpmapi.ConversionExceptions;
import oracle.bpm.tutor.bpmapi.ConversionTask;
import oracle.tutor.bpmn.ProgressNotifier;

public class convert2docx {
    private static Logger mlog = Logger.getLogger(convert2docx.class.getName());

    public static String convert(List<Process> processes, ProgressNotifier notifier, String outputDir) throws ProjectException, ConversionExceptions {
        int totalProcesses = processes.size();
        int noOfConverted = 0;
        ConversionTask ct = new ConversionTask();
        int chunkSizePerFile = 100 / totalProcesses;
        for (Process process : processes) {
            notifier.setChunk(chunkSizePerFile);
            String tutorFileName = process.getName() + ".docx";
            boolean successfulConversion = ct.startConversion(process, notifier, tutorFileName, outputDir);
            if (!successfulConversion) continue;
            ++noOfConverted;
        }
        if (totalProcesses != noOfConverted) {
            String separatorString = "";
            for (int i = 0; i < 20; ++i) {
                separatorString = separatorString + "=";
            }
            throw new ConversionExceptions("\n" + separatorString + "\n" + String.format("%d/%d models exported successfully.", noOfConverted, totalProcesses) + "\n" + separatorString + "\n" + ct.getErrors());
        }
        return String.format("%d/%d models exported successfully.", noOfConverted, totalProcesses);
    }

    public static String convert(Project bpmProject, ProgressNotifier notifier, String outputDir) throws ProjectException, ConversionExceptions {
        int totalProcesses = 0;
        int convertedProcesses = 0;
        if (bpmProject.getProcesses() != null) {
            totalProcesses = bpmProject.getProcesses().size();
        }
        ConversionTask ct = new ConversionTask();
        int chunkSizePerFile = 100 / bpmProject.getProcesses().size();
        for (Process bpmProcess : bpmProject.getProcesses()) {
            notifier.setChunk(chunkSizePerFile);
            String tutorFileName = bpmProcess.getName() + ".docx";
            boolean successfulConversion = ct.startConversion(bpmProcess, notifier, tutorFileName, outputDir);
            if (!successfulConversion) continue;
            ++convertedProcesses;
        }
        if (totalProcesses != convertedProcesses) {
            String separatorString = "";
            for (int i = 0; i < 20; ++i) {
                separatorString = separatorString + "=";
            }
            throw new ConversionExceptions("\n" + separatorString + "\n" + String.format("%d/%d models exported successfully.", convertedProcesses, totalProcesses) + "\n" + separatorString + "\n" + ct.getErrors());
        }
        return String.format("%d/%d models exported successfully.", convertedProcesses, totalProcesses);
    }

    public static String convert(Process bpmProcess, ProgressNotifier notifier, String tutorFileName, String outputDir) throws ProjectException, ConversionExceptions {
        boolean successfulConversion;
        ConversionTask ct = new ConversionTask();
        String fileExtn = "";
        if (!tutorFileName.endsWith(".docx")) {
            fileExtn = fileExtn + ".docx";
        }
        if (successfulConversion = ct.startConversion(bpmProcess, notifier, tutorFileName + fileExtn, outputDir)) {
            return "Model exported successfully.";
        }
        throw new ConversionExceptions(ct.getErrors());
    }
}

