/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.io.File;
import java.util.logging.Logger;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.tutor.bpmapi.ConversionExceptions;
import oracle.bpm.tutor.bpmapi.ConversionTaskToBPM;
import oracle.tutor.bpmn.ProgressNotifier;

public class convert2bpm {
    private static Logger mlog = Logger.getLogger(convert2bpm.class.getName());

    public static String convert(File[] inputFiles, Project bpmProject, String xmlFolder, ProgressNotifier notifier, boolean mergePools) throws ProjectException, ConversionExceptions {
        int noOfConverted = 0;
        ConversionTaskToBPM ct = new ConversionTaskToBPM();
        for (File file : inputFiles) {
            int chunkSizePerFile = 100 / inputFiles.length;
            notifier.setChunk(chunkSizePerFile);
            boolean successfulConversion = ct.startConversion(file, bpmProject, xmlFolder, notifier, mergePools);
            if (!successfulConversion) continue;
            ++noOfConverted;
        }
        if (inputFiles.length == 1 && noOfConverted == 1) {
            return String.format("%s imported successfully", inputFiles[0].getName());
        }
        if (inputFiles.length != 1 && noOfConverted != inputFiles.length || inputFiles.length == 1 && noOfConverted != 1) {
            String separatorString = "";
            for (int i = 0; i < 20; ++i) {
                separatorString = separatorString + "=";
            }
            String errors = "\n" + separatorString + "\n" + String.format("%d/%d model(s) imported successfully", noOfConverted, inputFiles.length) + "\n" + separatorString + "\n" + ct.getErrors();
            throw new ConversionExceptions(errors);
        }
        return String.format("%d models imported successfully.", noOfConverted);
    }
}

