/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.tutor.bpmn.Annotation;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Swimlane;

class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static Utils instance = new Utils();

    private Utils() {
    }

    public static boolean laneHasChild(Swimlane lane, BusinessProcessDiagram bpd) {
        boolean flag = false;
        for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
            if (bpmnNode.getLane() == null || !lane.getID().equals(bpmnNode.getLane().getID())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    static Utils getInstance() {
        return instance;
    }

    static boolean poolHasChild(Pool bpmnPool, BusinessProcessDiagram bpd) {
        boolean flag = false;
        if (bpmnPool.getLanes().size() != 0) {
            Lane bpmnLane;
            Iterator<Lane> i$ = bpmnPool.getLanes().values().iterator();
            while (i$.hasNext() && !(flag = Utils.laneHasChild(bpmnLane = i$.next(), bpd))) {
            }
        } else {
            flag = Utils.laneHasChild(bpmnPool, bpd);
        }
        return flag;
    }

    static void printBPMProcess(Process bpmProcess) {
        System.out.println("all bpm process nodes");
        System.out.println("----------------------");
        Sequence nodes = bpmProcess.getChildrenByType(FlowNode.class);
        if (nodes != null) {
            for (FlowNode node : nodes) {
                System.out.println(node.getId() + " : " + node.getName() + " , " + node.getDefaultLabel());
                if (!(node instanceof Subprocess)) continue;
                Utils.printBPMSubprocess(node);
            }
        }
    }

    static void printBPMSubprocess(FlowNode node) {
        if (node instanceof Subprocess) {
            Iterator iterator;
            System.out.println("Subprocess : " + node.getName());
            System.out.println("--------------------------------");
            Subprocess subprocess = (Subprocess)node;
            Sequence children = subprocess.getChildrenByType(FlowNode.class);
            if (children != null && (iterator = children.iterator()) != null) {
                while (iterator.hasNext()) {
                    FlowNode temp = (FlowNode)iterator.next();
                    System.out.println(temp.getId() + " : " + temp.getName() + " , " + temp.getDefaultLabel());
                    Utils.printBPMSubprocess(temp);
                }
            }
        }
    }

    static FlowNode findNode(String id, NodeContainer container, boolean transformIdToBPMTypeId) {
        FlowNode result;
        block1: {
            FlowNode node;
            Iterator iterator;
            Sequence nodes;
            id = transformIdToBPMTypeId ? Utils.transformToBPMId(id) : id;
            result = container.findNode(id);
            if (result != null || (nodes = container.getFlowNodes()) == null || (iterator = nodes.iterator()) == null) break block1;
            while (iterator.hasNext() && (!((node = (FlowNode)iterator.next()) instanceof Subprocess) || (result = Utils.findNode(id, node)) == null)) {
            }
        }
        return result;
    }

    static FlowNode findNode(String id, NodeContainer container) {
        return Utils.findNode(id, container, true);
    }

    static oracle.bpm.project.model.processes.Lane findBPMLane(String laneId, Process bpmProcess) {
        Iterator bpmLanesIterator;
        Sequence bpmLanes = bpmProcess.getLanes();
        oracle.bpm.project.model.processes.Lane bpmLane = null;
        if (bpmLanes != null && (bpmLanesIterator = bpmLanes.iterator()) != null) {
            while (bpmLanesIterator.hasNext() && !(bpmLane = (oracle.bpm.project.model.processes.Lane)bpmLanesIterator.next()).getId().equals(laneId)) {
            }
        }
        if (bpmLane == null) {
            LOG.warning(laneId + " lane not found.\n");
        }
        return bpmLane;
    }

    static String normalizeProcessId(String bpmnId) {
        String temp = bpmnId;
        if (Character.isDigit((temp = Utils._getStringWithoutSpaces(temp)).charAt(0))) {
            temp = "ID" + temp;
        }
        return temp;
    }

    static String transformToBPMId(String bpmnId) {
        String temp = Utils._getStringWOHyphens(bpmnId);
        temp = "ID" + Utils._getStringWithoutSpaces(temp);
        return temp;
    }

    static void makeLanesAdjacent(Pool bpmnPool, BusinessProcessDiagram bpd) {
        LOG.info("making lanes of pool '" + bpmnPool.getName() + "' adjacent.\n");
        if (bpmnPool.getLanes().size() == 0) {
            int n = Math.round(bpmnPool.getY());
            if (n != 0) {
                Utils.moveActivitiesNUnits(bpd, bpmnPool, n);
                bpmnPool.setY(0.0f);
            }
        } else {
            LinkedList<Lane> lanes = new LinkedList<Lane>();
            for (Lane bpmnLane : bpmnPool.getLanes().values()) {
                lanes.add(bpmnLane);
            }
            Collections.sort(lanes, new Comparator<Lane>(){

                @Override
                public int compare(Lane lane1, Lane lane2) {
                    float lane2y;
                    float lane1y = lane1.getY();
                    if (lane1y > (lane2y = lane2.getY())) {
                        return 1;
                    }
                    if (lane1y < lane2y) {
                        return -1;
                    }
                    return 0;
                }
            });
            boolean firstLane = true;
            Lane priorLane = (Lane)lanes.get(0);
            for (Lane bpmnLane : lanes) {
                int n = 0;
                if (firstLane) {
                    firstLane = false;
                    if (Math.round(bpmnLane.getY()) == 0) continue;
                    n = Math.round(bpmnLane.getY()) - 0;
                    Utils.moveActivitiesNUnits(bpd, bpmnLane, n);
                    bpmnLane.setY(0.0f);
                    continue;
                }
                n = Math.round(bpmnLane.getY() - (priorLane.getY() + priorLane.getHeight()));
                if (n != 0) {
                    if (priorLane.getHeight() == 0.0f) {
                        priorLane.setHeight(n);
                    } else {
                        Utils.moveActivitiesNUnits(bpd, bpmnLane, n);
                        bpmnLane.setY(priorLane.getY() + priorLane.getHeight());
                    }
                }
                priorLane = bpmnLane;
            }
        }
    }

    static boolean isInPool(FlowObject bpmnFlowObject, Pool poolToExport) {
        boolean result = bpmnFlowObject != null && bpmnFlowObject.getLane() instanceof Pool && poolToExport.getID().equals(bpmnFlowObject.getLane().getID()) || bpmnFlowObject != null && bpmnFlowObject.getLane() instanceof Lane && poolToExport.getID().equals(bpmnFlowObject.getLane().getPool().getID());
        return result;
    }

    private static FlowNode findNode(String id, FlowNode node) {
        Iterator iterator;
        Sequence children;
        FlowNode resultNode = null;
        if (id.equals(node.getId())) {
            resultNode = node;
            return node;
        }
        if (node instanceof Subprocess && (children = node.getChildrenByType(FlowNode.class)) != null && (iterator = children.iterator()) != null) {
            while (iterator.hasNext() && resultNode == null) {
                resultNode = Utils.findNode(id, (FlowNode)iterator.next());
            }
        }
        return resultNode;
    }

    private static String _getStringWithoutSpaces(String bpmnId) {
        String tempWOSpaces = "";
        if (bpmnId.contains(" ")) {
            StringTokenizer st = new StringTokenizer(bpmnId, " ");
            while (st.hasMoreTokens()) {
                tempWOSpaces = tempWOSpaces + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                tempWOSpaces = tempWOSpaces + "_";
            }
        } else {
            tempWOSpaces = bpmnId;
        }
        return tempWOSpaces;
    }

    private static String _getStringWOHyphens(String bpmnId) {
        String temp = "";
        if (bpmnId.contains("-")) {
            int prePos = 0;
            while (prePos < bpmnId.lastIndexOf("-")) {
                int curPos = bpmnId.indexOf("-", prePos);
                temp = temp + bpmnId.substring(prePos, curPos);
                prePos = curPos + 1;
            }
            temp = temp + bpmnId.substring(prePos);
        } else {
            temp = bpmnId;
        }
        return temp;
    }

    private static void moveActivitiesNUnits(BusinessProcessDiagram bpd, Swimlane bpmnLane, int n) {
        for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
            if (bpmnNode.getLane() != null && bpmnNode.getLane().getID().equals(bpmnLane.getID()) && bpmnNode.getParentSubProcess() == null) {
                bpmnNode.setY(bpmnNode.getY() - (float)n);
                continue;
            }
            if (bpmnNode.getLane() != null || !(bpmnNode instanceof Annotation) || !Utils.isAnnotationInLane(bpmnNode, bpmnLane)) continue;
            bpmnNode.setY(bpmnNode.getY() - (float)n);
        }
    }

    private static boolean isAnnotationInLane(FlowObject bpmnAnnotation, Swimlane bpmnLane) {
        return bpmnAnnotation.getX() >= bpmnLane.getX() && bpmnAnnotation.getX() <= bpmnLane.getX() + bpmnLane.getWidth() && bpmnAnnotation.getY() >= bpmnLane.getY() && bpmnAnnotation.getY() <= bpmnLane.getY() + bpmnLane.getHeight();
    }
}

