/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Swimlane;

public class Page {
    private BusinessProcessDiagram _bpd = null;
    private LinkedList<Pool> _expPoolList = null;
    private ExportType _expType = ExportType.SEPERATE_EACH_POOL;
    private static Logger _sLog = Logger.getLogger(Page.class.getName());

    public Page(ExportType expType, BusinessProcessDiagram bpd) {
        this._bpd = bpd;
        this._expType = expType;
        this.makeBpdHorizontalOriented();
    }

    public void setExportPools(LinkedList<Pool> expPoolList) {
        this._expPoolList = expPoolList;
    }

    public LinkedList<Pool> getExportPools() {
        return this._expPoolList;
    }

    public ExportType getExpType() {
        return this._expType;
    }

    public BusinessProcessDiagram getBPD() {
        return this._bpd;
    }

    boolean validateSettings() {
        if (this._expType == ExportType.MERGE_POOLS && this._expPoolList != null) {
            _sLog.warning("Merge Pools option merges all pools. Merging all pools as a single pool for bpd : " + this._bpd.getName());
            this._expPoolList = null;
        }
        return true;
    }

    private void makeBpdHorizontalOriented() {
        for (Pool pool : this._bpd.getPools().values()) {
            if (pool.getAttribute("orientation") == null || !"VERTICAL".equalsIgnoreCase((String)pool.getAttribute("orientation"))) continue;
            pool.setX(pool.getY() + pool.getX());
            pool.setWidth(pool.getWidth() + pool.getHeight());
            pool.setY(pool.getX() - pool.getY());
            pool.setHeight(pool.getWidth() - pool.getHeight());
            pool.setX(pool.getX() - pool.getY());
            pool.setWidth(pool.getWidth() - pool.getHeight());
            for (Lane lane : pool.getLanes().values()) {
                lane.setX(lane.getY() + lane.getX());
                lane.setWidth(lane.getHeight() + lane.getWidth());
                lane.setY(lane.getX() - lane.getY());
                lane.setHeight(lane.getWidth() - lane.getHeight());
                lane.setX(lane.getX() - lane.getY());
                lane.setWidth(lane.getWidth() - lane.getHeight());
                this.swapNodeCoordinatesOf(lane);
            }
            this.swapNodeCoordinatesOf(pool);
        }
    }

    private void swapNodeCoordinatesOf(Swimlane lane) {
        for (FlowObject node : this._bpd.getAllNodes().values()) {
            if (node.getLane() == null || !lane.getID().equals(node.getLane().getID())) continue;
            float x = node.getX();
            node.setX(node.getY());
            node.setY(x);
            if (!(node instanceof Subprocess)) continue;
            float width = node.getWidth();
            node.setWidth(node.getHeight());
            node.setHeight(width);
        }
    }

    public static enum ExportType {
        MERGE_POOLS,
        SEPERATE_EACH_POOL;

    }
}

