/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.features.TransitionUserNameFeature;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.Annotation;
import oracle.tutor.bpmn.Association;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Swimlane;
import oracle.tutor.bpmn.Task;

class ImportBPM {
    private BusinessProcessDiagram bpd = null;
    private Process bpmProcess = null;
    private static final Logger _sLog = Logger.getLogger(ImportBPM.class.getName());

    ImportBPM(Process bpmProcess) {
        this.bpmProcess = bpmProcess;
    }

    BusinessProcessDiagram importBPMNProcess() {
        this.bpd = new BusinessProcessDiagram(this.bpmProcess.getId(), this.bpmProcess.getName());
        this.bpd.setAuthor(this.bpmProcess.getAuthor());
        this.bpd.setToolID("BPM Studio 11g");
        if (this.bpmProcess.getDefaultDescription() != null) {
            this.bpd.setDocumentation(this.bpmProcess.getDefaultDescription());
        }
        _sLog.info("creating default pool\n");
        Pool pool = new Pool("P0", "Default", this.bpd);
        pool.setVisible(false);
        pool.setX(0.0f);
        pool.setY(0.0f);
        for (oracle.bpm.project.model.processes.Lane bpmLane : this.bpmProcess.getLanes()) {
            Lane lane = new Lane(bpmLane.getId(), bpmLane.getName(), pool);
            lane.setHeight(bpmLane.getSize());
            lane.setY(bpmLane.getOffset());
            lane.setX(0.0f);
        }
        _sLog.info("creating bpmn activities.\n");
        for (FlowNode bpmFlowNode : this.bpmProcess.getFlowNodes()) {
            this.createContainerObjects(bpmFlowNode);
        }
        _sLog.info("creating bpmn attached intermediate events.\n");
        for (FlowNode bpmFlowNode : this.bpmProcess.getBoundaryEvents()) {
            this.createContainerObjects(bpmFlowNode);
        }
        this.setEventsTarget(this.bpmProcess);
        _sLog.info("adding nodes to their parent subprocesses\n");
        this.assignSubprocessMembers(this.bpmProcess);
        _sLog.info("creating bpmn sequence flows.\n");
        this.createFlows(this.bpmProcess);
        this.setWidthOfBpmnLanesAndPool();
        this.setBpmnPoolHeight();
        this.setDefaultFlows(this.bpmProcess);
        this.bpd.transform(BusinessProcessDiagram.CoordinateOrigins.UPPERLEFT, GraphicalElement.ObjectPin.UPPERLEFT);
        return this.bpd;
    }

    private void assignSubprocessMembers(Process bpmProcess) {
        HashMap<String, HashMap<String, FlowObject>> subprocessMembers = new HashMap<String, HashMap<String, FlowObject>>();
        for (FlowObject bpmnNode : this.bpd.getAllNodes().values()) {
            if (bpmnNode.getParentSubProcess() == null) continue;
            String subprocessId = bpmnNode.getParentSubProcess().getID();
            HashMap<String, FlowObject> childList = (HashMap<String, FlowObject>)subprocessMembers.get(subprocessId);
            if (childList != null) {
                childList.put(bpmnNode.getID(), bpmnNode);
                continue;
            }
            childList = new HashMap<String, FlowObject>();
            subprocessMembers.put(subprocessId, childList);
            childList.put(bpmnNode.getID(), bpmnNode);
        }
        for (String subprocessId : subprocessMembers.keySet()) {
            FlowObject bpmnSubprocess = this.bpd.getNode(subprocessId);
            Map children = (Map)subprocessMembers.get(subprocessId);
            ((Subprocess)bpmnSubprocess).setAllNodes(children);
        }
        LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.bpd.getAllNodes().values());
        for (FlowObject bpmnNode : tmpNodes) {
            if (bpmnNode.getParentSubProcess() == null) continue;
            this.bpd.getAllNodes().values().remove(bpmnNode.getID());
        }
    }

    private void setBpmnPoolHeight() {
        Pool defPool = this.bpd.getPool("P0");
        float sumOfLanesHeight = 0.0f;
        if (defPool.getLanes().size() != 0) {
            for (Lane bpmnLane : defPool.getLanes().values()) {
                sumOfLanesHeight += bpmnLane.getHeight();
            }
        }
        defPool.setHeight(sumOfLanesHeight);
    }

    private void setWidthOfBpmnLanesAndPool() {
        float maxWidth = 0.0f;
        Pool defaultPool = this.bpd.getPool("P0");
        if (defaultPool.getLanes().size() != 0) {
            for (Lane bpmnLane : defaultPool.getLanes().values()) {
                float tempWidth = this.getWidthOfLane(bpmnLane);
                maxWidth = tempWidth > maxWidth ? tempWidth : maxWidth;
            }
            for (Lane bpmnLane : defaultPool.getLanes().values()) {
                bpmnLane.setWidth(maxWidth);
            }
        }
        defaultPool.setWidth(maxWidth);
    }

    private float getWidthOfLane(Swimlane bpmnLane) {
        float maxRB = 0.0f;
        for (FlowObject bpmnNode : this.bpd.getAllNodes().values()) {
            if (!bpmnLane.getID().equals(bpmnNode.getLane().getName())) continue;
            maxRB = bpmnNode.getX() + bpmnNode.getWidth() > maxRB ? bpmnNode.getX() + bpmnNode.getWidth() : maxRB;
        }
        return maxRB;
    }

    private void setDefaultFlows(Process bpmProcess) {
        for (FlowObject bpmnNode : this.bpd.getAllNodes().values()) {
            if (!(bpmnNode instanceof Activity) && !(bpmnNode instanceof Event) && !(bpmnNode instanceof Gateway)) continue;
            int noConditional = 0;
            ConnectingObject defaultFlow = null;
            for (ConnectingObject flow : bpmnNode.getOutflows()) {
                if (((oracle.tutor.bpmn.SequenceFlow)flow).isConditional().booleanValue()) {
                    ++noConditional;
                    continue;
                }
                defaultFlow = flow;
            }
            if (noConditional < true || defaultFlow == null) continue;
            ((oracle.tutor.bpmn.SequenceFlow)defaultFlow).setDefault(true);
        }
    }

    private void setEventsTarget(Process bpmProcess) {
        for (oracle.bpm.project.model.processes.Activity bpmActivity : bpmProcess.getActivities()) {
            this.setEventsTarget(bpmActivity);
        }
    }

    private void setEventsTarget(oracle.bpm.project.model.processes.Activity bpmActivity) {
        Activity bpmnActivity = null;
        if (!bpmActivity.isEvent()) {
            bpmnActivity = (Activity)this.bpd.getNode(bpmActivity.getId());
            for (BoundaryEvent bpmEvent : bpmActivity.getActivityBoundaryEvents()) {
                Event bpmnEvent = (Event)this.bpd.getNode(bpmEvent.getId());
                bpmnEvent.setTarget(bpmnActivity);
            }
        }
        if (bpmnActivity instanceof Subprocess) {
            for (oracle.bpm.project.model.processes.Activity childBpmActivity : bpmActivity.getChildrenByType(oracle.bpm.project.model.processes.Activity.class)) {
                this.setEventsTarget(childBpmActivity);
            }
        }
    }

    private void createFlows(Process bpmProcess) {
        for (SequenceFlow bpmSeqFlow : bpmProcess.getSequenceFlows()) {
            this.createBPMNTransition(bpmSeqFlow);
        }
        Sequence bpmSubprocesses = bpmProcess.getFlowNodes(oracle.bpm.project.model.processes.Subprocess.class);
        Iterator iterator = bpmSubprocesses.iterator();
        while (iterator.hasNext()) {
            this.createFlowsOfSubprocess((oracle.bpm.project.model.processes.Subprocess)iterator.next());
        }
    }

    private void createBPMNTransition(SequenceFlow bpmSeqFlow) {
        FlowObject bpmnFrom = this.bpd.getNode(bpmSeqFlow.getSource().getId());
        FlowObject bpmnTo = this.bpd.getNode(bpmSeqFlow.getTarget().getId());
        String bpmSeqFlowUserName = ((TransitionUserNameFeature)bpmSeqFlow.getFeature(TransitionUserNameFeature.class)).getValue();
        String flowName = bpmSeqFlowUserName != null && !bpmSeqFlowUserName.equals("") ? bpmSeqFlowUserName : "";
        oracle.tutor.bpmn.SequenceFlow bpmnSeqFlow = new oracle.tutor.bpmn.SequenceFlow(bpmSeqFlow.getId(), flowName, bpmnFrom, bpmnTo);
        if (bpmSeqFlow.isConditionalFlow()) {
            if ("".equals(bpmnSeqFlow.getName())) {
                Expression condExp = ((ConditionalFlow)bpmSeqFlow).getCondition();
                String condString = condExp != null ? condExp.getExpressionValue() : "";
                bpmnSeqFlow.setName(condString);
            }
            bpmnSeqFlow.setConditional(true);
        }
        this.bpd.addFlow(bpmnSeqFlow);
    }

    private void createFlowsOfSubprocess(oracle.bpm.project.model.processes.Subprocess bpmSubprocess) {
        for (SequenceFlow bpmSeqFlow : bpmSubprocess.getSequenceFlows()) {
            this.createBPMNTransition(bpmSeqFlow);
        }
        Sequence bpmSubprocesses = bpmSubprocess.getFlowNodes(oracle.bpm.project.model.processes.Subprocess.class);
        Iterator iterator = bpmSubprocesses.iterator();
        while (iterator.hasNext()) {
            this.createFlowsOfSubprocess((oracle.bpm.project.model.processes.Subprocess)iterator.next());
        }
    }

    private void createBPMNTask(FlowNode bpmFlowNode) {
        Task bpmnTask = new Task(bpmFlowNode.getId(), bpmFlowNode.getDefaultLabel());
        this.setParentLane(bpmnTask, bpmFlowNode);
        this.setCommonAttributes(bpmnTask, bpmFlowNode);
        oracle.bpm.project.model.processes.Activity bpmTaskActivity = (oracle.bpm.project.model.processes.Activity)bpmFlowNode;
        BpmnType bpmnType = bpmTaskActivity.getBpmnType();
        bpmnTask.setTaskType(this.getBPMNTaskType(bpmnType));
        LoopCharacteristicsType loopType = bpmTaskActivity.getLoopCharacteristicsType();
        if (loopType != null) {
            bpmnTask.setLoopType(this.getBPMNLoopType(loopType));
        }
    }

    private Activity.LoopType getBPMNLoopType(LoopCharacteristicsType loopType) {
        Activity.LoopType bpmnLoopType = Activity.LoopType.NONE;
        switch (loopType) {
            case LOOP: {
                bpmnLoopType = Activity.LoopType.STANDARD;
                break;
            }
            case MULTIINSTANCE: {
                bpmnLoopType = Activity.LoopType.MULTIINSTANCE;
                break;
            }
            case NONE: {
                bpmnLoopType = Activity.LoopType.NONE;
            }
        }
        return bpmnLoopType;
    }

    private Task.TaskType getBPMNTaskType(BpmnType bpmnType) {
        Task.TaskType taskType = Task.TaskType.NONE;
        taskType = bpmnType == BpmnType.BUSINESS_RULE_TASK ? Task.TaskType.SERVICE : (bpmnType == BpmnType.MANUAL_TASK ? Task.TaskType.MANUAL : (bpmnType == BpmnType.RECEIVE_TASK ? Task.TaskType.RECEIVE : (bpmnType == BpmnType.SCRIPT_TASK ? Task.TaskType.SCRIPT : (bpmnType == BpmnType.SEND_TASK ? Task.TaskType.SEND : (bpmnType == BpmnType.SERVICE_TASK ? Task.TaskType.SERVICE : (bpmnType == BpmnType.USER_TASK ? Task.TaskType.USER : Task.TaskType.NONE))))));
        return taskType;
    }

    private void createBPMNGateway(FlowNode bpmFlowNode) {
        Gateway bpmnGateway = new Gateway(bpmFlowNode.getId(), bpmFlowNode.getDefaultLabel());
        this.setParentLane(bpmnGateway, bpmFlowNode);
        this.setCommonAttributes(bpmnGateway, bpmFlowNode);
        BpmnType gatewayType = bpmFlowNode.getBpmnType();
        if (gatewayType == BpmnType.EXCLUSIVE_GATEWAY) {
            bpmnGateway.setGatewayType(Gateway.GatewayType.XOR_DATA);
            bpmnGateway.setMarkerVisible(true);
        } else if (gatewayType == BpmnType.EVENT_BASED_GATEWAY) {
            bpmnGateway.setGatewayType(Gateway.GatewayType.XOR_EVENT);
        } else if (gatewayType == BpmnType.COMPLEX_GATEWAY) {
            bpmnGateway.setGatewayType(Gateway.GatewayType.COMPLEX);
        } else if (gatewayType == BpmnType.INCLUSIVE_GATEWAY) {
            bpmnGateway.setGatewayType(Gateway.GatewayType.OR);
        } else if (gatewayType == BpmnType.PARALLEL_GATEWAY) {
            bpmnGateway.setGatewayType(Gateway.GatewayType.AND);
        }
    }

    private void createBPMNEvent(FlowNode bpmFlowNode) {
        Event bpmnEvent = new Event(bpmFlowNode.getId(), bpmFlowNode.getDefaultLabel());
        this.setParentLane(bpmnEvent, bpmFlowNode);
        this.setCommonAttributes(bpmnEvent, bpmFlowNode);
        oracle.bpm.project.model.processes.Event tempBpmEvent = (oracle.bpm.project.model.processes.Event)bpmFlowNode;
        if (tempBpmEvent.isStart()) {
            bpmnEvent.setEventType(Event.EventType.START);
            bpmnEvent.setDirection(Event.Direction.CATCH);
        } else if (tempBpmEvent.isEnd()) {
            bpmnEvent.setEventType(Event.EventType.END);
            bpmnEvent.setDirection(Event.Direction.THROW);
        } else {
            bpmnEvent.setEventType(Event.EventType.INTERMEDIATE);
            Event.Direction direction = tempBpmEvent.isThrowEvent() ? Event.Direction.THROW : Event.Direction.CATCH;
            bpmnEvent.setDirection(direction);
        }
        bpmnEvent.setTrigger(this.getTriggerType(tempBpmEvent.getEventTriggerType()));
    }

    private Event.Trigger getTriggerType(EventTriggerType triggerType) {
        Event.Trigger bpmnTriggerType = null;
        if (triggerType == EventTriggerType.CANCEL) {
            bpmnTriggerType = Event.Trigger.CANCEL;
        } else if (triggerType == EventTriggerType.COMPENSATION) {
            bpmnTriggerType = Event.Trigger.COMPENSATION;
        } else if (triggerType == EventTriggerType.CONDITIONAL) {
            bpmnTriggerType = Event.Trigger.CONDITIONAL;
        } else if (triggerType == EventTriggerType.ERROR) {
            bpmnTriggerType = Event.Trigger.ERROR;
        } else if (triggerType == EventTriggerType.LINK) {
            bpmnTriggerType = Event.Trigger.LINK;
        } else if (triggerType == EventTriggerType.MESSAGE) {
            bpmnTriggerType = Event.Trigger.MESSAGE;
        } else if (triggerType == EventTriggerType.MULTIPLE) {
            bpmnTriggerType = Event.Trigger.MULTIPLE;
        } else if (triggerType == EventTriggerType.NONE) {
            bpmnTriggerType = Event.Trigger.NONE;
        } else if (triggerType == EventTriggerType.SIGNAL) {
            bpmnTriggerType = Event.Trigger.SIGNAL;
        } else if (triggerType == EventTriggerType.TERMINATE) {
            bpmnTriggerType = Event.Trigger.TERMINATE;
        } else if (triggerType == EventTriggerType.TIMER) {
            bpmnTriggerType = Event.Trigger.TIMER;
        }
        return bpmnTriggerType;
    }

    private void createBPMNAnnotation(FlowNode bpmFlowNode) {
        Annotation bpmnAnnotation = new Annotation(bpmFlowNode.getId(), bpmFlowNode.getDefaultLabel(), this.bpd);
        FlowNode bpmTarget = ((TextAnnotation)bpmFlowNode).getTarget();
        if (bpmTarget != null) {
            FlowObject bpmnTarget = this.bpd.getNode(bpmTarget.getId());
            Association bpmnAssociation = new Association("a_" + bpmFlowNode.getId(), "", bpmnAnnotation, bpmnTarget);
        }
    }

    private void setParentLane(FlowObject bpmnNode, FlowNode bpmNode) {
        Lane bpmnLane;
        Pool bpmnPool = null;
        if (this.bpd.getPoolByName("Default").getLanes().size() == 0) {
            bpmnPool = this.bpd.getPoolByName("Default");
        }
        if ((bpmnLane = this.getNearestAncestorLane(bpmNode)) == null) {
            bpmnNode.setLane(bpmnPool);
        } else {
            bpmnNode.setLane(bpmnLane);
        }
    }

    private Lane getNearestAncestorLane(FlowNode bpmNode) {
        Lane lane = null;
        lane = bpmNode.getLane() != null ? (Lane)this.bpd.getElement(bpmNode.getLane().getId()) : ((oracle.bpm.project.model.processes.Subprocess)bpmNode.getParentObject() != null && bpmNode.getParentObject() instanceof oracle.bpm.project.model.processes.Subprocess ? this.getNearestAncestorLane((FlowNode)((oracle.bpm.project.model.processes.Subprocess)bpmNode.getParentObject())) : null);
        return lane;
    }

    private void createContainerObjects(FlowNode bpmFlowNode) {
        if (bpmFlowNode instanceof oracle.bpm.project.model.processes.Subprocess) {
            oracle.bpm.project.model.processes.Subprocess bpmSubprocess = (oracle.bpm.project.model.processes.Subprocess)bpmFlowNode;
            Subprocess bpmnSubprocess = new Subprocess(bpmSubprocess.getId(), bpmSubprocess.getDefaultLabel());
            this.setParentLane(bpmnSubprocess, bpmFlowNode);
            this.setCommonAttributes(bpmnSubprocess, (FlowNode)bpmSubprocess);
            bpmnSubprocess.setExpanded(((IsCollapsedFeature)bpmSubprocess.getFeature(IsCollapsedFeature.class)).getValue() == false);
            LoopCharacteristicsType loopType = bpmSubprocess.getLoopCharacteristicsType();
            if (loopType != null) {
                bpmnSubprocess.setLoopType(this.getBPMNLoopType(loopType));
            }
            if (bpmSubprocess.isCallActivity()) {
                bpmnSubprocess.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
            } else {
                Iterator itr;
                bpmnSubprocess.setSubprocessType(Subprocess.SubprocessType.EMBEDDED);
                Sequence childrens = bpmFlowNode.getChildrenByType(FlowNode.class);
                Iterator iterator = itr = childrens != null ? childrens.iterator() : null;
                while (itr != null && itr.hasNext()) {
                    this.createContainerObjects((FlowNode)itr.next());
                }
            }
        } else if (bpmFlowNode.isActivity()) {
            this.createBPMNTask(bpmFlowNode);
        } else if (bpmFlowNode.isGateway()) {
            this.createBPMNGateway(bpmFlowNode);
        } else if (bpmFlowNode.isEvent() || bpmFlowNode instanceof BoundaryEvent) {
            this.createBPMNEvent(bpmFlowNode);
        } else if (bpmFlowNode instanceof TextAnnotation) {
            this.createBPMNAnnotation(bpmFlowNode);
        }
    }

    private void setCommonAttributes(FlowObject bpmnNode, FlowNode bpmNode) {
        bpmnNode.setHeight(2.25 * (double)bpmNode.getHeight());
        bpmnNode.setWidth(2.25 * (double)bpmNode.getWidth());
        bpmnNode.setX(bpmNode.getX());
        bpmnNode.setY(bpmNode.getY());
        if (bpmNode.getDefaultDescription() != null) {
            bpmnNode.setDocumentation(bpmNode.getDefaultDescription());
        }
        if (bpmNode.getSubprocess() != null) {
            FlowObject bpmnParentSubprocess = this.bpd.getNode(bpmNode.getSubprocess().getId());
            bpmnNode.setParentSubProcess((Subprocess)bpmnParentSubprocess);
        }
    }
}

