/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.tutor.bpmapi.BPMNTree;
import oracle.bpm.tutor.bpmapi.BPMNTreeNode;
import oracle.bpm.tutor.bpmapi.Utils;
import oracle.bpm.tutor.bpmapi.createBPMActivityClient;
import oracle.bpm.tutor.bpmapi.createBPMGraphicalElements;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Pool;

class CreateBPMActivitiesRecursively
extends createBPMGraphicalElements {
    private List<Event> _bpmnBoundaryEvents = new LinkedList<Event>();
    private createBPMActivityClient _createClient;
    private LinkedList<ConversionMessage> _messages;
    private BPMNTreeNode _root = null;

    public CreateBPMActivitiesRecursively(Process bpmProcess, BusinessProcessDiagram bpd, LinkedList<ConversionMessage> messages) {
        this._messages = messages;
        this.setBpmProcess(bpmProcess);
        this.setBpd(bpd);
        this._createClient = new createBPMActivityClient(this._messages);
    }

    @Override
    public void create(Pool poolToExport) throws ProjectException {
        BPMNTree tree = new BPMNTree(this.getBpd().getAllNodes().values());
        this._root = tree.create(poolToExport);
        for (BPMNTreeNode treeNode : this._root.getChilds()) {
            FlowObject boundaryEvent = treeNode.getFlowObject();
            if (boundaryEvent instanceof Event && ((Event)boundaryEvent).getTarget() != null) {
                this._bpmnBoundaryEvents.add((Event)boundaryEvent);
                continue;
            }
            this._createClient.createAndSetCommand(treeNode.getFlowObject(), (NodeContainer)this.getBpmProcess());
            this._createClient.createBPMActivity();
            this._create(treeNode);
        }
        this._createBoundaryEvents();
    }

    private void _createBoundaryEvents() throws ProjectException {
        for (Event bpmnEvent : this._bpmnBoundaryEvents) {
            Process container = this.getBpmProcess();
            if (bpmnEvent.getParentSubProcess() != null) {
                container = (Subprocess)Utils.findNode(bpmnEvent.getParentSubProcess().getID(), (NodeContainer)this.getBpmProcess());
            }
            this._createClient.createAndSetCommand(bpmnEvent, (NodeContainer)container);
            this._createClient.createBPMActivity();
        }
    }

    private void _create(BPMNTreeNode subprocessNode) throws ProjectException {
        for (BPMNTreeNode childTreeNode : subprocessNode.getChilds()) {
            FlowObject boundaryEvent = childTreeNode.getFlowObject();
            if (boundaryEvent instanceof Event && ((Event)boundaryEvent).getTarget() != null) {
                this._bpmnBoundaryEvents.add((Event)boundaryEvent);
                continue;
            }
            Subprocess bpmSubprocess = (Subprocess)Utils.findNode(subprocessNode.getId(), (NodeContainer)this.getBpmProcess());
            this._createClient.createAndSetCommand(childTreeNode.getFlowObject(), (NodeContainer)bpmSubprocess);
            this._createClient.createBPMActivity();
            this._create(childTreeNode);
        }
    }
}

