/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.tutor.bpmapi.BPMProject;
import oracle.bpm.tutor.bpmapi.Page;
import oracle.bpm.tutor.bpmapi.PageUtils;
import oracle.bpm.tutor.bpmapi.io;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.ProgressNotifier;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.visio.UserCancelException;

class ConversionTaskToBPM {
    private String errors = "";
    private int errorsCtr = 0;
    private static Logger mlog = Logger.getLogger(ConversionTaskToBPM.class.getName());

    ConversionTaskToBPM() {
    }

    public boolean startConversion(File inputFile, Project bpmProject, String xmlFolder, ProgressNotifier notifier, boolean mergePools) {
        notifier.setFilename(inputFile.getName());
        BusinessProcessDiagram[] bpdArray = null;
        io.FileExtension extn = io.getFileExtension(inputFile.getAbsolutePath());
        int chunkAssignedToThisFile = notifier.getChunk();
        notifier.setChunk((int)((double)chunkAssignedToThisFile * 0.6));
        try {
            notifier.update("Reading File", 10.0);
            bpdArray = io.importModel(inputFile.getAbsolutePath(), notifier, xmlFolder);
        }
        catch (UserCancelException e) {
            this.saveErrorMessage(inputFile, "Model importing has been cancelled.", e, notifier, chunkAssignedToThisFile);
            return false;
        }
        catch (RuntimeException e) {
            if (!"File type not supported".equalsIgnoreCase(e.getMessage())) {
                this.saveErrorMessage(inputFile, "Error" + e.getMessage(), e, notifier, chunkAssignedToThisFile);
                return false;
            }
            this.saveErrorMessage(inputFile, "File type not supported", e, notifier, chunkAssignedToThisFile);
            return false;
        }
        catch (Exception e) {
            this.saveErrorMessage(inputFile, "Error", e, notifier, chunkAssignedToThisFile);
            return false;
        }
        LinkedList<BusinessProcessDiagram> tempBPDList = new LinkedList<BusinessProcessDiagram>();
        int ctr = 0;
        for (BusinessProcessDiagram bpd : bpdArray) {
            if (bpd.getAllNodes() != null && bpd.getAllNodes().values().size() != 0) {
                tempBPDList.add(bpd);
                if (io.getFileExtension(inputFile.getAbsolutePath()) != io.FileExtension.WFT) {
                    bpd.transform(BusinessProcessDiagram.CoordinateOrigins.UPPERLEFT, GraphicalElement.ObjectPin.UPPERLEFT);
                }
                try {
                    bpd.scale(50.0, 50.0);
                }
                catch (Exception e) {
                    bpd.layout(75.0, 50.0);
                }
                if (extn == io.FileExtension.XPDL) {
                    bpd.convertToRelativeCoordinates();
                }
                if (extn == io.FileExtension.VDX) {
                    for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
                        if (!(bpmnNode instanceof Subprocess) || bpmnNode.getParentSubProcess() != null) continue;
                        this._makeRelativeChilds((Subprocess)bpmnNode);
                    }
                }
                if (extn == io.FileExtension.WFT) continue;
                for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
                    bpmnNode.setObjectPin(GraphicalElement.ObjectPin.MIDDLE);
                    bpmnNode.setX(bpmnNode.getX() + bpmnNode.getWidth() / 2.0f);
                    bpmnNode.setY(bpmnNode.getY() + bpmnNode.getHeight() / 2.0f);
                }
                continue;
            }
            mlog.warning("\"" + bpd.getName() + "\" contains no tasks, and hence it cannot be imported.");
        }
        BusinessProcessDiagram[] tempBPDArray = new BusinessProcessDiagram[tempBPDList.size()];
        ctr = 0;
        for (BusinessProcessDiagram bpd : tempBPDList) {
            tempBPDArray[ctr++] = bpd;
        }
        bpdArray = tempBPDArray;
        notifier.setChunk((int)((double)chunkAssignedToThisFile * 0.4));
        notifier.update("Converting to BPM", 30.0);
        BPMProject prj = new BPMProject();
        if (extn == io.FileExtension.DOCX) {
            mergePools = true;
        }
        Page[] pages = PageUtils.createPages(bpdArray, mergePools);
        try {
            prj.exportPages(pages, bpmProject);
        }
        catch (ProjectException e) {
            this.saveErrorMessage(inputFile, "Error", e, notifier, chunkAssignedToThisFile);
            return false;
        }
        catch (Exception e) {
            this.saveErrorMessage(inputFile, "Error", e, notifier, chunkAssignedToThisFile);
            return false;
        }
        notifier.update("Model imported successfully", 100.0);
        return true;
    }

    String getErrors() {
        return this.errors;
    }

    private void _makeRelativeChilds(Subprocess bpmnSubprocess) {
        if (bpmnSubprocess.getAllNodes().values() != null && bpmnSubprocess.getAllNodes().values().size() != 0) {
            for (FlowObject child : bpmnSubprocess.getAllNodes().values()) {
                if (child instanceof Subprocess) {
                    this._makeRelativeChilds((Subprocess)child);
                }
                child.setX(child.getX() - bpmnSubprocess.getX());
                child.setY(child.getY() - bpmnSubprocess.getY());
            }
        }
    }

    private void saveErrorMessage(File inputFile, String message, Throwable e, ProgressNotifier notifier, int chunkAssignedToThisFile) {
        notifier.update(message, 100.0);
        notifier.setChunk(chunkAssignedToThisFile - notifier.getChunk());
        notifier.update(message, 100.0);
        StringWriter result = new StringWriter();
        PrintWriter pw = new PrintWriter(result);
        e.printStackTrace(pw);
        this.errors = this.errors + ++this.errorsCtr + ". " + inputFile.getName() + "\n" + ((Object)result).toString();
    }
}

