/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.FileLock;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.bpmapi.BPMProject;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.ProgressNotifier;
import oracle.tutor.docx.TutorDoc;
import org.xml.sax.SAXException;

class ConversionTask {
    private String errors = "";
    private int errorsCtr = 0;

    ConversionTask() {
    }

    public boolean startConversion(Process bpmProcess, ProgressNotifier notifier, String opTutorFileName, String outputDir) {
        try {
            File opTutorFile = new File(outputDir + File.separator + opTutorFileName);
            FileLock lock = new FileOutputStream(opTutorFile).getChannel().tryLock();
            if (lock == null) {
                throw new FileNotFoundException("File is being used by another program");
            }
            lock.release();
            lock = null;
            opTutorFile = null;
        }
        catch (FileNotFoundException e) {
            this.saveErrorMessage(opTutorFileName, "File is being used by another program", e, null);
            return false;
        }
        catch (Exception e) {
            this.saveErrorMessage(opTutorFileName, e.getMessage(), e, null);
            return false;
        }
        notifier.setFilename(bpmProcess.getName());
        notifier.update(String.format("Reading %s", bpmProcess.getName()), 10.0);
        BPMProject bpmProj = new BPMProject();
        BusinessProcessDiagram bpd = bpmProj.importBPM(bpmProcess);
        notifier.update("Saving " + opTutorFileName, 70.0);
        TutorDoc td = new TutorDoc();
        try {
            bpd.transform(BusinessProcessDiagram.CoordinateOrigins.UPPERLEFT, GraphicalElement.ObjectPin.UPPERLEFT);
            td.loadBPD(bpd, null, "EN");
        }
        catch (FileNotFoundException e) {
            this.saveErrorMessage(opTutorFileName, "ERROR: Unable to locate Tutor configuration file.", e, notifier);
            return false;
        }
        catch (Exception e) {
            this.saveErrorMessage(opTutorFileName, "ERROR: " + e.getMessage(), e, notifier);
            return false;
        }
        try {
            td.toDocx(outputDir, opTutorFileName);
        }
        catch (ParserConfigurationException e) {
            this.saveErrorMessage(opTutorFileName, "ERROR: Unable to initialize XML Parser. See log for details.", e, notifier);
            return false;
        }
        catch (IOException e) {
            this.saveErrorMessage(opTutorFileName, "ERROR: Unable to save file. See log for details.", e, notifier);
            return false;
        }
        catch (SAXException e) {
            this.saveErrorMessage(opTutorFileName, "ERROR: XML exception. See log for details.", e, notifier);
            return false;
        }
        catch (Exception e) {
            this.saveErrorMessage(opTutorFileName, "ERROR: Unable to convert to Tutor format. See log for details.", e, notifier);
            return false;
        }
        notifier.update("Model exported successfully", 100.0);
        return true;
    }

    String getErrors() {
        return this.errors;
    }

    private void saveErrorMessage(String outputFileName, String message, Throwable e, ProgressNotifier notifier) {
        if (notifier != null) {
            notifier.update(message, 100.0);
        }
        StringWriter result = new StringWriter();
        PrintWriter pw = new PrintWriter(result);
        e.printStackTrace(pw);
        this.errors = this.errors + ++this.errorsCtr + ". " + outputFileName + "\n" + ((Object)result).toString();
    }
}

