/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.io.serializers.model.DefaultModelFormat;
import oracle.bpm.project.io.serializers.model.ProcessModelFormat;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.bpmapi.ImportBPM;
import oracle.bpm.tutor.bpmapi.Page;
import oracle.bpm.tutor.bpmapi.Utils;
import oracle.bpm.tutor.bpmapi.createBPMProcess;
import oracle.bpm.type.TypeUtils;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.Pool;

public class BPMProject {
    private Pool _exportSpecificPool = null;
    private exportType _expType = exportType.SEPERATE_EACH_POOL;
    private BusinessProcessDiagram bpd;
    private Process bpmProcess;
    private static final Logger _sLog = Logger.getLogger(BPMProject.class.getName());

    public void exportNewBPMProject(BusinessProcessDiagram[] bpdArray, String bpmProjectDir) throws ProjectException {
        this.exportNewBPMProject(bpdArray, new File(bpmProjectDir));
    }

    public void exportNewBPMProject(BusinessProcessDiagram[] bpdArray, File bpmProjectDir) throws ProjectException {
        Project bpmProject = this.createNewBPMProject(bpmProjectDir);
        File bpmProjectFolder = new File(bpmProjectDir.getAbsolutePath(), bpmProjectDir.getName() + " Project");
        for (BusinessProcessDiagram bpd : bpdArray) {
            if (this._expType == exportType.MERGE_POOLS) {
                _sLog.info("creating bpmProcess for bpd : " + bpd.getName() + "\n");
                this.createBPMProcessInProject(bpd, bpmProject, bpmProjectFolder);
                continue;
            }
            Iterator<Pool> i$ = bpd.getPools().values().iterator();
            while (i$.hasNext()) {
                Pool pool;
                this._exportSpecificPool = pool = i$.next();
                _sLog.info("creating bpmProcess for bpd pool : " + pool.getName());
                this.createBPMProcessInProject(bpd, bpmProject, bpmProjectFolder);
            }
        }
    }

    public void exportNewBPMProject(BusinessProcessDiagram bpd, String bpmProjectDir) throws ProjectException {
        File projectDir = new File(new File(bpmProjectDir), "project");
        this.exportNewBPMProject(bpd, projectDir);
    }

    public void exportNewBPMProject(BusinessProcessDiagram bpd, File bpmProjectDir) throws ProjectException {
        Project bpmProject = this.createNewBPMProject(bpmProjectDir);
        File bpmProjectFolder = new File(bpmProjectDir.getAbsolutePath(), bpmProjectDir.getName() + " Project");
        createBPMProcess processCreator = new createBPMProcess(bpd, bpmProject);
        Process process = processCreator.create(null);
        if (process != null) {
            _sLog.info("writing " + bpd.getName() + ".bpmn file\n");
            this._writeBPMNFile(process, bpmProjectFolder);
        }
    }

    public void createBPMProcessInProject(BusinessProcessDiagram bpd, Project bpmProject, String bpmProjectDir) throws ProjectException {
        _sLog.info("creating bpmProcess for bpd : " + bpd.getName() + "\n");
        this.createBPMProcessInProject(bpd, bpmProject, new File(bpmProjectDir));
    }

    public void createBPMProcessInProject(BusinessProcessDiagram bpd, Project bpmProject, File bpmProjectDir) throws ProjectException {
        createBPMProcess processCreator = new createBPMProcess(bpd, bpmProject);
        Process process = processCreator.create(null);
        if (process != null) {
            _sLog.info("writing " + process.getId() + ".bpmn file\n");
            this._writeBPMNFile(process, bpmProjectDir);
        }
    }

    public void exportPages(Page[] pages, Project bpmProject) throws ProjectException {
        createBPMProcess processCreator = null;
        for (Page page : pages) {
            processCreator = new createBPMProcess(page.getBPD(), bpmProject);
            page.validateSettings();
            if (page.getExpType() == Page.ExportType.MERGE_POOLS) {
                this._exportSpecificPool = null;
                processCreator.create(this._exportSpecificPool);
                continue;
            }
            LinkedList<Pool> exportPools = page.getExportPools();
            BusinessProcessDiagram bpd = page.getBPD();
            if (exportPools != null) continue;
            exportPools = new LinkedList();
            if (bpd.getPools().size() != 0) {
                for (Pool pool : bpd.getPools().values()) {
                    if (!Utils.poolHasChild(pool, bpd)) continue;
                    exportPools.add(pool);
                }
                Iterator<Pool> i$ = exportPools.iterator();
                while (i$.hasNext()) {
                    Pool pool;
                    this._exportSpecificPool = pool = i$.next();
                    processCreator.create(this._exportSpecificPool);
                }
                continue;
            }
            exportPools = null;
            processCreator.create(null);
        }
    }

    public BusinessProcessDiagram importBPM(String absoluteFilePath) {
        return this.importBPM(new File(absoluteFilePath));
    }

    public BusinessProcessDiagram importBPM(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.importBPM(fileInputStream);
    }

    public BusinessProcessDiagram importBPM(FileInputStream fileInputStream) {
        _sLog.info("\n\n\n=================================\nbpm -> bpd conversion _sLog\n=================================\n\n");
        ProcessContent bpmProcess = this._loadFile(fileInputStream);
        return this.importBPM((Process)bpmProcess);
    }

    public BusinessProcessDiagram importBPM(Process bpmProcess) {
        ImportBPM importBPMN = new ImportBPM(bpmProcess);
        return importBPMN.importBPMNProcess();
    }

    private void _conversionLog() {
        _sLog.info("\n\n\n=================================\nbpm conversion log\n=================================\n\n");
    }

    private Project createNewBPMProject(File bpmProjectDir) throws ProjectException {
        this._conversionLog();
        FileProjectRepository repository = FileProjectRepository.create((File)bpmProjectDir);
        Project bpmProject = repository.create(bpmProjectDir.getName() + " Project");
        return bpmProject;
    }

    private void _writeBPMNFile(Process content, File bpmProjectFolder) {
        ProcessModelFormat modelFormat = new ProcessModelFormat();
        FileOutputStream fos = null;
        try {
            String processesFolderPath = bpmProjectFolder.getAbsolutePath() + File.separator + "processes";
            File processesFolder = new File(processesFolderPath);
            if (!processesFolder.exists()) {
                boolean folderCreated = false;
                try {
                    folderCreated = processesFolder.createNewFile();
                }
                catch (IOException e) {
                    if (!folderCreated) {
                        throw new RuntimeException("\"" + processesFolderPath + "\" doesn't exist and cannot be created. " + e.getMessage());
                    }
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (processesFolder.exists()) {
                fos = new FileOutputStream(new File(processesFolder, this.bpmProcess.getName() + ".bpmn"));
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            this.bpmProcess.getProject().getWriter().write(new ProjectObject[]{this.bpmProcess.getProject().getOrganization()});
            if (fos == null) {
                _sLog.severe("'.bpmn' file cannot be created\n");
                throw new RuntimeException("'.bpmn' file cannot be created");
            }
            modelFormat.writeXml(content, (Writer)new OutputStreamWriter((OutputStream)fos, Literals.DEFAULT_ENCODING));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (ProjectException e) {
            throw new RuntimeException("bpmn file cannot be written : " + e.getMessage());
        }
    }

    private ProcessContent _loadFile(FileInputStream fileInputStream) {
        ProcessContent process = new ProcessContent(null, null);
        process.setComponentCatalog(TypeUtils.getDefaultCatalog());
        try {
            DefaultModelFormat.load((Process)process, (InputStream)fileInputStream);
        }
        catch (ProjectException e) {
            throw new RuntimeException(e.getMsg().getDetail());
        }
        return process;
    }

    private static enum exportType {
        MERGE_POOLS,
        SEPERATE_EACH_POOL;

    }
}

