/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.Collection;
import java.util.HashSet;
import oracle.tutor.bpmn.FlowObject;

class BPMNTreeNode {
    private HashSet<BPMNTreeNode> _childs = new HashSet();
    private FlowObject _flowObject = null;
    private String _id = null;
    private BPMNTreeNode _parent = null;

    BPMNTreeNode(FlowObject flowObject) {
        this._flowObject = flowObject;
        if (flowObject != null) {
            this._id = flowObject.getID();
        }
    }

    BPMNTreeNode(FlowObject flowObject, BPMNTreeNode parent) {
        this._flowObject = flowObject;
        if (flowObject != null) {
            this._id = flowObject.getID();
        }
        this._parent = parent;
        if (parent != null) {
            parent.add(this);
        }
    }

    Collection<BPMNTreeNode> getChilds() {
        return this._childs;
    }

    FlowObject getFlowObject() {
        return this._flowObject;
    }

    String getId() {
        return this._id;
    }

    void setParent(BPMNTreeNode parent) {
        this._parent = parent;
    }

    BPMNTreeNode getParent() {
        return this._parent;
    }

    BPMNTreeNode getChild(String id) {
        if (id.equals(this._id)) {
            return this;
        }
        return this.getChild(id, this);
    }

    void add(BPMNTreeNode node) {
        node.setParent(this);
        this._childs.add(node);
    }

    void remove(BPMNTreeNode node) {
        this._childs.remove(node);
    }

    void printTree() {
        for (BPMNTreeNode child : this._childs) {
            System.out.println(child.getId());
            this.printTree(child);
        }
    }

    void printTree(BPMNTreeNode node) {
        for (BPMNTreeNode child : node._childs) {
            System.out.println(child.getId());
            this.printTree(child);
        }
    }

    private BPMNTreeNode getChild(String id, BPMNTreeNode node) {
        BPMNTreeNode result = null;
        if (id.equals(node._id)) {
            result = node;
            return result;
        }
        for (BPMNTreeNode child : node._childs) {
            if (result != null) break;
            result = this.getChild(id, child);
        }
        return result;
    }
}

