/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.Collection;
import java.util.LinkedList;
import oracle.bpm.tutor.bpmapi.BPMNTreeNode;
import oracle.bpm.tutor.bpmapi.Utils;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Task;

class BPMNTree {
    private Collection<FlowObject> _bpmnAllNodes = null;
    private BPMNTreeNode _root = new BPMNTreeNode(null);

    BPMNTree(Collection<FlowObject> allNodesCollection) {
        this._bpmnAllNodes = allNodesCollection;
    }

    public static void main(String[] args) {
        Task t1 = new Task("1", "1");
        Task t2 = new Task("3", "3");
        Task st1 = new Task("21", "21");
        Task st2 = new Task("22", "22");
        Subprocess s1 = new Subprocess("2", "2");
        st1.setParentSubProcess(s1);
        st2.setParentSubProcess(s1);
        LinkedList<FlowObject> allNodes = new LinkedList<FlowObject>();
        allNodes.add(t1);
        allNodes.add(t2);
        allNodes.add(st1);
        allNodes.add(st2);
        allNodes.add(s1);
        BPMNTree tree = new BPMNTree(allNodes);
        tree.create(null);
        tree.printTree();
    }

    public void printTree() {
        this._root.printTree();
    }

    BPMNTreeNode create(Pool poolToExport) {
        for (FlowObject node : this._bpmnAllNodes) {
            if (!Utils.isInPool(node, poolToExport)) continue;
            BPMNTreeNode temp = new BPMNTreeNode(node);
            this._root.add(temp);
        }
        for (FlowObject node : this._bpmnAllNodes) {
            if (!Utils.isInPool(node, poolToExport) || node.getParentSubProcess() == null) continue;
            BPMNTreeNode branchNode = this._root.getChild(node.getParentSubProcess().getID());
            BPMNTreeNode childNode = this._root.getChild(node.getID());
            this._root.remove(childNode);
            branchNode.add(childNode);
        }
        return this._root;
    }
}

