/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpm.analytics.cube.persistence.PersistenceService;

public class TemplateViewCreator {
    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.out.println("Usage:");
            System.out.println("    java oracle.bpm.analytics.cube.persistence.util.TemplateViewCreator <ctx> <protocol> <host> <port> <username>\n");
            System.out.println("Example:");
            System.out.println("    java oracle.bpm.analytics.cube.persistence.util.TemplateViewCreator CreateTemplateView weblogic.jndi.WLInitialContextFactory t3 localhost 7001 weblogic\n");
        }
        System.out.print("Please input password: ");
        TemplateViewCreator.main(args, TemplateViewCreator.readPassword(System.in));
    }

    public static void main(String[] args, char[] password) throws Exception {
        String ctx = args[0];
        String protocol = args[1];
        String host = args[2];
        String port = args[3];
        String username = args[4];
        TemplateViewCreator.createAllTemplateViews(ctx, protocol, host, port, username, password);
    }

    public static void createAllTemplateViews(String ctx, String protocol, String host, String port, String username, char[] password) throws Exception {
        InitialContext jndiContext = null;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        String url = protocol.concat("://").concat(host).concat(":").concat(new Integer(port).toString());
        properties.put("java.naming.factory.initial", ctx);
        properties.put("java.naming.provider.url", url);
        properties.put("java.naming.security.principal", username);
        properties.put("java.naming.security.credentials", new String(password));
        System.out.println("INITIAL_CONTEXT_FACTORY = " + ctx);
        System.out.println("PROVIDER_URL = " + url);
        System.out.println("SECURITY_PRINCIPAL = " + username);
        System.out.println("Getting initial context...");
        try {
            jndiContext = new InitialContext(properties);
        }
        catch (NamingException e) {
            System.err.println("Could not obtain JNDI Context.");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Getting ejb interface...");
        PersistenceService pcs = null;
        try {
            pcs = (PersistenceService)jndiContext.lookup("BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceService");
        }
        catch (NamingException e) {
            System.err.println("Could not obtain PersistenceService.");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Creating all template views...");
        try {
            pcs.createTemplateSpecificViews();
        }
        catch (NamingException e) {
            System.err.println("Could not create template views.");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Finished.  Check server logs for errors.");
    }

    public static void createTemplateView(String templateName, String ctx, String protocol, String host, String port, String username, char[] password) throws Exception {
        InitialContext jndiContext = null;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        String url = protocol.concat("://").concat(host).concat(":").concat(new Integer(port).toString());
        properties.put("java.naming.factory.initial", ctx);
        properties.put("java.naming.provider.url", url);
        properties.put("java.naming.security.principal", username);
        properties.put("java.naming.security.credentials", new String(password));
        System.out.println("INITIAL_CONTEXT_FACTORY = " + ctx);
        System.out.println("PROVIDER_URL = " + url);
        System.out.println("SECURITY_PRINCIPAL = " + username);
        System.out.println("Getting initial context...");
        try {
            jndiContext = new InitialContext(properties);
        }
        catch (NamingException e) {
            System.err.println("Could not obtain JNDI Context.");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Getting ejb interface...");
        PersistenceService pcs = null;
        try {
            pcs = (PersistenceService)jndiContext.lookup("BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceService");
        }
        catch (NamingException e) {
            System.err.println("Could not obtain PersistenceService.");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Creating template views for " + templateName + "...");
        try {
            pcs.createTemplateSpecificView(null, null, templateName, false);
        }
        catch (NamingException e) {
            System.err.println("Could not create template views.");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Finished.  Check server logs for errors.");
    }

    private static char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }
}

