/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;

@Entity
@NamedQueries(value={@NamedQuery(name="CubeGlobalCreateTask.findAll", query="select o from CubeGlobalCreateTask o")})
@Table(name="BPM_CUBE_GLOBALCREATETASK")
public class CubeGlobalCreateTask
implements Serializable {
    @Column(name="ACTIVITYID", nullable=false)
    private Long activityId;
    @Column(name="ACTIVITYLABEL", length=500)
    private String activityLabel;
    @Column(name="ACTIVITYNAME", length=256)
    private String activityName;
    @Column(name="APPLICATIONCONTEXT", length=200)
    private String applicationContext;
    @JoinColumn(name="PROCESSID", referencedColumnName="PROCESSID")
    @ManyToOne
    private CubeProcess cubeProcess;
    @Column(name="PROCESSID", nullable=false, insertable=false, updatable=false)
    @Id
    private Long processId;
    @Column(name="ROLE", length=400)
    private String role;
    @Column(name="SYSTEMSTRING01", length=400)
    private String systemString01;
    @Column(name="SYSTEMSTRING02", length=400)
    private String systemString02;
    @Column(name="SYSTEMSTRING03", length=400)
    private String systemString03;
    public static final long serialVersionUID = 1L;

    public CubeGlobalCreateTask() {
    }

    public CubeGlobalCreateTask(CubeProcess cubeProcess, String role) {
        this.cubeProcess = cubeProcess;
        this.role = role;
    }

    public CubeGlobalCreateTask(CubeProcess cubeProcess, String activityName, String activityLabel, String role, String applicationContext) {
        this.cubeProcess = cubeProcess;
        this.activityName = activityName;
        this.activityLabel = activityLabel;
        this.role = role;
        this.applicationContext = applicationContext;
    }

    public CubeProcess getCubeProcess() {
        return this.cubeProcess;
    }

    public void setCubeProcess(CubeProcess cubeProcess) {
        this.cubeProcess = cubeProcess;
        if (cubeProcess != null) {
            this.processId = cubeProcess.getProcessId();
        }
    }

    public Long getProcessid() {
        return this.processId;
    }

    public void setProcessid(Long processid) {
        this.processId = processid;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityLabel() {
        return this.activityLabel;
    }

    public void setActivityLabel(String activityLabel) {
        this.activityLabel = activityLabel;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getSystemString01() {
        return this.systemString01;
    }

    public void setSystemString01(String systemString01) {
        this.systemString01 = systemString01;
    }

    public String getSystemString02() {
        return this.systemString02;
    }

    public void setSystemString02(String systemString02) {
        this.systemString02 = systemString02;
    }

    public String getSystemString03() {
        return this.systemString03;
    }

    public void setSystemString03(String systemString03) {
        this.systemString03 = systemString03;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
}

