/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubeActivityProperty;
import oracle.bpm.analytics.cube.persistence.model.CubeActivitySequenceFlow;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.cube.persistence.model.CubeTaskPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;

@Entity(name="CubeActivity")
@NamedQueries(value={@NamedQuery(name="CubeActivity.findAll", query="select o from CubeActivity o")})
@Table(name="BPM_CUBE_ACTIVITY")
public class CubeActivity
implements Serializable {
    @Column(name="ACTIVITYID", nullable=false)
    @GeneratedValue(generator="CubeDefaultIdGenerator", strategy=GenerationType.TABLE)
    @Id
    private Long activityId;
    @Column(name="ACTIVITYNAME", length=256)
    private String activityName;
    @Column(name="ACTIVITYTYPE", length=64)
    private String activityType;
    @Column(name="CONDITION", length=2000)
    private String condition;
    @OneToMany(mappedBy="cubeActivity", targetEntity=CubeActivityProperty.class, cascade={CascadeType.REMOVE})
    private List<CubeActivityProperty> cubeActivityPropertyList;
    @JoinColumn(name="PROCESSID")
    @ManyToOne
    private CubeProcess cubeProcess;
    @OneToMany(mappedBy="cubeActivity", cascade={CascadeType.REMOVE})
    private List<CubeTaskPerformance> cubeTaskPerformanceList;
    @OneToMany(mappedBy="cubeActivity", cascade={CascadeType.REMOVE})
    private List<CubeWorkload> cubeWorkloadList;
    @Column(name="DOCUMENTATION", length=2000)
    private String documentation;
    @Column(name="EXPRESSION", length=2000)
    private String expression;
    @Column(name="EXTENSIONREF", length=2000)
    private String extensionRef;
    @Column(name="EXTENSIONTYPE", length=100)
    private String extensionType;
    @Column(name="HASPARALLELBRANCH", length=1)
    private String hasParallelBranch;
    @Column(name="ISEXTENSION", length=1)
    private String isExtension;
    @Column(name="ISJOIN", length=1)
    private String isJoin;
    @Column(name="ISSPLIT", length=1)
    private String isSplit;
    @Column(name="ISSWITCH", length=1)
    private String isSwitch;
    @Column(name="ISSWITCHCASE", length=1)
    private String isSwitchCase;
    @Column(name="ISSWITCHOTHER", length=1)
    private String isSwitchOther;
    @Column(name="ISWSOPERATION", length=1)
    private String isWsOperation;
    @Column(name="LABEL", length=500)
    private String label;
    @Column(name="NODEBRANCH", length=512)
    private String nodeBranch;
    @Column(name="NODEID", length=15)
    private String nodeId;
    @Column(name="NODELEVEL")
    private Long nodeLevel;
    @Column(name="NODESEQNUM")
    private Long nodeSeqNum;
    @Column(name="OPERATION", length=200)
    private String operation;
    @Column(name="PART", length=200)
    private String part;
    @Column(name="PARTNERID")
    private Long partnerId;
    @Column(name="PATTERN", length=64)
    private String pattern;
    @Column(name="PORTTYPE", length=400)
    private String portType;
    @Column(name="PROCESSID", nullable=false, insertable=false, updatable=false)
    private Long processId;
    @Column(name="SOURCECODE")
    private char[] sourceCode;
    @OneToMany(mappedBy="sourceCubeActivity", targetEntity=CubeActivitySequenceFlow.class)
    private List<CubeActivitySequenceFlow> sourceCubeActivitySequenceFlowList;
    @OneToMany(mappedBy="targetCubeActivity", targetEntity=CubeActivitySequenceFlow.class)
    private List<CubeActivitySequenceFlow> targetCubeActivitySequenceFlowList;
    @Column(name="VARIABLE", length=200)
    private String variable;
    public static final long serialVersionUID = 1L;

    public CubeActivity() {
    }

    public CubeActivity(CubeProcess cubeProcess, String activityname, String activitytype, String label, String documentation, String condition, String expression, String extensionref, String extensiontype, String hasparallelbranch, String isextension, String isjoin, String issplit, String isswitch, String isswitchcase, String isswitchother, String iswsoperation, String nodebranch, String nodeid, Long nodelevel, Long nodeseqnum, String operation, String part, Long partnerid, String pattern, String porttype, String variable) {
        this.activityName = activityname;
        this.activityType = activitytype;
        this.condition = condition;
        this.documentation = documentation;
        this.expression = expression;
        this.extensionRef = extensionref;
        this.extensionType = extensiontype;
        this.hasParallelBranch = hasparallelbranch;
        this.isExtension = isextension;
        this.isJoin = isjoin;
        this.isSplit = issplit;
        this.isSwitch = isswitch;
        this.isSwitchCase = isswitchcase;
        this.isSwitchOther = isswitchother;
        this.isWsOperation = iswsoperation;
        this.label = label;
        this.nodeBranch = nodebranch;
        this.nodeId = nodeid;
        this.nodeLevel = nodelevel;
        this.nodeSeqNum = nodeseqnum;
        this.operation = operation;
        this.part = part;
        this.partnerId = partnerid;
        this.pattern = pattern;
        this.portType = porttype;
        this.cubeProcess = cubeProcess;
        this.variable = variable;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityname) {
        this.activityName = activityname;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activitytype) {
        this.activityType = activitytype;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExtensionRef() {
        return this.extensionRef;
    }

    public void setExtensionRef(String extensionref) {
        this.extensionRef = extensionref;
    }

    public String getExtensionType() {
        return this.extensionType;
    }

    public void setExtensionType(String extensiontype) {
        this.extensionType = extensiontype;
    }

    public String getHasParallelBranch() {
        return this.hasParallelBranch;
    }

    public void setHasParallelBranch(String hasparallelbranch) {
        this.hasParallelBranch = hasparallelbranch;
    }

    public String getIsExtension() {
        return this.isExtension;
    }

    public void setIsExtension(String isextension) {
        this.isExtension = isextension;
    }

    public String getIsJoin() {
        return this.isJoin;
    }

    public void setIsJoin(String isjoin) {
        this.isJoin = isjoin;
    }

    public String getIsSplit() {
        return this.isSplit;
    }

    public void setIsSplit(String issplit) {
        this.isSplit = issplit;
    }

    public String getIsSwitch() {
        return this.isSwitch;
    }

    public void setIsSwitch(String isswitch) {
        this.isSwitch = isswitch;
    }

    public String getIsSwitchCase() {
        return this.isSwitchCase;
    }

    public void setIsSwitchCase(String isswitchcase) {
        this.isSwitchCase = isswitchcase;
    }

    public String getIsSwitchOther() {
        return this.isSwitchOther;
    }

    public void setIsSwitchOther(String isswitchother) {
        this.isSwitchOther = isswitchother;
    }

    public String getIsWsOperation() {
        return this.isWsOperation;
    }

    public void setIsWsOperation(String iswsoperation) {
        this.isWsOperation = iswsoperation;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getNodeBranch() {
        return this.nodeBranch;
    }

    public void setNodeBranch(String nodebranch) {
        this.nodeBranch = nodebranch;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeid) {
        this.nodeId = nodeid;
    }

    public Long getNodeLevel() {
        return this.nodeLevel;
    }

    public void setNodeLevel(Long nodelevel) {
        this.nodeLevel = nodelevel;
    }

    public Long getNodeSequenceNumber() {
        return this.nodeSeqNum;
    }

    public void setNodeSequenceNumber(Long nodeseqnum) {
        this.nodeSeqNum = nodeseqnum;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public Long getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(Long partnerid) {
        this.partnerId = partnerid;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPortType() {
        return this.portType;
    }

    public void setPortType(String porttype) {
        this.portType = porttype;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processid) {
        this.processId = processid;
    }

    public char[] getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(char[] sourcecode) {
        this.sourceCode = sourcecode;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public List<CubeWorkload> getCubeWorkloadList() {
        return this.cubeWorkloadList;
    }

    public void setCubeWorkloadList(List<CubeWorkload> cubeWorkloadList) {
        this.cubeWorkloadList = cubeWorkloadList;
    }

    public CubeWorkload addCubeWorkload(CubeWorkload cubeWorkload) {
        this.getCubeWorkloadList().add(cubeWorkload);
        cubeWorkload.setCubeActivity(this);
        return cubeWorkload;
    }

    public CubeWorkload removeCubeWorkload(CubeWorkload cubeWorkload) {
        this.getCubeWorkloadList().remove(cubeWorkload);
        cubeWorkload.setCubeActivity(null);
        return cubeWorkload;
    }

    public List<CubeActivityProperty> getCubeActivityPropertyList() {
        return this.cubeActivityPropertyList;
    }

    public void setCubeActivityPropertyList(List<CubeActivityProperty> cubeActivityPropertyList) {
        this.cubeActivityPropertyList = cubeActivityPropertyList;
    }

    public CubeActivityProperty addCubeActivityProperty(CubeActivityProperty cubeActivityProperty) {
        this.getCubeActivityPropertyList().add(cubeActivityProperty);
        cubeActivityProperty.setCubeActivity(this);
        return cubeActivityProperty;
    }

    public CubeActivityProperty removeCubeActivityProperty(CubeActivityProperty cubeActivityProperty) {
        this.getCubeActivityPropertyList().remove(cubeActivityProperty);
        cubeActivityProperty.setCubeActivity(null);
        return cubeActivityProperty;
    }

    public CubeProcess getCubeProcess() {
        return this.cubeProcess;
    }

    public void setCubeProcess(CubeProcess cubeProcess) {
        this.cubeProcess = cubeProcess;
        if (cubeProcess != null) {
            this.processId = cubeProcess.getProcessId();
        }
    }

    public List<CubeTaskPerformance> getCubeTaskPerformanceList() {
        return this.cubeTaskPerformanceList;
    }

    public void setCubeTaskPerformanceList(List<CubeTaskPerformance> cubeTaskPerformanceList) {
        this.cubeTaskPerformanceList = cubeTaskPerformanceList;
    }

    public CubeTaskPerformance addCubeTaskPerformance(CubeTaskPerformance cubeTaskPerformance) {
        this.getCubeTaskPerformanceList().add(cubeTaskPerformance);
        cubeTaskPerformance.setCubeActivity(this);
        return cubeTaskPerformance;
    }

    public CubeTaskPerformance removeCubeTaskPerformance(CubeTaskPerformance cubeTaskPerformance) {
        this.getCubeTaskPerformanceList().remove(cubeTaskPerformance);
        cubeTaskPerformance.setCubeActivity(null);
        return cubeTaskPerformance;
    }

    public List<CubeActivitySequenceFlow> getSourceCubeActivitySequenceFlowList() {
        return this.sourceCubeActivitySequenceFlowList;
    }

    public void setSourceCubeActivitySequenceFlowList(List<CubeActivitySequenceFlow> cubeActivitySequenceFlowList) {
        this.sourceCubeActivitySequenceFlowList = cubeActivitySequenceFlowList;
    }

    public List<CubeActivitySequenceFlow> getTargetCubeActivitySequenceFlowList() {
        return this.targetCubeActivitySequenceFlowList;
    }

    public void setTargetCubeActivitySequenceFlowList(List<CubeActivitySequenceFlow> cubeActivitySequenceFlowList) {
        this.targetCubeActivitySequenceFlowList = cubeActivitySequenceFlowList;
    }

    public CubeActivitySequenceFlow addSourceCubeActivitySequenceFlow(CubeActivitySequenceFlow cubeActivitySequenceFlow) {
        this.getSourceCubeActivitySequenceFlowList().add(cubeActivitySequenceFlow);
        cubeActivitySequenceFlow.setSourceCubeActivity(this);
        return cubeActivitySequenceFlow;
    }

    public CubeActivitySequenceFlow addTargetCubeActivitySequenceFlow(CubeActivitySequenceFlow cubeActivitySequenceFlow) {
        this.getTargetCubeActivitySequenceFlowList().add(cubeActivitySequenceFlow);
        cubeActivitySequenceFlow.setTargetCubeActivity(this);
        return cubeActivitySequenceFlow;
    }

    public CubeActivitySequenceFlow removeSourceCubeActivitySequenceFlow(CubeActivitySequenceFlow cubeActivitySequenceFlow) {
        this.getSourceCubeActivitySequenceFlowList().remove(cubeActivitySequenceFlow);
        cubeActivitySequenceFlow.setSourceCubeActivity(null);
        return cubeActivitySequenceFlow;
    }

    public CubeActivitySequenceFlow removeTargetCubeActivitySequenceFlow(CubeActivitySequenceFlow cubeActivitySequenceFlow) {
        this.getTargetCubeActivitySequenceFlowList().remove(cubeActivitySequenceFlow);
        cubeActivitySequenceFlow.setTargetCubeActivity(null);
        return cubeActivitySequenceFlow;
    }
}

