/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.common;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class AnalyticsUtil {
    private static final String PROPERTIES_FILE = "oracle/bpm/analytics/common/CodeVersion.properties";
    private static final String CODE_VERSION_PROPERTY = "CODE_VERSION";
    private static final String CODE_VERSION_SQL_QUERY = "SELECT GUID from VERSION";

    public static boolean isBPMEnabled() {
        if (System.getProperty("bpm.enabled") != null) {
            return Boolean.getBoolean("bpm.enabled");
        }
        return false;
    }

    public static String getCurrentCodeVersion() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream(PROPERTIES_FILE);
        if (is == null) {
            throw new Exception("Can't read oracle/bpm/analytics/common/CodeVersion.properties");
        }
        Properties properties = new Properties();
        properties.load(is);
        String currentCodeVersion = properties.getProperty(CODE_VERSION_PROPERTY);
        if (currentCodeVersion != null) {
            currentCodeVersion = currentCodeVersion.trim();
        }
        return currentCodeVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSOADBSchemaVersion(Connection connection) throws Exception {
        if (connection == null) {
            throw new Exception("Connection is null");
        }
        Statement stmt = null;
        ResultSet rs = null;
        String dbSchemaVersion = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(CODE_VERSION_SQL_QUERY);
            if (rs != null && rs.next()) {
                dbSchemaVersion = rs.getString(1);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        if (dbSchemaVersion != null) {
            dbSchemaVersion = dbSchemaVersion.trim();
        }
        return dbSchemaVersion;
    }
}

