/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.action.persistence.model;

import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@NamedQueries(value={@NamedQuery(name="BpmMeasurementActions.findAll", query="select o from BpmMeasurementActions o order by o.queryId, o.actionName"), @NamedQuery(name="BpmMeasurementActions.findByName", query="select o from BpmMeasurementActions o where o.actionName = :actionName order by o.queryId desc"), @NamedQuery(name="BpmMeasurementActions.findByNameAndId", query="select o from BpmMeasurementActions o where o.queryId = :queryId and o.actionName = :actionName order by o.queryId")})
@Table(name="BPM_MEASUREMENT_ACTIONS", uniqueConstraints={@UniqueConstraint(columnNames={"QUERY_ID", "ACTION_NAME"})})
public class BpmMeasurementActions
implements Serializable {
    @Column(name="ACTION_INVOCATION_ID")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="ActionIdGenerator")
    @Id
    private Long actionInvocationId;
    @Column(name="ACTION_NAME", length=1000)
    private String actionName;
    @Column(name="AUDIT_QUERY_TIME")
    private Timestamp auditQueryTime;
    @Column(name="COMPONENT_INSTANCE_ID", length=200)
    private String componentInstanceId;
    @Column(name="COMPOSITE_INSTANCE_ID", length=200)
    private String compositeInstanceId;
    @Column(name="ECID")
    private String ecId;
    @Column(name="CI_PARTITION_DATE")
    private Timestamp partitionDate;
    @Column(name="QUERY_ID")
    private Long queryId;
    @Column(name="TENANT_ID")
    private Long tenantId;
    static final long serialVersionUID = -7326989178943125422L;

    public BpmMeasurementActions() {
        this.tenantId = -1L;
    }

    public BpmMeasurementActions(Long actionInvocationId, String actionName, Timestamp auditQueryTime, Long queryId) {
        this.actionInvocationId = actionInvocationId;
        this.actionName = actionName;
        this.auditQueryTime = auditQueryTime;
        this.queryId = queryId;
        this.tenantId = -1L;
    }

    public Long getActionInvocationId() {
        return this.actionInvocationId;
    }

    public void setActionInvocationId(Long actionInvocationId) {
        this.actionInvocationId = actionInvocationId;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public Timestamp getAuditQueryTime() {
        return this.auditQueryTime;
    }

    public void setAuditQueryTime(Timestamp auditQueryTime) {
        this.auditQueryTime = auditQueryTime;
    }

    public Long getQueryId() {
        return this.queryId;
    }

    public void setQueryId(Long queryId) {
        this.queryId = queryId;
    }

    public Long getTenantId() {
        if (this.tenantId == null) {
            return -1L;
        }
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
        if (this.tenantId == null) {
            this.tenantId = -1L;
        }
    }

    public void setComponentInstanceId(String componentInstanceId) {
        this.componentInstanceId = componentInstanceId;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public void setCompositeInstanceId(String compositeInstanceId) {
        this.compositeInstanceId = compositeInstanceId;
    }

    public String getCompositeInstanceId() {
        return this.compositeInstanceId;
    }

    public void setPartitionDate(Timestamp partitionDate) {
        this.partitionDate = partitionDate;
    }

    public Timestamp getPartitionDate() {
        return this.partitionDate;
    }

    public void setECId(String ecId) {
        this.ecId = ecId;
    }

    public String getECId() {
        return this.ecId;
    }
}

