/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.action.persistence;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpm.analytics.action.ActionInvocationException;
import oracle.bpm.analytics.action.persistence.ActionPersistenceService;
import oracle.bpm.analytics.action.persistence.ActionQueryService;
import oracle.bpm.analytics.action.persistence.DuplicateActionProcessingException;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActionExceps;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActions;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditInstance;

public class ActionUtil {
    private static final String CLASS_NAME = "oracle.bpm.analytics.action.persistence.ActionUtil";
    private static ActionPersistenceService aps;
    private static ActionQueryService aqs;

    public static BpmMeasurementActions markProcessing(String actionName, IAuditInstance ai) throws Exception {
        String METHOD_NAME = "markProcessing";
        Long key = ai != null ? ai.getQueryId() : 0L;
        if (key == 0L) {
            throw new ActionInvocationException(CLASS_NAME, "Key is 0");
        }
        Calendar createTime = ai != null ? ai.getCreateTime() : new GregorianCalendar(0, 0, 0);
        String componentInstanceId = ai != null ? ai.getComponentInstanceId() : null;
        String compositeInstanceId = ai != null ? ai.getCompositeInstanceId() : null;
        String ecId = ai != null ? ai.getECID() : null;
        Long tenantId = ai != null ? Long.valueOf(ai.getTenantId()) : null;
        Timestamp partitionDate = ai != null ? new Timestamp(ai.getPartitionDate().getTimeInMillis()) : null;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"markProcessing", (String)("MARKING PROCESSING:" + key + ";" + createTime.getTime()));
        BpmMeasurementActions s = ActionUtil.getAps().createMeasurementAction(actionName, key, new Timestamp(createTime.getTimeInMillis()), componentInstanceId, compositeInstanceId, partitionDate, ecId, tenantId);
        return s;
    }

    public static void markFailed(IAuditInstance ai, String exception, String msg, String actionName) throws Exception {
        String METHOD_NAME = "markFailed";
        Long key = ai != null ? ai.getQueryId() : 0L;
        Calendar createTime = ai != null ? ai.getCreateTime() : new GregorianCalendar(0, 0, 0);
        String componentInstanceId = ai != null ? ai.getComponentInstanceId() : null;
        String compositeInstanceId = ai != null ? ai.getCompositeInstanceId() : null;
        String ecId = ai != null ? ai.getECID() : null;
        Long tenantId = ai != null ? Long.valueOf(ai.getTenantId()) : null;
        Timestamp partitionDate = ai != null ? new Timestamp(ai.getPartitionDate().getTimeInMillis()) : null;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"markFailed", (String)("INSERTING INTO ACTION_EXCEPTION_LOG KEY:" + actionName + " Failed for Audit Instance: " + key + ";" + "with exception: " + exception + " and message: " + msg));
        ActionUtil.getAps().createMeasurementActionException(exception, msg, new Timestamp(createTime.getTimeInMillis()), actionName, key, "Error", componentInstanceId, compositeInstanceId, partitionDate, ecId, tenantId);
    }

    public static int markLastUpdated(IAuditInstance ai, String actionName) throws DuplicateActionProcessingException, NamingException, Exception {
        String METHOD_NAME = "markLastUpdated";
        Long key = ai != null ? ai.getQueryId() : 0L;
        Calendar createTime = ai != null ? ai.getCreateTime() : null;
        String componentInstanceId = ai != null ? ai.getComponentInstanceId() : null;
        String compositeInstanceId = ai != null ? ai.getCompositeInstanceId() : null;
        String ecId = ai != null ? ai.getECID() : null;
        Long tenantId = ai != null ? Long.valueOf(ai.getTenantId()) : null;
        Timestamp partitionDate = ai != null ? new Timestamp(ai.getPartitionDate().getTimeInMillis()) : null;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"markLastUpdated", (String)("INSERTING  INTO ACTION_LOG KEY:" + actionName + " Completed for Audit Instance: " + key + "created at : " + createTime.toString()));
        ActionUtil.getAps().createMeasurementAction(actionName, key, new Timestamp(createTime.getTimeInMillis()), componentInstanceId, compositeInstanceId, partitionDate, ecId, tenantId);
        return key.intValue();
    }

    public static int markLastUpdated(Long key, Calendar time, String actionName, String componentInstanceId, String compositeInstanceId, Timestamp partitionDate, String ecId, Long tenantId) throws DuplicateActionProcessingException, NamingException, Exception {
        String METHOD_NAME = "markLastUpdated";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"markLastUpdated", (String)("INSERTING  INTO ACTION_LOG KEY:" + actionName + " Completed for Audit Instance: " + key + "created at : " + time.toString()));
        ActionUtil.getAps().createMeasurementAction(actionName, key, new Timestamp(time.getTimeInMillis()), componentInstanceId, compositeInstanceId, partitionDate, ecId, tenantId);
        return key.intValue();
    }

    public static void removeMeasurementActions(BpmMeasurementActions measurementAction) throws Exception {
        String METHOD_NAME = "removeMeasurementActions";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeMeasurementActions", (String)("Remove Meaurement Action for query id: " + measurementAction.getQueryId()));
        ActionUtil.getAps().remove(measurementAction);
    }

    public static int removeMeasurementActionsForQuery(Long queryId, String commandName) throws Exception {
        String METHOD_NAME = "removeMeasurementActionsUsingNameAndQueryId";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeMeasurementActionsUsingNameAndQueryId", (String)("Remove Meaurement Action for query id: " + queryId + " Action Name: " + commandName));
        return ActionUtil.getAps().removeActionForQuery(queryId, commandName);
    }

    public static boolean isMessageAlreadyProcessed(String actionName, Long queryId) throws Exception {
        List<BpmMeasurementActions> measurementActionList = ActionUtil.getAqs().selectMeasurementActions(actionName, queryId);
        return measurementActionList != null && !measurementActionList.isEmpty();
    }

    public static boolean isMessageAlreadyFailed(String actionName, Long queryId) throws Exception {
        List<BpmMeasurementActionExceps> measurementActionExceptionList = ActionUtil.getAqs().selectMeasurementActionExceptions(actionName, queryId);
        return measurementActionExceptionList != null && !measurementActionExceptionList.isEmpty();
    }

    private static ActionPersistenceService getAps() throws NamingException {
        if (aps == null) {
            InitialContext ctx = new InitialContext();
            aps = (ActionPersistenceService)ctx.lookup("BPMAnalytics#oracle.bpm.analytics.action.persistence.ActionPersistenceService");
        }
        return aps;
    }

    private static ActionQueryService getAqs() throws NamingException {
        if (aqs == null) {
            InitialContext ctx = new InitialContext();
            aqs = (ActionQueryService)ctx.lookup("BPMAnalytics#oracle.bpm.analytics.action.persistence.ActionQueryService");
        }
        return aqs;
    }
}

