/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.action;

import java.util.HashMap;
import java.util.List;
import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.analytics.action.ICommand;
import oracle.bpm.analytics.action.persistence.ActionUtil;
import oracle.bpm.analytics.measurement.IMeasuredData;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.ejb.IInstanceQueryServiceRemote;
import oracle.bpm.services.internal.InternalBPMContext;

public abstract class AbstractActionInvoker {
    private static IInstanceQueryService iqs;
    private static final String CUSTOM_EXCEPTION = "Custom Exception";
    private static final String CLASS_NAME = "oracle.bpm.analytics.action.AbstractActionInvoker";

    public abstract ICommand getCommand();

    public void processMessage(Message msg) {
        boolean isLeaderNode;
        boolean bl = isLeaderNode = BPMNServiceEngine.getInstance().getClusterInterface() == null || BPMNServiceEngine.getInstance().getClusterInterface().isLeader();
        if (!isLeaderNode) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"processMessage", (String)"Exiting message processing, not Leader Node.");
            return;
        }
        if (msg instanceof ObjectMessage) {
            if (msg == null) {
                this.handleException(null, "Message is NULL in process message", ((Object)this.getCommand()).toString(), CUSTOM_EXCEPTION);
                return;
            }
            try {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processMessage", (String)("Property actionList value: " + msg.getStringProperty("actionList")));
                if (((ObjectMessage)msg).getObject() instanceof IMeasuredData) {
                    IMeasuredData data = (IMeasuredData)((ObjectMessage)msg).getObject();
                    if (data == null) {
                        this.handleException(null, "Measured Data is NULL in process message", ((Object)this.getCommand()).toString(), CUSTOM_EXCEPTION);
                        return;
                    }
                    List queryIdList = data.getKeyList();
                    if (queryIdList == null || queryIdList.isEmpty()) {
                        this.handleException(null, "QueryId List is NULL or Zero length.", ((Object)this.getCommand()).toString(), CUSTOM_EXCEPTION);
                        return;
                    }
                    IBPMContext bpmContext = InternalBPMContext.getInternalBPMContext();
                    HashMap<String, List> parameterMap = new HashMap<String, List>();
                    parameterMap.put("IDLIST", data.getKeyList());
                    List aqList = AbstractActionInvoker.getInstanceQueryService().queryAuditInstances(bpmContext, "aq.queryId IN :IDLIST order by aq.queryId asc", parameterMap);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processMessage", (String)("AQ List size: " + aqList.size()));
                    if (aqList.isEmpty()) {
                        for (Object qId : queryIdList) {
                            this.handleException(null, " Instance Query Service returns no audit records for Query Id: " + qId, ((Object)this.getCommand()).toString(), CUSTOM_EXCEPTION);
                        }
                    }
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processMessage", (String)"Processing Audit Instances...");
                    for (IAuditInstance pAuditInstance : aqList) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processMessage", (String)("QueryId: " + pAuditInstance.getQueryId()));
                        this.processAuditInstance(pAuditInstance, (ObjectMessage)msg);
                    }
                } else if (((ObjectMessage)msg).getObject() instanceof IAuditInstance) {
                    IAuditInstance auditInstance = (IAuditInstance)((ObjectMessage)msg).getObject();
                    this.processAuditInstance(auditInstance, (ObjectMessage)msg);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processMessage", (String)"Message is IAuditInstance.");
                } else {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processMessage", (String)"Object Message published of unexpected type.");
                    this.handleException(null, "Object Message published of unexpected type.", ((Object)this.getCommand()).toString(), CUSTOM_EXCEPTION);
                }
            }
            catch (EJBException ee) {
                throw ee;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                this.handleException(null, e.getMessage(), ((Object)this.getCommand()).toString(), e);
            }
        }
    }

    private static IInstanceQueryService getInstanceQueryService() throws NamingException {
        if (iqs != null) {
            return iqs;
        }
        InitialContext ctx = new InitialContext();
        IInstanceQueryServiceRemote iqs = (IInstanceQueryServiceRemote)PortableRemoteObject.narrow((Object)ctx.lookup("ejb/bpm/services/InstanceQueryServiceBean"), IInstanceQueryServiceRemote.class);
        return iqs;
    }

    private void processAuditInstance(IAuditInstance auditInstance, ObjectMessage msg) {
        if (auditInstance == null) {
            this.handleException(null, "Audit Instance Object is NULL", ((Object)this.getCommand()).toString(), CUSTOM_EXCEPTION);
            return;
        }
        if (auditInstance.getQueryId() == null) {
            this.handleException(null, "Audit Instance QueryId is NULL", ((Object)this.getCommand()).toString(), CUSTOM_EXCEPTION);
            return;
        }
        try {
            if (msg.getJMSRedelivered()) {
                this.handleRedelivery(auditInstance, ((Object)this.getCommand()).toString());
                return;
            }
            boolean forcePublish = this.isForcePublish(msg);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"processMessage", (String)((forcePublish ? "Force " : "") + "Processing auditinstance message with query id: " + auditInstance.getQueryId()));
            this.getCommand().execute(auditInstance);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processAuditInstance", (String)("Calling Action Util: = Message" + msg + " ,Command: " + this.getCommand() + " , AuditInstance = " + auditInstance.getQueryId()));
            if (!forcePublish || !ActionUtil.isMessageAlreadyProcessed(((Object)this.getCommand()).toString(), auditInstance.getQueryId())) {
                ActionUtil.markProcessing(((Object)this.getCommand()).toString(), auditInstance);
            }
        }
        catch (Exception e) {
            this.handleException(auditInstance, e.getMessage(), ((Object)this.getCommand()).toString(), e);
        }
    }

    private void handleException(IAuditInstance ai, String message, String commandName, String exceptionName) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"handleException", (String)("Action Execution Error: " + message + (ai != null ? "  Query id = " + ai.getQueryId() : "") + (commandName != null ? "  Action Name : " + commandName : "")));
        try {
            ActionUtil.markFailed(ai, exceptionName, message, ((Object)this.getCommand()).toString());
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    private void handleException(IAuditInstance ai, String message, String commandName, Exception exception) {
        String exceptionName = "";
        if (exception != null) {
            exceptionName = exception.getClass().getName();
        }
        this.handleException(ai, message, commandName, exceptionName);
        if (exception != null && this.isCausedByEJBExceptionOrError(exception)) {
            throw new EJBException(exception);
        }
    }

    private void handleRedelivery(IAuditInstance ai, String commandName) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"handleRedelivery", (String)"Redilivery due to System Exception ");
        if (ActionUtil.isMessageAlreadyProcessed(commandName, ai.getQueryId())) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleRedelivery", (String)("Duplicate message found. Message is already processed Command: " + this.getCommand() + " , AuditInstance = " + ai.getQueryId()));
            return;
        }
        if (ActionUtil.isMessageAlreadyFailed(commandName, ai.getQueryId())) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleRedelivery", (String)("Duplicate message found. Message is already marked failed Command: " + this.getCommand() + " , AuditInstance = " + ai.getQueryId()));
            return;
        }
        this.handleException(ai, "Redelivery due to System Exception - check logs", commandName, CUSTOM_EXCEPTION);
    }

    private boolean isCausedByEJBExceptionOrError(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof EJBException || throwable instanceof Error) {
            return true;
        }
        Throwable cause = throwable.getCause();
        return this.isCausedByEJBExceptionOrError(cause);
    }

    private boolean isForcePublish(ObjectMessage msg) throws JMSException {
        String property = msg.getStringProperty("forcePublish");
        return property != null && Boolean.parseBoolean(property);
    }
}

