/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.ProcessServiceSession;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public class SessionUtils {
    public static final String SESSION_VERSION_11G = "11g";
    public static final String SESSION_VERSION_10G = "10g";
    private static final String SESSION_CLASS_ADAPTER_11G = "oracle.bpm.papi.ora.ProcessServiceSessionAdapter";

    public static String getSessionVersion(@NotNull ProcessServiceSession session) {
        if (SESSION_CLASS_ADAPTER_11G.equalsIgnoreCase(session.getClass().getName())) {
            return SESSION_VERSION_11G;
        }
        return SESSION_VERSION_10G;
    }

    public static boolean refreshSession(@NotNull ProcessServiceSession session) {
        if (SESSION_VERSION_11G.equals(SessionUtils.getSessionVersion(session))) {
            try {
                Method method = session.getClass().getMethod("refresh", new Class[0]);
                method.invoke((Object)session, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return true;
    }
}

