/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.ProcessServiceSession;
import java.util.Map;
import java.util.TreeMap;

public class SessionCache {
    private final Map<String, CacheEntry> sessionsCache = new TreeMap<String, CacheEntry>();
    private final SessionTimeOutChecker sessionTimeOutCheck;
    private final long timeout;

    private SessionCache(long timeout) {
        this.timeout = timeout;
        this.sessionTimeOutCheck = new SessionTimeOutChecker();
        this.sessionTimeOutCheck.start();
    }

    public static SessionCache create(long timeout) {
        return new SessionCache(timeout);
    }

    public ProcessServiceSession getSession(String sessionId) {
        CacheEntry entry = this.sessionsCache.get(sessionId);
        if (entry != null) {
            return entry.update();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String sessionId) {
        CacheEntry entry;
        Map<String, CacheEntry> map = this.sessionsCache;
        synchronized (map) {
            entry = this.sessionsCache.remove(sessionId);
        }
        if (entry != null) {
            entry.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, CacheEntry> map = this.sessionsCache;
        synchronized (map) {
            for (CacheEntry entry : this.sessionsCache.values()) {
                entry.closeSession();
            }
            this.sessionsCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putSession(ProcessServiceSession session) {
        Map<String, CacheEntry> map = this.sessionsCache;
        synchronized (map) {
            this.sessionsCache.put(session.getId(), new CacheEntry(session));
        }
        return session.getId();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.sessionTimeOutCheck.end();
        this.clear();
    }

    private final class SessionTimeOutChecker
    extends Thread {
        private boolean run = true;

        @Override
        public void run() {
            while (this.run) {
                TreeMap sessions = new TreeMap();
                sessions.putAll(SessionCache.this.sessionsCache);
                for (Map.Entry entry : sessions.entrySet()) {
                    if (((CacheEntry)entry.getValue()).isValid()) continue;
                    SessionCache.this.removeSession((String)entry.getKey());
                }
                try {
                    SessionTimeOutChecker.sleep(SessionCache.this.timeout / 3L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void end() {
            this.run = false;
        }
    }

    private final class CacheEntry {
        private long duetime;
        private final ProcessServiceSession session;

        public CacheEntry(ProcessServiceSession session) {
            this.session = session;
            this.duetime = System.currentTimeMillis() + SessionCache.this.timeout;
        }

        public ProcessServiceSession update() {
            this.duetime = System.currentTimeMillis() + SessionCache.this.timeout;
            return this.session;
        }

        public void closeSession() {
            if (this.session.isOpened()) {
                this.session.close();
            }
        }

        public boolean isValid() {
            return this.duetime > System.currentTimeMillis();
        }
    }
}

