/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.attachment.AttachmentStorageType;
import fuego.papi.utils.BackwardsCompatibilitySupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class AttachmentUtils
implements BackwardsCompatibilitySupport<AttachmentOperations> {
    private static final AttachmentUtils instance = new AttachmentUtils();

    public static void instanceAttach(@NotNull ProcessServiceSession session, @NotNull InstanceInfo instanceInfo, @NotNull String name, String description, String remarks, @NotNull InputStream attachment, String contentType, Locale locale, AttachmentStorageType storageType) throws OperationException, IOException {
        AttachmentUtils.getInstance().getImplementation(session).instanceAttach(session, instanceInfo, name, description, remarks, attachment, contentType, locale, storageType);
    }

    @Override
    public AttachmentOperations getImplementation(@NotNull ProcessServiceSession session) throws OperationException {
        return BackwardsCompatibilitySupport.Utils.loadImplementation(this, session);
    }

    @Override
    public String getImplementationClassName(@NotNull ProcessServiceSession session) {
        if (session.getClass().getName().equals("oracle.bpm.papi.ora.ProcessServiceSessionAdapter")) {
            return "oracle.bpm.papi.ora.util.AttachmentOperations11G";
        }
        return "fuego.papi.utils.AttachmentUtils.AttachmentOperations10G";
    }

    private static AttachmentUtils getInstance() {
        return instance;
    }

    private static class AttachmentOperations10G
    implements AttachmentOperations {
        private AttachmentOperations10G() {
        }

        @Override
        public void instanceAttach(@NotNull ProcessServiceSession session, @NotNull InstanceInfo instanceInfo, @NotNull String name, String description, String remarks, @NotNull InputStream attachment, String contentType, Locale locale, AttachmentStorageType storageType) throws OperationException, IOException {
            int length;
            String filePath = "/tmp/" + System.currentTimeMillis();
            File file = new File(filePath);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = attachment.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, length);
            }
            fileOutputStream.close();
            session.instanceAttach(instanceInfo, name, description, remarks, file, contentType, locale, storageType);
        }
    }

    public static interface AttachmentOperations {
        public void instanceAttach(@NotNull ProcessServiceSession var1, @NotNull InstanceInfo var2, @NotNull String var3, String var4, String var5, @NotNull InputStream var6, String var7, Locale var8, AttachmentStorageType var9) throws OperationException, IOException;
    }
}

