/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.msg.PapiMsg;
import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.lang.EnumType;
import org.jetbrains.annotations.NonNls;

@Component(module="Fuego.Lib")
public class InstanceItemState
implements EnumType {
    public static final int PENDING = 1;
    public static final int FAILED = 2;
    public static final int INSTANCE_ROUTED = 4;
    public static final int COMPLETED = 8;
    public static final int SELECTED = 16;
    public static final int RUNNING = 32;
    public static final int ACTIVITY_COMPLETED = 64;
    public static final int WAS_COMPLETED = 128;
    @NonNls
    private static final String[] names_sd = new String[]{"PENDING", "FAILED", "INSTANCE_ROUTED", "COMPLETED", "SELECTED", "RUNNING", "ACTIVITY_COMPLETED", "WAS_COMPLETED"};
    private static int[] values_sd = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

    public static String getDescription(int state, Locale locale) {
        if (InstanceItemState.is(state, 1)) {
            return PapiMsg.TASK_PENDING.getString(locale);
        }
        if (InstanceItemState.is(state, 2)) {
            return PapiMsg.TASK_FAILED.getString(locale);
        }
        if (InstanceItemState.is(state, 8)) {
            return PapiMsg.COMPLETED.getString(locale);
        }
        if (InstanceItemState.is(state, 16)) {
            return PapiMsg.TASK_SELECTED.getString(locale);
        }
        if (InstanceItemState.is(state, 32)) {
            return PapiMsg.TASK_RUNNING.getString(locale);
        }
        if (InstanceItemState.is(state, 64)) {
            return PapiMsg.INSTANCE_ACTIVITY_COMPLETED.getString(locale);
        }
        if (InstanceItemState.is(state, 4)) {
            return PapiMsg.INSTANCE_ROUTED.getString(locale);
        }
        if (InstanceItemState.is(state, 128)) {
            return PapiMsg.WAS_COMPLETED.getString(locale);
        }
        throw new IllegalArgumentException("Invalid task status [" + state + "]");
    }

    public static String getId(int val) {
        val = InstanceItemState.getIndex(val);
        return names_sd[val];
    }

    public static String getName(int val) {
        if ((val & 8) != 0 && (val & 0x40) != 0) {
            val &= 0xFFFFFFBF;
        }
        if ((val & 0x18) > 0) {
            val &= 0xFFFFFFEF;
        }
        return InstanceItemState.getId(val &= 0xFFFFFF7F);
    }

    public static boolean is(int state, int mask) {
        return (state & mask) > 0;
    }

    public static int valueOf(String id) {
        int result = -1;
        for (int i = 0; i < names_sd.length; ++i) {
            if (!names_sd[i].equalsIgnoreCase(id)) continue;
            result = i;
            break;
        }
        return values_sd[result];
    }

    private static int getIndex(int val) {
        for (int i = 0; i < values_sd.length; ++i) {
            int k = values_sd[i];
            if (k != val) continue;
            return i;
        }
        assert (false) : "Value not in table:" + val;
        return 0;
    }
}

