/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.exception.InvalidArgumentType;
import fuego.papi.exception.NoSuchArgumentException;
import fuego.papi.msg.PapiMsg;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.ArgMap;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Time;
import org.jetbrains.annotations.NonNls;

public class Arguments {
    private ArgumentMap arguments;
    @NonNls
    public static final String ACTION = "BPMethod_action";
    @NonNls
    public static final String RESULT = "BPMethod_result";

    private Arguments(ArgumentMap arguments) {
        this.arguments = arguments;
    }

    public static Arguments create() {
        return new Arguments(DynamicObject.create());
    }

    public static Arguments create(ArgumentMap arguments) {
        return new Arguments(arguments);
    }

    public Object getArgument(String name) {
        this.validateName(name);
        Object argument = this.arguments.getArgument(name, Object.class);
        if (argument instanceof DynamicObject) {
            DynamicObject dynamicObject = (DynamicObject)argument;
            argument = dynamicObject.objectValue();
        }
        return argument;
    }

    public Map<String, Object> getArguments() {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        Map<String, Object> fieldMap = this.arguments.asMap();
        if (fieldMap != null && fieldMap.size() > 0) {
            arguments.putAll(fieldMap);
        }
        return arguments;
    }

    public String[] getArgumentsName() {
        Map<String, Object> fieldMap = this.arguments.asMap();
        return fieldMap == null || fieldMap.isEmpty() ? new String[]{} : fieldMap.keySet().toArray(new String[fieldMap.size()]);
    }

    public boolean getBooleanArgument(String name) {
        this.validateName(name);
        DynamicObject value = this.arguments.getArgument(name, DynamicObject.class);
        if (!value.isBool()) {
            throw new InvalidArgumentType(PapiMsg.PAPI_6022(name));
        }
        return value.booleanValue();
    }

    @Exclude
    public DynamicObject getCILArguments() {
        return this.arguments.asDynamicObject();
    }

    public double getDoubleArgument(String name) {
        this.validateName(name);
        DynamicObject value = this.arguments.getArgument(name, DynamicObject.class);
        if (!value.isDecimal() && !value.isReal()) {
            throw new InvalidArgumentType(PapiMsg.PAPI_6023(name));
        }
        return value.doubleValue();
    }

    public DynamicObject getDynamicObject() {
        return this.arguments.asDynamicObject();
    }

    public DynamicObject getDynamicObjectArgument(String name) {
        this.validateName(name);
        return this.arguments.getArgument(name, DynamicObject.class);
    }

    public long getLongArgument(String name) {
        this.validateName(name);
        DynamicObject value = this.arguments.getArgument(name, DynamicObject.class);
        if (!value.isInt()) {
            throw new InvalidArgumentType(PapiMsg.PAPI_6024(name));
        }
        return value.longValue();
    }

    public Time getTimeArgument(String name) {
        this.validateName(name);
        DynamicObject value = this.arguments.getArgument(name, DynamicObject.class);
        if (!value.isTime()) {
            throw new InvalidArgumentType(PapiMsg.PAPI_6025(name));
        }
        return value.timeValue();
    }

    public boolean containsArgument(String name) {
        return this.arguments.contains(name);
    }

    public void putArgument(String name, boolean value) {
        this.arguments.setArgument(name, value);
    }

    public void putArgument(String name, long value) {
        this.arguments.setArgument(name, value);
    }

    public void putArgument(String name, double value) {
        this.arguments.setArgument(name, value);
    }

    public void putArgument(String name, DynamicObject value) {
        this.arguments.setArgument(name, value);
    }

    public void putArgument(String name, Object value) {
        this.arguments.setArgument(name, value);
    }

    public void replaceArguments(DynamicObject arguments) {
        assert (arguments.isComposite()) : "Invalid DynamicObject type when replace arguments.";
        this.arguments = ArgMap.create();
        for (Map.Entry<String, Object> entry : arguments.asFieldsMap().entrySet()) {
            this.arguments.setArgument(entry.getKey(), entry.getValue());
        }
    }

    private void validateName(String name) {
        if (!this.containsArgument(name)) {
            throw new NoSuchArgumentException(name);
        }
    }
}

