/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.Resource;
import oracle.bpm.casemgmt.model.Value;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.StakeHolder;
import oracle.bpm.casemgmt.model.cm.StakeHolders;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.compile.process.CaseChecker;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class ProjectCaseChecker {
    public static Collection<Msg> check(@NotNull ProjectCase projectCase) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        Project project = projectCase.getProject();
        Case casemgmt = projectCase.getCase();
        result.addAll(CaseChecker.check(casemgmt));
        result.addAll(ProjectCaseChecker.checkStakeholders(project, casemgmt));
        result.addAll(ProjectCaseChecker.checkActivityGuide(project));
        return result;
    }

    private static Collection<Msg> checkStakeholders(Project project, Case casemgmt) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        Organization organization = project.getOrganization();
        StakeHolders stakeHolders = casemgmt.getStakeHolders();
        for (StakeHolder stakeHolder : stakeHolders) {
            for (Resource resource : stakeHolder) {
                Role role;
                String id;
                Value value;
                if (!resource.getIdentityType().isProcessRole() || !(value = resource.getValue()).getType().isStatic() || Str.isEmpty(id = value.getValue()) || (role = organization.findRoleById(id)) != null) continue;
                String fullName = CaseManagementUtils.getDisplayName(bundle, stakeHolder.getName());
                result.add(ProjectCompileMsg.INVALID_PROCESS_ROLE_IN_STAKEHOLDER(fullName, id));
            }
        }
        return result;
    }

    private static Collection<Msg> checkActivityGuide(Project project) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        ActivityGuide activityGuide = project.getActivityGuide();
        Sequence<Milestone> milestones = activityGuide.getChildrenByType(Milestone.class);
        if (!milestones.isEmpty()) {
            result.add(ProjectCompileMsg.ACTIVITY_GUIDE_IN_CASE_PROJECT);
        }
        return result;
    }
}

