/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameterType;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.Output;
import oracle.bpm.casemgmt.model.ca.OutputParameter;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.model.cm.Permissions;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.compile.process.CaseActivityChecker;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.casemgmt.CaseActivityUtils;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class ProjectCaseActivityChecker {
    public static Collection<Msg> check(@NotNull ProjectCaseActivity projectCaseActivity) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        Project project = projectCaseActivity.getProject();
        ProjectCase projectCase = project.getCase();
        if (projectCase != null) {
            Case casemgmt = projectCase.getCase();
            CaseActivity caseActivity = projectCaseActivity.getCaseActivity();
            result.addAll(CaseActivityChecker.check(casemgmt, caseActivity));
            result.addAll(ProjectCaseActivityChecker.checkPermission(casemgmt, caseActivity));
            result.addAll(ProjectCaseActivityChecker.checkInputParameters(project, casemgmt, caseActivity));
            result.addAll(ProjectCaseActivityChecker.checkOutputParameters(project, casemgmt, caseActivity));
            result.addAll(ProjectCaseActivityChecker.checkComponentInfo(project, casemgmt, caseActivity));
        }
        return result;
    }

    private static Collection<Msg> checkPermission(Case casemgmt, CaseActivity caseActivity) {
        Permissions permissions;
        ArrayList<Msg> result = new ArrayList<Msg>();
        String permission = caseActivity.getPermission();
        if (!Str.isEmpty(permission) && !(permissions = casemgmt.getPermissions()).contains((Object)permission)) {
            PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
            String activityFullName = CaseManagementUtils.getDisplayName(bundle, caseActivity.getName());
            result.add(ProjectCompileMsg.CASE_ACTIVITY_PERMISSION_NOT_AVAILABLE(permission, activityFullName));
        }
        return result;
    }

    private static Collection<Msg> checkInputParameters(Project project, Case casemgmt, CaseActivity caseActivity) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        Activity activity = caseActivity.getActivity();
        String activityFullName = ProjectCaseActivityChecker.getActivityFullName(casemgmt, caseActivity);
        Map<String, Data> caseDataMap = ProjectCaseActivityChecker.createCaseDataMap(project);
        InputParameters inputParameters = activity.getInputParameters();
        for (InputParameter inputParameter : inputParameters) {
            String dataName;
            if (!ProjectCaseActivityChecker.isDataNameValidField(inputParameter) || Str.isEmpty(dataName = inputParameter.getDataName()) || caseDataMap.containsKey(dataName)) continue;
            result.add(ProjectCompileMsg.CASE_ACTIVITY_INPUT_DATA_CASE_DATA_INVALID(dataName, activityFullName));
        }
        if (activity.getType().isComponent()) {
            HumanTask task;
            String referenceId;
            ComponentInfo componentInfo;
            Sequence<DataDeclaration> inputDeclarations = null;
            if (activity.getType().isBpmn()) {
                String operation;
                CatchEvent catchEvent;
                componentInfo = activity.toBpmn().getComponentInfo();
                referenceId = componentInfo.getReferenceId();
                Process process = project.findProcess(referenceId);
                if (process != null && (catchEvent = CaseActivityUtils.getOperationByName(process, operation = componentInfo.getOperation())) != null) {
                    inputDeclarations = CaseActivityUtils.getInputDeclarations(catchEvent);
                    if (inputDeclarations.toArray().length != inputParameters.size()) {
                        result.add(ProjectCompileMsg.CASE_ACTIVITY_INPUT_DATA_BPMN_NOT_MATCH(activityFullName, operation, referenceId));
                    }
                    for (InputParameter inputParameter : inputParameters) {
                        String paramName = inputParameter.getParamName();
                        CatalogType catalogType = CaseActivityUtils.getCatalogTypeByName(inputDeclarations, paramName);
                        if (catalogType != null) continue;
                        result.add(ProjectCompileMsg.CASE_ACTIVITY_INPUT_DATA_NAME_BPMN_NOT_MATCH(paramName, activityFullName, operation, referenceId));
                    }
                }
            } else if (activity.getType().isHumantask() && (task = CaseManagementUtils.getHumanTask(project, referenceId = (componentInfo = activity.toHumanTask().getComponentInfo()).getReferenceId())) != null) {
                inputDeclarations = CaseActivityUtils.getInputDeclarations(task);
                if (inputDeclarations.toArray().length != inputParameters.size()) {
                    result.add(ProjectCompileMsg.CASE_ACTIVITY_INPUT_DATA_TASK_NOT_MATCH(activityFullName, referenceId));
                }
                for (InputParameter inputParameter : inputParameters) {
                    String paramName = inputParameter.getParamName();
                    CatalogType catalogType = CaseActivityUtils.getCatalogTypeByName(inputDeclarations, paramName);
                    if (catalogType != null) continue;
                    result.add(ProjectCompileMsg.CASE_ACTIVITY_INPUT_DATA_NAME_TASK_NOT_MATCH(paramName, activityFullName, referenceId));
                }
            }
            if (inputDeclarations != null) {
                for (InputParameter inputParameter : inputParameters) {
                    String dataName;
                    Data data;
                    CatalogType catalogType;
                    String paramName = inputParameter.getParamName();
                    if (Str.isEmpty(paramName) || !ProjectCaseActivityChecker.isDataNameValidField(inputParameter) || (catalogType = CaseActivityUtils.getCatalogTypeByName(inputDeclarations, paramName)) == null || (data = caseDataMap.get(dataName = inputParameter.getDataName())) == null || CaseManagementUtils.isMatchingData(data, catalogType)) continue;
                    result.add(ProjectCompileMsg.CASE_ACTIVITY_INPUT_DATA_TYPE_NOT_MATCH(paramName, activityFullName));
                }
            }
        }
        return result;
    }

    private static Collection<Msg> checkOutputParameters(Project project, Case casemgmt, CaseActivity caseActivity) {
        ArrayList<Msg> result;
        block12: {
            HumanTask task;
            String referenceId;
            ComponentInfo componentInfo;
            OutputParameters outputParameters;
            Map<String, Data> caseDataMap;
            String activityFullName;
            Activity activity;
            block13: {
                String operation;
                CatchEvent catchEvent;
                result = new ArrayList<Msg>();
                activity = caseActivity.getActivity();
                activityFullName = ProjectCaseActivityChecker.getActivityFullName(casemgmt, caseActivity);
                caseDataMap = ProjectCaseActivityChecker.createCaseDataMap(project);
                outputParameters = activity.getOutputParameters();
                for (Output output : outputParameters) {
                    for (OutputParameter outputParameter : output) {
                        String dataName;
                        if (!ProjectCaseActivityChecker.isDataNameValidField(outputParameter) || Str.isEmpty(dataName = outputParameter.getDataName()) || caseDataMap.containsKey(dataName)) continue;
                        result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_CASE_DATA_INVALID(dataName, activityFullName));
                    }
                }
                if (!activity.getType().isComponent()) break block12;
                if (!activity.getType().isBpmn()) break block13;
                componentInfo = activity.toBpmn().getComponentInfo();
                referenceId = componentInfo.getReferenceId();
                Process process = project.findProcess(referenceId);
                if (process == null || (catchEvent = CaseActivityUtils.getOperationByName(process, operation = componentInfo.getOperation())) == null) break block12;
                CaseActivityUtils.OutputDeclarations outputDeclarations = CaseActivityUtils.getOutputDeclarations(catchEvent);
                boolean errorMatch = false;
                if (outputParameters.size() != outputDeclarations.getEntries().size()) {
                    result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_BPMN_NOT_MATCH(activityFullName, operation, referenceId));
                    errorMatch = true;
                }
                for (Output output : outputParameters) {
                    String endPoint = output.getEndPoint();
                    String operationName = output.getOperationName();
                    Sequence<DataDeclaration> declarations = outputDeclarations.getDeclarations(operationName, endPoint);
                    if (!errorMatch && output.size() != declarations.toArray().length) {
                        result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_BPMN_NOT_MATCH(activityFullName, operation, referenceId));
                    }
                    for (OutputParameter outputParameter : output) {
                        String dataName;
                        Data data;
                        String paramName = outputParameter.getParamName();
                        CatalogType catalogType = CaseActivityUtils.getCatalogTypeByName(declarations, paramName);
                        if (catalogType == null) {
                            result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_NAME_BPMN_NOT_MATCH(paramName, activityFullName, operation, referenceId));
                            continue;
                        }
                        if (Str.isEmpty(paramName) || !ProjectCaseActivityChecker.isDataNameValidField(outputParameter) || (data = caseDataMap.get(dataName = outputParameter.getDataName())) == null || CaseManagementUtils.isMatchingData(data, catalogType)) continue;
                        result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_TYPE_NOT_MATCH(paramName, activityFullName));
                    }
                }
                break block12;
            }
            if (activity.getType().isHumantask() && (task = CaseManagementUtils.getHumanTask(project, referenceId = (componentInfo = activity.toHumanTask().getComponentInfo()).getReferenceId())) != null) {
                int size;
                Sequence<DataDeclaration> outputDeclarations = CaseActivityUtils.getOutputDeclarations(task);
                int n = size = outputParameters.isEmpty() ? 0 : ((Output)outputParameters.get(0)).size();
                if (outputDeclarations.toArray().length != size) {
                    result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_TASK_NOT_MATCH(activityFullName, referenceId));
                }
                if (!outputParameters.isEmpty()) {
                    Output output = (Output)outputParameters.get(0);
                    for (OutputParameter outputParameter : output) {
                        String dataName;
                        Data data;
                        String paramName = outputParameter.getParamName();
                        CatalogType catalogType = CaseActivityUtils.getCatalogTypeByName(outputDeclarations, paramName);
                        if (catalogType == null) {
                            result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_NAME_TASK_NOT_MATCH(paramName, activityFullName, referenceId));
                            continue;
                        }
                        if (Str.isEmpty(paramName) || !ProjectCaseActivityChecker.isDataNameValidField(outputParameter) || (data = caseDataMap.get(dataName = outputParameter.getDataName())) == null || CaseManagementUtils.isMatchingData(data, catalogType)) continue;
                        result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_TYPE_NOT_MATCH(paramName, activityFullName));
                    }
                }
            }
        }
        return result;
    }

    private static Map<String, Data> createCaseDataMap(Project project) {
        List caseDataList;
        Case casemgmt;
        HashMap<String, Data> result = new HashMap<String, Data>();
        ProjectCase projectCase = project.getCase();
        if (projectCase != null && (casemgmt = projectCase.getCase()) != null && (caseDataList = casemgmt.getCaseData()).size() > 0) {
            CaseData caseData = (CaseData)caseDataList.get(0);
            for (Data data : caseData) {
                result.put(data.getName(), data);
            }
        }
        return result;
    }

    private static boolean isDataNameValidField(InputParameter inputParameter) {
        InputParameterType type = inputParameter.getType();
        return type.isCaseData() || type.isPayload() && inputParameter.toPayload().isStoreData();
    }

    private static boolean isDataNameValidField(OutputParameter outputParameter) {
        return outputParameter.isStoreData();
    }

    private static Collection<Msg> checkComponentInfo(Project project, Case casemgmt, CaseActivity caseActivity) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        Activity activity = caseActivity.getActivity();
        if (activity.getType().isBpmn()) {
            PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
            String activityFullName = CaseManagementUtils.getDisplayName(bundle, caseActivity.getName());
            Activity.Bpmn bpmn = activity.toBpmn();
            ComponentInfo componentInfo = bpmn.getComponentInfo();
            String referenceId = componentInfo.getReferenceId();
            Process process = project.findProcess(referenceId);
            if (process != null) {
                String operation = componentInfo.getOperation();
                CatchEvent catchEvent = CaseActivityUtils.getOperationByName(process, operation);
                if (catchEvent == null) {
                    result.add(CaseModelMsg.INVALID_BPMN_OPERATION((String)operation, (String)process.getId(), (String)activityFullName));
                } else {
                    boolean synchronous = CaseActivityUtils.isSynchronous(catchEvent);
                    if (componentInfo.isSynchronous() != synchronous) {
                        result.add(CaseModelMsg.INVALID_BPMN_SYNC_FLAG((String)operation, (String)process.getId(), (String)activityFullName));
                    }
                }
            } else {
                result.add(CaseModelMsg.INVALID_BPMN_PROCESS((String)referenceId, (String)activityFullName));
            }
        }
        return result;
    }

    private static String getActivityFullName(Case casemgmt, CaseActivity caseActivity) {
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        return CaseManagementUtils.getDisplayName(bundle, caseActivity.getName());
    }
}

