/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.InvalidProjectObjectExpressionException;
import oracle.bpm.project.compile.exceptions.NotificationException;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.InvalidExpressionException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.IMNotificationDefinition;
import oracle.bpm.project.model.processes.notification.MailNotificationAttachment;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.project.model.processes.notification.MailNotificationHeader;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.notification.NotificationType;
import oracle.bpm.project.model.processes.notification.SMSNotificationDefinition;
import oracle.bpm.project.model.processes.notification.UserNotificationDefinition;
import oracle.bpm.project.model.processes.notification.UserNotificationProperty;
import oracle.bpm.project.model.processes.notification.VoiceNotificationDefinition;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationChecker
extends ProjectObjectChecker {
    private ProcessChecker.CheckContext context;
    private NotificationTask notificationTask;

    public NotificationChecker(@NotNull ProcessChecker.CheckContext context, @NotNull NotificationTask notificationTask) {
        super(context.getListener());
        this.context = context;
        this.notificationTask = notificationTask;
    }

    @Override
    public void check() {
        NotificationType notificationType = this.notificationTask.getNotificationType();
        NotificationDefinition notificationDefinition = this.notificationTask.getNotificationDefinition();
        switch (notificationType) {
            case MAIL: {
                MailNotificationDefinition mailNotificationDefinition = notificationDefinition.as(MailNotificationDefinition.class);
                this.handleMailNotification(mailNotificationDefinition);
                break;
            }
            case USER: {
                UserNotificationDefinition userNotificationDefinition = notificationDefinition.as(UserNotificationDefinition.class);
                this.handleUserNotification(userNotificationDefinition);
                break;
            }
            case SMS: {
                SMSNotificationDefinition smsNotificationDefinition = notificationDefinition.as(SMSNotificationDefinition.class);
                this.handleSMSNotification(smsNotificationDefinition);
                break;
            }
            case IM: {
                IMNotificationDefinition imNotificationDefinition = notificationDefinition.as(IMNotificationDefinition.class);
                this.handleIMNotification(imNotificationDefinition);
                break;
            }
            case VOICE: {
                VoiceNotificationDefinition voiceNotificationDefinition = notificationDefinition.as(VoiceNotificationDefinition.class);
                this.handleVoiceNotification(voiceNotificationDefinition);
            }
        }
    }

    private void checkAttributeExpression(@Nullable Expression expression, @NotNull CatalogType resultType, @NotNull Msg attribute, boolean isMandatory) {
        block8: {
            if (expression != null && !Str.isEmpty(expression.getExpressionValue())) {
                try {
                    ExpressionHelper.validateExpression(expression, new ExpressionContext((DataDeclarationContainer)this.notificationTask, resultType));
                }
                catch (InvalidExpressionException e) {
                    InvalidProjectObjectExpressionException invalidAttribute = InvalidProjectObjectExpressionException.createInvalidAttribute(this.notificationTask, attribute.getString(), e.getMessage());
                    if (this.notificationTask.isDraft()) {
                        this.reportWarning(this.notificationTask, invalidAttribute);
                        break block8;
                    }
                    this.reportError(this.notificationTask, invalidAttribute);
                }
            } else if (isMandatory) {
                InvalidProjectObjectExpressionException emptyAttribute = InvalidProjectObjectExpressionException.createEmptyAttribute(this.notificationTask, attribute.getString());
                if (this.notificationTask.isDraft()) {
                    this.reportWarning(this.notificationTask, emptyAttribute);
                } else {
                    this.reportErrorWarning(this.notificationTask, emptyAttribute);
                }
            }
        }
    }

    private void handleMailNotification(@NotNull MailNotificationDefinition definition) {
        this.checkAttributeExpression(definition.getFromAccount(), MailNotificationDefinition.ResultType.getFromAccount(), ProjectModelMsg.FROM_ACCOUNT, false);
        this.checkAttributeExpression(definition.getTo(), MailNotificationDefinition.ResultType.getTo(), ProjectModelMsg.TO, false);
        this.checkAttributeExpression(definition.getCc(), MailNotificationDefinition.ResultType.getCc(), ProjectModelMsg.CC, false);
        this.checkAttributeExpression(definition.getBcc(), MailNotificationDefinition.ResultType.getBcc(), ProjectModelMsg.BCC, false);
        this.checkAttributeExpression(definition.getReplyTo(), MailNotificationDefinition.ResultType.getReplyTo(), ProjectModelMsg.REPLY_TO, false);
        this.checkAttributeExpression(definition.getSubject(), MailNotificationDefinition.ResultType.getSubject(), ProjectModelMsg.SUBJECT, false);
        this.checkAttributeExpression(definition.getBody(), MailNotificationDefinition.ResultType.getBody(), ProjectModelMsg.BODY, false);
        if (definition.getTo() == null && definition.getCc() == null && definition.getBcc() == null) {
            NotificationException exception = NotificationException.createInvalidNotification(this.notificationTask, ProjectCompileMsg.EMPTY_MAIL_RECIPIENT_NOTIFICATION(this.notificationTask.getDefaultLabel()));
            if (this.notificationTask.isDraft()) {
                this.reportWarning(this.notificationTask, exception);
            } else {
                this.reportErrorWarning(this.notificationTask, exception);
            }
        }
        for (MailNotificationAttachment attachment : definition.getAttachments()) {
            this.checkAttributeExpression(attachment.getName(), MailNotificationAttachment.ResultType.getName(), ProjectModelMsg.ATTACHMENT_PROPERTY(ProjectModelMsg.NAME.getString()), true);
            this.checkAttributeExpression(attachment.getMimeType(), MailNotificationAttachment.ResultType.getMimeType(), ProjectModelMsg.ATTACHMENT_PROPERTY(ProjectModelMsg.MIME_TYPE.getString()), true);
            this.checkAttributeExpression(attachment.getValue(), MailNotificationAttachment.ResultType.getValue(), ProjectModelMsg.ATTACHMENT_PROPERTY(ProjectModelMsg.VALUE.getString()), true);
            this.checkAttributeExpression(attachment.getEncoding(), MailNotificationAttachment.ResultType.getEncoding(), ProjectModelMsg.ATTACHMENT_PROPERTY(ProjectModelMsg.TRANSFER_ENCODING.getString()), false);
        }
        for (MailNotificationHeader header : definition.getHeaders()) {
            this.checkAttributeExpression(header.getName(), MailNotificationHeader.ResultType.getName(), ProjectModelMsg.ATTACHMENT_PROPERTY(ProjectModelMsg.NAME.getString()), true);
            this.checkAttributeExpression(header.getValue(), MailNotificationHeader.ResultType.getValue(), ProjectModelMsg.ATTACHMENT_PROPERTY(ProjectModelMsg.VALUE.getString()), true);
        }
    }

    private void handleUserNotification(@NotNull UserNotificationDefinition definition) {
        this.checkAttributeExpression(definition.getTo(), UserNotificationDefinition.ResultType.getTo(), ProjectModelMsg.TO, true);
        this.checkAttributeExpression(definition.getSubject(), UserNotificationDefinition.ResultType.getSubject(), ProjectModelMsg.SUBJECT, false);
        this.checkAttributeExpression(definition.getMessage(), UserNotificationDefinition.ResultType.getMessage(), ProjectModelMsg.MESSAGE, false);
        for (UserNotificationProperty property : definition.getProperties()) {
            this.checkAttributeExpression(property.getHeader(), UserNotificationProperty.ResultType.getHeader(), ProjectModelMsg.USER_PROPERTY_PROPERTY(ProjectModelMsg.HEADER.getString()), true);
            this.checkAttributeExpression(property.getValue(), UserNotificationProperty.ResultType.getValue(), ProjectModelMsg.USER_PROPERTY_PROPERTY(ProjectModelMsg.VALUE.getString()), true);
        }
    }

    private void handleSMSNotification(@NotNull SMSNotificationDefinition definition) {
        this.checkAttributeExpression(definition.getFrom(), SMSNotificationDefinition.ResultType.getFrom(), ProjectModelMsg.FROM_NUMBER, false);
        this.checkAttributeExpression(definition.getTo(), SMSNotificationDefinition.ResultType.getTo(), ProjectModelMsg.TO_NUMBER, true);
        this.checkAttributeExpression(definition.getSubject(), SMSNotificationDefinition.ResultType.getSubject(), ProjectModelMsg.SUBJECT, false);
        this.checkAttributeExpression(definition.getBody(), SMSNotificationDefinition.ResultType.getBody(), ProjectModelMsg.BODY, false);
    }

    private void handleVoiceNotification(@NotNull VoiceNotificationDefinition definition) {
        this.checkAttributeExpression(definition.getTo(), VoiceNotificationDefinition.ResultType.getTo(), ProjectModelMsg.TO_NUMBER, true);
        this.checkAttributeExpression(definition.getMimeType(), VoiceNotificationDefinition.ResultType.getMimeType(), ProjectModelMsg.MIME_TYPE, false);
        this.checkAttributeExpression(definition.getBody(), VoiceNotificationDefinition.ResultType.getBody(), ProjectModelMsg.BODY, false);
    }

    private void handleIMNotification(@NotNull IMNotificationDefinition definition) {
        this.checkAttributeExpression(definition.getTo(), IMNotificationDefinition.ResultType.getTo(), ProjectModelMsg.TO, true);
        this.checkAttributeExpression(definition.getBody(), IMNotificationDefinition.ResultType.getBody(), ProjectModelMsg.BODY, false);
    }

    private void reportErrorWarning(@NotNull ProjectObject object, @NotNull ProjectException exception) {
        if (this.getOptions().isDeploying()) {
            this.reportError(object, exception);
        } else {
            this.reportWarning(object, exception);
        }
    }

    private CheckOptions getOptions() {
        return this.context.getOptions();
    }
}

