/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.CorrelationException;
import oracle.bpm.project.compile.exceptions.CorrelationItemException;
import oracle.bpm.project.compile.exceptions.CorrelationPropertyAliasException;
import oracle.bpm.project.compile.process.CorrelationHelper;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.InvalidExpressionException;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.correlations.InputCorrelationsEnabled;
import oracle.bpm.project.model.processes.correlations.OutputCorrelationsEnabled;
import org.jetbrains.annotations.NotNull;

public class CorrelationChecker
extends ProjectObjectChecker {
    private ProcessChecker.CheckContext context;
    private CorrelationsEnabled correlationsEnabled;

    public CorrelationChecker(@NotNull CorrelationsEnabled correlationsEnabled, @NotNull ProcessChecker.CheckContext context) {
        super(context.getListener());
        this.correlationsEnabled = correlationsEnabled;
        this.context = context;
    }

    @Override
    public void check() {
        if (this.correlationsEnabled.isInputCorrelationsEnabled()) {
            CorrelationItemsContainer inputCorrelationsContainer = ((InputCorrelationsEnabled)this.correlationsEnabled).getInputCorrelationsContainer();
            this.checkCorrelationItemsContainer(inputCorrelationsContainer);
        }
        if (this.correlationsEnabled.isOutputCorrelationsEnabled()) {
            CorrelationItemsContainer outputCorrelationItemsContainer = ((OutputCorrelationsEnabled)this.correlationsEnabled).getOutputCorrelationsContainer();
            this.checkCorrelationItemsContainer(outputCorrelationItemsContainer);
        }
    }

    private ProcessChecker.CheckContext getContext() {
        return this.context;
    }

    private CheckOptions getOptions() {
        return this.getContext().getOptions();
    }

    private void checkCorrelationItemsContainer(CorrelationItemsContainer correlationItemsContainer) {
        boolean hasInvalidCorrelationKeys = false;
        CorrelationsEnabled correlationsEnabled = correlationItemsContainer.getParentObject();
        for (CorrelationKey correlationKey : correlationItemsContainer.getCorrelationKeys()) {
            if (correlationItemsContainer.getScopedCorrelationKeys().contains(correlationKey)) continue;
            CorrelationItemException exception = CorrelationItemException.createInvalidCorrelationKey(correlationsEnabled, correlationKey);
            this.reportError(correlationsEnabled, exception);
            hasInvalidCorrelationKeys = true;
        }
        if (!hasInvalidCorrelationKeys) {
            Sequence<CorrelationKey> correlationKeys = correlationItemsContainer.getCorrelationKeys();
            Sequence<CorrelationProperty> properties = CorrelationHelper.getPropertiesUnion(correlationKeys);
            for (CorrelationProperty property : properties) {
                if (property.isUnknownProperty()) {
                    CorrelationException exception = CorrelationException.createInvalidPropertyInSelectedKey(correlationsEnabled, property);
                    this.reportError(correlationsEnabled, exception);
                    continue;
                }
                Sequence<String> partNames = correlationItemsContainer.getPartNames();
                for (String partName : partNames) {
                    CorrelationPropertyAlias propertyAlias = correlationItemsContainer.getProject().findPropertyAlias(property, partName, correlationItemsContainer.isInputsContainer(), correlationsEnabled);
                    if (propertyAlias == null || propertyAlias.getExpression() == null || Str.isEmpty(propertyAlias.getExpression().getExpressionValue())) {
                        CorrelationPropertyAliasException exception = CorrelationPropertyAliasException.createNullOrEmptyExpression(correlationsEnabled, property);
                        this.reportError(correlationsEnabled, exception);
                        continue;
                    }
                    Expression expression = propertyAlias.getExpression();
                    DataDeclarationContainer context = correlationItemsContainer.getExpressionContext(partName);
                    try {
                        ExpressionHelper.validateExpression(expression, new ExpressionContext(context, propertyAlias.getProperty().getType()));
                    }
                    catch (InvalidExpressionException e) {
                        CorrelationPropertyAliasException exception = CorrelationPropertyAliasException.createInvalidExpression(correlationsEnabled, propertyAlias.getProperty(), e.getMessage());
                        this.reportError(this.correlationsEnabled, exception);
                    }
                }
            }
        }
    }
}

