/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.FaultObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.ProcessCallConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ServiceCallConversationDefinition;
import oracle.bpm.project.model.processes.conversation.UseInterfaceConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ConversationalType;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversationalHelper {
    private static final String DEFAULT_OPERATION_NAME = "operation";
    private static final String DEFAULT_CALLBACK_OPERATION_NAME = "callback";
    private static final String DEFAULT_CONVERSATION_NAME = "conversation";
    private static final long EPOCH = 1301592255780L;

    public static String getConversationName(@NotNull Conversation conversation) {
        String name = null;
        if (!conversation.isDefaultConversation()) {
            name = conversation.getName();
        }
        String implementation = ConversationalHelper.getImplementationDescription(conversation);
        Msg msg = Msg.QUOTE(implementation);
        implementation = ProjectCompileMsg.BRACKETIZE(msg).getString();
        String result = !Str.isEmpty(name) && !Str.isEmpty(implementation) ? ProjectCompileMsg.CONVERSATION_FULL_NAME(name, implementation).getString() : implementation;
        return result;
    }

    public static Sequence<Process> getProjectProcesses(@NotNull Project project) {
        return CollectionUtils.asSequence(project.getProcesses()).select(new Predicate<Process>(){

            @Override
            public boolean check(@Nullable Process value) {
                return value != null && !value.isCallableSubprocess();
            }
        });
    }

    public static Sequence<ServiceObject> getConversationServices(@NotNull Project project) {
        return ConversationalHelper.getProjectInterfaces(project, true, true, false, ServiceObject.class);
    }

    public static Sequence<ReferenceObject> getConversationReferences(@NotNull Project project) {
        return ConversationalHelper.getProjectInterfaces(project, true, true, false, ReferenceObject.class);
    }

    public static Sequence<ServiceObject> getConversationalServices(@NotNull Conversational conversational) {
        ConversationalType conversationalType = conversational.getConversationalType();
        boolean syncServices = conversationalType.isSender();
        boolean invokeServices = conversationalType.isSender();
        boolean callbackServices = !conversationalType.isSender();
        Project project = conversational.getProject();
        return ConversationalHelper.getProjectInterfaces(project, syncServices, invokeServices, callbackServices, ServiceObject.class);
    }

    public static Sequence<ReferenceObject> getConversationalReferences(@NotNull Conversational conversational) {
        ConversationalType conversationalType = conversational.getConversationalType();
        boolean invokeReferences = conversationalType.isReceiver();
        boolean callbackReferences = !conversationalType.isReceiver();
        Project project = conversational.getProject();
        return ConversationalHelper.getProjectInterfaces(project, true, invokeReferences, callbackReferences, ReferenceObject.class);
    }

    public static Sequence<Conversation> getConversationalConversations(@NotNull Conversational conversational) {
        Sequence<Conversation> result = ConversationalHelper.getScopedConversationsInConversational(conversational);
        final ConversationalType conversationalType = conversational.getConversationalType();
        result = result.select(new Predicate<Conversation>(){

            @Override
            public boolean check(@Nullable Conversation conversation) {
                return conversation != null && (conversation.getConversationType().isOutbound() && conversationalType.isOutboundAvailable() || conversation.getConversationType().isInbound() && conversationalType.isInboundAvailable());
            }
        });
        return result;
    }

    public static Sequence<Conversation> getConversationalConversations(@NotNull Conversational conversational, final @NotNull ConversationType conversationType) {
        return ConversationalHelper.getScopedConversationsInConversational(conversational).select(new Predicate<Conversation>(){

            @Override
            public boolean check(@Nullable Conversation conversation) {
                return conversation != null && conversation.getConversationType() == conversationType && !conversation.isDefaultConversation();
            }
        });
    }

    public static Sequence<ConversationType> getAvailableConversationTypes(@NotNull Conversational conversational) {
        ArrayList<ConversationType> result = new ArrayList<ConversationType>();
        ConversationalType conversationalType = conversational.getConversationalType();
        for (ConversationType conversationType : ConversationType.values()) {
            if ((!conversationType.isInbound() || !conversationalType.isInboundAvailable()) && (!conversationType.isOutbound() || !conversationalType.isOutboundAvailable())) continue;
            result.add(conversationType);
        }
        return CollectionUtils.asSequence(result);
    }

    public static ConversationContainer getRootContainer(@NotNull ConversationContainer container) {
        ConversationContainer rootContainer = container;
        while (rootContainer.getParentConversationsScope() != null) {
            rootContainer = rootContainer.getParentConversationsScope();
        }
        return rootContainer;
    }

    public static String getNextConversationId(@NotNull ConversationContainer container) {
        String result;
        ConversationContainer rootContainer = ConversationalHelper.getRootContainer(container);
        while (ConversationalHelper.conversationIdExists(result = ConversationalHelper.createRandomConversationId(), rootContainer)) {
        }
        return result;
    }

    public static String createRandomConversationId() {
        String prepend = "CONVERSATION";
        long timestamp = System.currentTimeMillis() - 1301592255780L;
        return "CONVERSATION" + timestamp;
    }

    public static ConversationContainer getParentConversationsScope(@NotNull ConversationContainer container) {
        return ConversationalHelper.getParentConversationsScope((ProjectObject)container);
    }

    public static boolean isOperationNameValid(@NotNull String operationName) {
        return Identifier.isValidMethodName(operationName);
    }

    public static String getDefaultConversationName(@NotNull ConversationContainer container) {
        String root = DEFAULT_CONVERSATION_NAME;
        String result = DEFAULT_CONVERSATION_NAME;
        int count = 0;
        while (ConversationalHelper.conversationNameExists(result, container, null)) {
            result = DEFAULT_CONVERSATION_NAME + ++count;
        }
        return result;
    }

    public static boolean conversationNameExists(@NotNull String name, @NotNull ConversationContainer container, @Nullable Conversation excludedConversation) {
        ConversationContainer rootContainer = ConversationalHelper.getRootContainer(container);
        Sequence<Conversation> descendantConversations = ConversationalHelper.getDescendantConversations(rootContainer);
        if (Any.equals(name, rootContainer.getName())) {
            return true;
        }
        for (Conversation conversation : descendantConversations) {
            if (excludedConversation != null && Any.equals(excludedConversation.getId(), conversation.getId()) || !Any.equals(name, conversation.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean defaultDefineInterfaceConversationExists(@NotNull ConversationContainer container, @Nullable Conversation excludedConversation) {
        return ConversationalHelper.findDefaultDefineInterfaceConversation(container, excludedConversation) != null;
    }

    public static Conversation findDefaultDefineInterfaceConversation(@NotNull ConversationContainer container) {
        return ConversationalHelper.findDefaultDefineInterfaceConversation(container, null);
    }

    public static boolean defaultUseInterfaceConversationExists(@NotNull ConversationContainer container, @Nullable ReferenceObject referenceObject, @Nullable Conversation excludedConversation) {
        return ConversationalHelper.findDefaultUseInterfaceConversation(container, referenceObject, excludedConversation) != null;
    }

    public static Conversation findDefaultUseInterfaceConversation(@NotNull ConversationContainer container, @Nullable ReferenceObject referenceObject) {
        return ConversationalHelper.findDefaultUseInterfaceConversation(container, referenceObject, null);
    }

    public static Conversation findDefaultUseInterfaceConversation(@NotNull ConversationContainer container, @Nullable ReferenceObject referenceObject, @Nullable Conversation excludedConversation) {
        Conversation result = null;
        ConversationContainer rootContainer = ConversationalHelper.getRootContainer(container);
        Sequence<Conversation> descendantConversations = ConversationalHelper.getDescendantConversations(rootContainer);
        for (Conversation conversation : descendantConversations) {
            UseInterfaceConversationDefinition definition;
            if (excludedConversation != null && Any.equals(excludedConversation.getId(), conversation.getId()) || conversation.getConversationType() != ConversationType.USE_INTERFACE || !conversation.isDefaultConversation() || !Any.equals(referenceObject, (definition = conversation.getConversationDefinition().as(UseInterfaceConversationDefinition.class)).getReference())) continue;
            result = conversation;
        }
        return result;
    }

    public static boolean defaultServiceCallConversationExists(@NotNull ConversationContainer container, @Nullable ServiceObject serviceObject, @Nullable Conversation excludedConversation) {
        return ConversationalHelper.findDefaultServiceCallConversation(container, serviceObject, excludedConversation) != null;
    }

    public static Conversation findDefaultServiceCallConversation(@NotNull ConversationContainer container, @Nullable ServiceObject serviceObject) {
        return ConversationalHelper.findDefaultServiceCallConversation(container, serviceObject, null);
    }

    public static Conversation findDefaultServiceCallConversation(@NotNull ConversationContainer container, @Nullable ServiceObject serviceObject, @Nullable Conversation excludedConversation) {
        Conversation result = null;
        ConversationContainer rootContainer = ConversationalHelper.getRootContainer(container);
        Sequence<Conversation> descendantConversations = ConversationalHelper.getDescendantConversations(rootContainer);
        for (Conversation conversation : descendantConversations) {
            ServiceCallConversationDefinition definition;
            if (excludedConversation != null && Any.equals(excludedConversation.getId(), conversation.getId()) || conversation.getConversationType() != ConversationType.SERVICE_CALL || !conversation.isDefaultConversation() || !Any.equals(serviceObject, (definition = conversation.getConversationDefinition().as(ServiceCallConversationDefinition.class)).getService())) continue;
            result = conversation;
        }
        return result;
    }

    public static boolean defaultProcessCallConversationExists(@NotNull ConversationContainer container, @Nullable Process process, @Nullable Conversation excludedConversation) {
        return ConversationalHelper.findDefaultProcessCallConversationExists(container, process, excludedConversation) != null;
    }

    public static Conversation findDefaultProcessCallConversation(@NotNull ConversationContainer container, @Nullable Process process) {
        return ConversationalHelper.findDefaultProcessCallConversationExists(container, process, null);
    }

    public static Conversation findDefaultProcessCallConversationExists(@NotNull ConversationContainer container, @Nullable Process process, @Nullable Conversation excludedConversation) {
        Conversation result = null;
        ConversationContainer rootContainer = ConversationalHelper.getRootContainer(container);
        Sequence<Conversation> descendantConversations = ConversationalHelper.getDescendantConversations(rootContainer);
        for (Conversation conversation : descendantConversations) {
            ProcessCallConversationDefinition definition;
            if (excludedConversation != null && Any.equals(excludedConversation.getId(), conversation.getId()) || conversation.getConversationType() != ConversationType.PROCESS_CALL || !conversation.isDefaultConversation() || !Any.equals(process, (definition = conversation.getConversationDefinition().as(ProcessCallConversationDefinition.class)).getProcess())) continue;
            result = conversation;
        }
        return result;
    }

    public static String getDefaultDefinedOperationName(@NotNull DefineInterfaceConversationalDefinition definition) {
        Conversational conversational = definition.getParentObject();
        String label = conversational.getDefaultLabel();
        String root = Identifier.method(label);
        if (Str.isEmpty(root) || !ConversationalHelper.isOperationNameValid(root)) {
            root = conversational.getConversationalType().isReceiver() ? DEFAULT_OPERATION_NAME : DEFAULT_CALLBACK_OPERATION_NAME;
        }
        String result = root;
        int count = 0;
        while (ConversationalHelper.definedOperationNameExists(result, definition)) {
            result = root + ++count;
        }
        return result;
    }

    public static boolean definedOperationNameExists(@NotNull String operationName, @NotNull DefineInterfaceConversationalDefinition excludedDefinition) {
        Conversational excludedConversational = excludedDefinition.getParentObject();
        Conversation conversation = excludedConversational.getConversation();
        if (conversation != null) {
            Sequence<Conversational> conversationals = conversation.getConversationals();
            for (Conversational conversational : conversationals) {
                DefineInterfaceConversationalDefinition definition;
                if (conversational.getId().equals(excludedConversational.getId()) || !Any.equals((definition = conversational.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class)).getDefinedOperationName(), operationName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Sequence<ErrorObject> getReplyToErrors(@NotNull Conversational replyTo) {
        Conversation conversation;
        Sequence<ErrorObject> result = CollectionUtils.emptySequence();
        if (replyTo.getConversationalType().isReceiver() && (conversation = replyTo.getConversation()) != null) {
            ConversationalDefinition conversationalDefinition;
            UseInterfaceConversationalDefinition useInterfaceConversationalDefinition;
            CatalogMember operation;
            ConversationType conversationType = conversation.getConversationType();
            if (conversationType == ConversationType.DEFINE_INTERFACE) {
                CatalogModule catalogRoot = replyTo.getProject().getCatalogRoot();
                result = (Sequence<ErrorObject>)Cast.force(catalogRoot.getDescendants(FaultObject.class));
            } else if (conversationType == ConversationType.USE_INTERFACE && (operation = (useInterfaceConversationalDefinition = (conversationalDefinition = replyTo.getConversationalDefinition()).as(UseInterfaceConversationalDefinition.class)).getOperation()) != null) {
                result = operation.getExceptions();
            }
        }
        return result;
    }

    public static Sequence<Conversation> getProcessInboundConversations(@NotNull Process process) {
        Sequence<Conversation> conversations = process.getDescendants(Conversation.class);
        return conversations.select(new Predicate<Conversation>(){

            @Override
            public boolean check(@Nullable Conversation conversation) {
                return conversation != null && conversation.getConversationType().isInbound();
            }
        });
    }

    public static InterfaceObject getCallbackInterface(@NotNull InterfaceObject service) {
        for (InterfaceObject child : service.getChildrenByType(InterfaceObject.class)) {
            if (!child.isCallback()) continue;
            return child;
        }
        return null;
    }

    public static Sequence<Conversational> getProcessCallConversationals(@NotNull ConversationalType type, @NotNull Process process) {
        Sequence<Conversational> result = CollectionUtils.emptySequence();
        Sequence<Conversational> conversationals = ConversationalHelper.getAllProcessInboundConversationals(process);
        if (type == ConversationalType.ONE_WAY_SENDER || type == ConversationalType.ONE_WAY_END) {
            result = conversationals.select(new Predicate<Conversational>(){

                @Override
                public boolean check(@Nullable Conversational conversational) {
                    return conversational != null && conversational.getConversationalType().isReceiver();
                }
            });
        } else if (type == ConversationalType.ONE_WAY_RECEIVER || type == ConversationalType.ONE_WAY_START) {
            result = conversationals.select(new Predicate<Conversational>(){

                @Override
                public boolean check(@Nullable Conversational node) {
                    Conversation nodeConversation;
                    ConversationalType nodeType;
                    boolean result = false;
                    if (node != null && (nodeType = node.getConversationalType()).isSender() && (nodeConversation = node.getConversation()) != null) {
                        UseInterfaceConversationDefinition nodeConversationDefinition;
                        ReferenceObject reference;
                        ConversationType nodeConversationType = nodeConversation.getConversationType();
                        if (nodeConversationType == ConversationType.DEFINE_INTERFACE) {
                            DefineInterfaceConversationalDefinition nodeDefinition = node.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                            result = nodeDefinition.getReplyTo() == null;
                        } else if (nodeConversationType == ConversationType.USE_INTERFACE && (reference = (nodeConversationDefinition = nodeConversation.getConversationDefinition().as(UseInterfaceConversationDefinition.class)).getReference()) != null) {
                            result = !reference.isSync();
                        }
                    }
                    return result;
                }
            });
        } else if (type == ConversationalType.TWO_WAY_SENDER) {
            result = conversationals.select(new Predicate<Conversational>(){

                @Override
                public boolean check(@Nullable Conversational node) {
                    return node != null && node.getConversationalType().isReceiver();
                }
            });
        }
        return result;
    }

    public static boolean isValidTwoWayTargetNode(@NotNull Conversational targetConversational) {
        Conversation targetNodeConversation;
        boolean result = false;
        ConversationalType targetType = targetConversational.getConversationalType();
        if (targetType.isReceiver() && (targetNodeConversation = targetConversational.getConversation()) != null) {
            UseInterfaceConversationalDefinition targetDefinition;
            ReferenceObject reference;
            ConversationType targetConversationType = targetNodeConversation.getConversationType();
            if (targetConversationType == ConversationType.DEFINE_INTERFACE) {
                Sequence<Conversational> repliers = ConversationalHelper.getAllRepliers(targetConversational, false);
                result = !repliers.isEmpty();
            } else if (targetConversationType == ConversationType.USE_INTERFACE && (reference = (targetDefinition = targetConversational.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class)).getReference()) != null) {
                result = reference.isSync();
            }
        }
        return result;
    }

    public static Sequence<Conversational> getPossibleReplyTos(@NotNull Conversational conversational) {
        Conversation conversation = conversational.getConversation();
        if (conversation != null) {
            return ConversationalHelper.getPossibleReplyTos(conversation);
        }
        return CollectionUtils.emptySequence();
    }

    public static Sequence<Conversational> getPossibleReplyTos(@NotNull Conversation conversation) {
        Sequence<Conversational> result = CollectionUtils.emptySequence();
        if (conversation.getConversationType() == ConversationType.DEFINE_INTERFACE) {
            Sequence<Conversational> conversationals = conversation.getConversationals();
            result = conversationals.select(new Predicate<Conversational>(){

                @Override
                public boolean check(@Nullable Conversational possibleReplyTo) {
                    return possibleReplyTo != null && possibleReplyTo.getConversationalType().isReceiver();
                }
            });
        }
        return result;
    }

    public static Sequence<Conversation> getScopedConversationsInContainer(@NotNull ConversationContainer container) {
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        ConversationalHelper.appendScopedConversations(container, result);
        return CollectionUtils.asSequence(result);
    }

    public static Sequence<Conversational> getAllRepliers(final @NotNull Conversational conversational, final boolean excludeErrors) {
        ConversationType conversationType;
        Sequence<Conversational> result = CollectionUtils.emptySequence();
        Conversation conversation = conversational.getConversation();
        if (conversation != null && (conversationType = conversation.getConversationType()) == ConversationType.DEFINE_INTERFACE) {
            Sequence<Conversational> conversationals = conversation.getConversationals();
            result = conversationals.select(new Predicate<Conversational>(){

                @Override
                public boolean check(@Nullable Conversational replier) {
                    if (replier != null) {
                        DefineInterfaceConversationalDefinition replierDefinition = replier.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                        return replierDefinition.getReplyTo() == conversational && (!excludeErrors || replierDefinition.getError() == null);
                    }
                    return false;
                }
            });
        }
        return result;
    }

    private static <T extends InterfaceObject> Sequence<T> getProjectInterfaces(@NotNull Project project, final boolean syncInterfaces, final boolean asyncInvokeInterfaces, final boolean asyncCallbackInterfaces, Class<T> clazz) {
        CatalogModule catalogRoot = project.getCatalogRoot();
        return catalogRoot.getDescendants(clazz).select(new Predicate<T>(){

            @Override
            public boolean check(@Nullable T interfaceObject) {
                return interfaceObject != null && (interfaceObject.isSync() && !interfaceObject.isCallback() && syncInterfaces || !interfaceObject.isSync() && !interfaceObject.isCallback() && asyncInvokeInterfaces || interfaceObject.isCallback() && asyncCallbackInterfaces);
            }
        });
    }

    private static Conversation findDefaultDefineInterfaceConversation(@NotNull ConversationContainer container, @Nullable Conversation excludedConversation) {
        Conversation result = null;
        ConversationContainer rootContainer = ConversationalHelper.getRootContainer(container);
        Sequence<Conversation> descendantConversations = ConversationalHelper.getDescendantConversations(rootContainer);
        for (Conversation conversation : descendantConversations) {
            if (excludedConversation != null && Any.equals(excludedConversation.getId(), conversation.getId()) || conversation.getConversationType() != ConversationType.DEFINE_INTERFACE || !conversation.isDefaultConversation()) continue;
            result = conversation;
        }
        return result;
    }

    @NotNull
    private static String getImplementationDescription(@NotNull Conversation conversation) {
        ProcessCallConversationDefinition definition;
        Process process;
        String result = null;
        ConversationType type = conversation.getConversationType();
        if (type == ConversationType.DEFINE_INTERFACE) {
            result = type.getMsg().getString();
        } else if (type == ConversationType.USE_INTERFACE) {
            UseInterfaceConversationDefinition definition2 = conversation.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
            ReferenceObject reference = definition2.getReference();
            if (reference != null) {
                result = reference.getName();
            }
        } else if (type == ConversationType.SERVICE_CALL) {
            ServiceCallConversationDefinition definition3 = conversation.getConversationDefinition().as(ServiceCallConversationDefinition.class);
            ServiceObject service = definition3.getService();
            if (service != null) {
                result = service.getName();
            }
        } else if (type == ConversationType.PROCESS_CALL && (process = (definition = conversation.getConversationDefinition().as(ProcessCallConversationDefinition.class)).getProcess()) != null) {
            result = process.getDefaultLabel();
        }
        if (result == null) {
            result = ProjectCompileMsg.NOT_IMPLEMENTED.getString();
        }
        return result;
    }

    private static Sequence<Conversational> getAllProcessInboundConversationals(@NotNull Process process) {
        ArrayList<Conversational> result = new ArrayList<Conversational>();
        Sequence<Conversation> processInboundConversations = ConversationalHelper.getProcessInboundConversations(process);
        for (Conversation processInboundConversation : processInboundConversations) {
            Sequence<Conversational> conversationals = processInboundConversation.getConversationals();
            for (Conversational conversational : conversationals) {
                result.add(conversational);
            }
        }
        return CollectionUtils.asSequence(result);
    }

    private static Sequence<Conversation> getScopedConversationsInConversational(@NotNull Conversational conversational) {
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        ConversationalHelper.appendScopedConversations(conversational, result);
        return CollectionUtils.asSequence(result);
    }

    private static boolean conversationIdExists(@NotNull String id, @NotNull ConversationContainer rootContainer) {
        Sequence<Conversation> allConversations = ConversationalHelper.getDescendantConversations(rootContainer);
        for (Conversation conversation : allConversations) {
            if (!id.equals(conversation.getId())) continue;
            return true;
        }
        return false;
    }

    private static ConversationContainer getParentConversationsScope(@NotNull ProjectObject container) {
        ConversationContainer result = null;
        ProjectObject parentObject = container.getParentObject();
        if (parentObject != null) {
            result = parentObject instanceof ConversationContainer ? (ConversationContainer)parentObject : ConversationalHelper.getParentConversationsScope(parentObject);
        }
        return result;
    }

    private static void appendScopedConversations(@NotNull ProjectObject scope, @NotNull List<Conversation> conversations) {
        ProjectObject parent;
        if (ConversationContainer.class.isAssignableFrom(scope.getRawClass())) {
            ConversationContainer container = (ConversationContainer)scope;
            for (Conversation conversation : container.getLocalConversations()) {
                if (ConversationalHelper.conversationExists(conversations, conversation.getId())) continue;
                conversations.add(conversation);
            }
        }
        if ((parent = scope.getParentObject()) != null) {
            ConversationalHelper.appendScopedConversations(parent, conversations);
        }
    }

    private static boolean conversationExists(@NotNull List<Conversation> conversations, @NotNull String conversationId) {
        for (Conversation conversation : conversations) {
            if (!conversationId.equals(conversation.getId())) continue;
            return true;
        }
        return false;
    }

    private static Sequence<Conversation> getDescendantConversations(@NotNull ConversationContainer container) {
        return container.getDescendants(Conversation.class);
    }
}

