/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.ArgumentException;
import oracle.bpm.project.compile.exceptions.ConversationalException;
import oracle.bpm.project.compile.exceptions.FlowNodeHasNoImplementationException;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.processes.Draftable;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ConversationalType;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ProcessCallConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ServiceCallConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import org.jetbrains.annotations.NotNull;

public class ConversationalChecker
extends ProjectObjectChecker {
    private ProcessChecker.CheckContext context;
    private Conversational node;

    public ConversationalChecker(@NotNull ProcessChecker.CheckContext context, @NotNull Conversational node) {
        super(context.getListener());
        this.node = node;
        this.context = context;
    }

    public ProcessChecker.CheckContext getContext() {
        return this.context;
    }

    public CheckOptions getOptions() {
        return this.getContext().getOptions();
    }

    @Override
    public void check() {
        Conversation conversation = this.node.getConversation();
        if (conversation == null) {
            FlowNodeHasNoImplementationException exception = new FlowNodeHasNoImplementationException(this.node);
            if (!(!this.getOptions().isDeploying() || this.node.isDraftable() && this.node.asAnyNode(Draftable.class).isDraft())) {
                this.reportError(this.node, exception);
            } else {
                this.reportWarning(this.node, exception);
            }
        } else {
            ConversationalDefinition conversationalDefinition = this.node.getConversationalDefinition();
            ConversationType conversationType = conversation.getConversationType();
            if (!ConversationalHelper.getAvailableConversationTypes(this.node).contains((Object)conversationType)) {
                this.reportError(this.node, ConversationalException.createInvalidConversationType(this.node));
            } else if (conversationType == ConversationType.DEFINE_INTERFACE) {
                DefineInterfaceConversationalDefinition definition = conversationalDefinition.as(DefineInterfaceConversationalDefinition.class);
                this.checkDefineInterface(definition);
            } else if (conversationType == ConversationType.USE_INTERFACE) {
                UseInterfaceConversationalDefinition definition = conversationalDefinition.as(UseInterfaceConversationalDefinition.class);
                this.checkUseInterface(definition);
            } else if (conversationType == ConversationType.SERVICE_CALL) {
                ServiceCallConversationalDefinition definition = conversationalDefinition.as(ServiceCallConversationalDefinition.class);
                this.checkServiceCall(definition);
            } else if (conversationType == ConversationType.PROCESS_CALL) {
                ProcessCallConversationalDefinition definition = conversationalDefinition.as(ProcessCallConversationalDefinition.class);
                this.checkProcessCall(definition);
            }
        }
    }

    private void checkDefineInterface(@NotNull DefineInterfaceConversationalDefinition definition) {
        if (definition.getReplyTo() != null) {
            this.checkReplyToAndError(definition);
            this.checkSyncValidPath(definition);
            this.checkReplierInterface(definition);
        } else {
            this.checkDefinedOperationName(definition);
            this.checkArgumentsType(definition);
            this.checkInvokeForCallback(definition.getParentObject().getConversation());
        }
    }

    private void checkInvokeForCallback(@NotNull Conversation conversation) {
        if (conversation.getConversationType().isInbound()) {
            Sequence<Conversational> conversationals = conversation.getConversationals();
            for (Conversational conversational : conversationals) {
                if (!conversational.getConversationalType().isReceiver()) continue;
                return;
            }
            this.reportError(this.node, ConversationalException.createMissingInvokeForCallback(this.node));
        }
    }

    private void checkUseInterface(@NotNull UseInterfaceConversationalDefinition definition) {
        this.checkUseInterfaceReferenceAndOperation(definition);
        this.checkInvokeForCallback(definition.getParentObject().getConversation());
    }

    private void checkServiceCall(@NotNull ServiceCallConversationalDefinition definition) {
        this.checkServiceCallServiceAndOperation(definition);
    }

    private void checkProcessCall(@NotNull ProcessCallConversationalDefinition definition) {
        Conversational conversational = definition.getParentObject();
        Process process = definition.getProcess();
        if (process == null) {
            this.reportError(conversational, ConversationalException.createNullProcess(conversational));
        } else {
            Project project = definition.getProject();
            Sequence<Process> processes = ConversationalHelper.getProjectProcesses(project);
            if (!processes.contains(process)) {
                this.reportError(conversational, ConversationalException.createInvalidProcess(conversational));
            } else {
                Conversational targetConversational = definition.getTargetConversational();
                if (targetConversational == null) {
                    this.reportError(conversational, ConversationalException.createNullTargetConversational(conversational));
                } else {
                    ConversationalType conversationalType = conversational.getConversationalType();
                    Sequence<Conversational> targetConversationals = ConversationalHelper.getProcessCallConversationals(conversationalType, process);
                    if (!targetConversationals.contains(targetConversational)) {
                        this.reportError(conversational, ConversationalException.createInvalidTargetConversational(conversational));
                    } else {
                        this.checkAllTargetConversationalsInSameConversation(definition);
                        if (conversationalType == ConversationalType.TWO_WAY_SENDER && !ConversationalHelper.isValidTwoWayTargetNode(targetConversational)) {
                            this.reportWarning(conversational, ConversationalException.createInvalidTwoWayProcessCall(conversational));
                        }
                    }
                }
            }
        }
    }

    private void checkAllTargetConversationalsInSameConversation(@NotNull ProcessCallConversationalDefinition definition) {
        Conversational conversational = definition.getParentObject();
        Conversation conversation = conversational.getConversation();
        if (conversation != null) {
            Sequence<Conversational> conversationalsInConversation = conversation.getConversationals();
            Conversation tempTargetConversation = null;
            for (Conversational conversationalInConversation : conversationalsInConversation) {
                ProcessCallConversationalDefinition conversationalInConversationDefinition = conversationalInConversation.getConversationalDefinition().as(ProcessCallConversationalDefinition.class);
                Conversational targetConversational = conversationalInConversationDefinition.getTargetConversational();
                if (tempTargetConversation == null) {
                    tempTargetConversation = targetConversational.getConversation();
                    continue;
                }
                if (tempTargetConversation == targetConversational.getConversation()) continue;
                this.reportError(conversational, ConversationalException.createInvalidTargetConversation(conversational));
                break;
            }
        }
    }

    private void checkDefinedOperationName(@NotNull DefineInterfaceConversationalDefinition definition) {
        Conversational conversational = definition.getParentObject();
        String definedOperationName = definition.getDefinedOperationName();
        if (Str.isEmpty(definedOperationName)) {
            this.reportError(conversational, ConversationalException.createNullDefinedOperationName(conversational));
        } else if (ConversationalHelper.definedOperationNameExists(definedOperationName, definition)) {
            this.reportError(conversational, ConversationalException.createDuplicatedDefinedOperationName(conversational));
        }
    }

    private void checkReplyToAndError(@NotNull DefineInterfaceConversationalDefinition definition) {
        Conversational conversational = definition.getParentObject();
        Conversational replyTo = definition.getReplyTo();
        if (replyTo != null) {
            if (!ConversationalHelper.getPossibleReplyTos(conversational).contains(replyTo)) {
                this.reportError(conversational, ConversationalException.createInvalidReplyTo(conversational));
            } else {
                Sequence<ErrorObject> errors;
                ErrorObject error = definition.getError();
                if (error != null && !(errors = ConversationalHelper.getReplyToErrors(replyTo)).contains(error)) {
                    this.reportError(conversational, ConversationalException.createInvalidError(conversational));
                }
            }
        }
    }

    private void checkArgumentsType(@NotNull DefineInterfaceConversationalDefinition definition) {
        DataDeclarationContainer argumentsContainer = definition.getArgumentsContainer();
        int numOfArgs = 0;
        boolean hasArgumentFromWsdl = false;
        for (DataDeclaration argument : argumentsContainer.getLocalDeclarations()) {
            CatalogType type = argument.getType();
            if (type.isUnknown()) {
                this.reportError(this.node, ArgumentException.createInvalidType(this.node, argument));
            } else {
                TypeDescription typeDescription = type.getDelegate();
                if (typeDescription.isSchemaObject() && typeDescription.asSchemaObject().isFromWsdl()) {
                    hasArgumentFromWsdl = true;
                    if (!typeDescription.asSchemaObject().isElement()) {
                        this.reportError(this.node, ArgumentException.createNonElementFromWsdl(this.node, argument));
                    }
                }
            }
            ++numOfArgs;
        }
        if (hasArgumentFromWsdl && numOfArgs > 1) {
            this.reportError(this.node, ArgumentException.createMoreThanOneArgumentFromWsdl(this.node));
        }
    }

    private void checkSyncValidPath(@NotNull DefineInterfaceConversationalDefinition definition) {
        Sequence<Conversational> repliers;
        ErrorObject error;
        Conversational conversational = definition.getParentObject();
        Conversational replyTo = definition.getReplyTo();
        if (replyTo != null && (error = definition.getError()) != null && (repliers = ConversationalHelper.getAllRepliers(replyTo, true)).isEmpty()) {
            this.reportError(conversational, ConversationalException.createMissingSyncValidPath(conversational, replyTo));
        }
    }

    private void checkReplierInterface(@NotNull DefineInterfaceConversationalDefinition definition) {
        Conversational conversational = definition.getParentObject();
        Conversational replyTo = definition.getReplyTo();
        if (replyTo != null && definition.getError() == null) {
            Sequence<Conversational> repliers = ConversationalHelper.getAllRepliers(replyTo, true);
            for (Conversational replier : repliers) {
                DataDeclarationContainer replierArgumentsContainer;
                DefineInterfaceConversationalDefinition replierDefinition = replier.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                DataDeclarationContainer nodeArgumentsContainer = definition.getArgumentsContainer();
                if (this.isSameInterface(nodeArgumentsContainer, replierArgumentsContainer = replierDefinition.getArgumentsContainer())) continue;
                this.reportError(conversational, ConversationalException.createInvalidReplierArguments(conversational));
                break;
            }
        }
    }

    private void checkUseInterfaceReferenceAndOperation(@NotNull UseInterfaceConversationalDefinition definition) {
        Conversational conversational = definition.getParentObject();
        ReferenceObject reference = definition.getReference();
        if (reference == null) {
            this.reportError(conversational, ConversationalException.createNullReference(conversational));
        } else {
            Sequence<ReferenceObject> references = ConversationalHelper.getConversationalReferences(conversational);
            if (!references.contains(reference)) {
                this.reportError(conversational, ConversationalException.createInvalidReference(conversational));
            } else {
                CatalogMember operation = definition.getOperation();
                if (operation == null) {
                    this.reportError(conversational, ConversationalException.createNullOperation(conversational));
                } else {
                    Sequence<CatalogMember> operations = reference.getChildrenByType(CatalogMember.class);
                    if (!operations.contains(operation)) {
                        this.reportError(conversational, ConversationalException.createInvalidOperation(conversational));
                    }
                }
            }
        }
    }

    private void checkServiceCallServiceAndOperation(@NotNull ServiceCallConversationalDefinition definition) {
        Conversational conversational = definition.getParentObject();
        ServiceObject service = definition.getService();
        if (service == null) {
            this.reportError(conversational, ConversationalException.createNullService(conversational));
        } else {
            Sequence<ServiceObject> services = ConversationalHelper.getConversationalServices(conversational);
            if (!services.contains(service)) {
                this.reportError(conversational, ConversationalException.createInvalidService(conversational));
            } else {
                CatalogMember operation = definition.getOperation();
                if (operation == null) {
                    this.reportError(conversational, ConversationalException.createNullOperation(conversational));
                } else {
                    Sequence<CatalogMember> operations = service.getChildrenByType(CatalogMember.class);
                    if (!operations.contains(operation)) {
                        this.reportError(conversational, ConversationalException.createInvalidOperation(conversational));
                    }
                }
            }
        }
    }

    private boolean isSameInterface(@NotNull DataDeclarationContainer interface1, @NotNull DataDeclarationContainer interface2) {
        DataDeclaration[] interfaceArray2;
        DataDeclaration[] interfaceArray1 = interface1.getLocalDeclarations().toArray(new DataDeclaration[0]);
        if (interfaceArray1.length == (interfaceArray2 = interface2.getLocalDeclarations().toArray(new DataDeclaration[0])).length) {
            for (int i = 0; i < interfaceArray1.length; ++i) {
                if (interfaceArray1[i].getName().equals(interfaceArray2[i].getName()) && interfaceArray1[i].getType().equals(interfaceArray2[i].getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

