/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.activities.ActivityPermissionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConversationHelper {
    private static final Predicate<ConversationEnabled> IS_INITIATOR_PREDICATE = new Predicate<ConversationEnabled>(){

        @Override
        public boolean check(@Nullable ConversationEnabled value) {
            return value != null && value.isConversationInitiator();
        }
    };
    private static final Predicate<ConversationEnabled> IS_CATCHER_PREDICATE = new Predicate<ConversationEnabled>(){

        @Override
        public boolean check(@Nullable ConversationEnabled value) {
            return value != null && ConversationHelper.isCatcher(value);
        }
    };
    private static final Predicate<ConversationEnabled> IS_THROWER_PREDICATE = new Predicate<ConversationEnabled>(){

        @Override
        public boolean check(@Nullable ConversationEnabled value) {
            return value != null && !ConversationHelper.isCatcher(value);
        }
    };
    private static final Predicate<ConversationEnabled> IS_ASYNC_PREDICATE = new Predicate<ConversationEnabled>(){

        @Override
        public boolean check(@Nullable ConversationEnabled value) {
            return value != null && !value.isSync();
        }
    };
    private static final String DEFAULT_INVOKE_OPERATION_NAME = "operation";
    private static final String DEFAULT_CALLBACK_OPERATION_NAME = "operationCallback";

    public static Sequence<ConversationEnabled> getPossibleInitiators(final @NotNull ConversationEnabled continuator) {
        Predicate<ConversationEnabled> predicate = PredicateUtils.and(IS_INITIATOR_PREDICATE, new Predicate<ConversationEnabled>(){

            @Override
            public boolean check(@Nullable ConversationEnabled value) {
                return value != null && !value.getId().equals(continuator.getId()) && !EndEvent.class.isAssignableFrom(value.getRawClass());
            }
        });
        return ConversationHelper.getConversationNodes(continuator.getProcess(), continuator.getBpmnType()).select(predicate);
    }

    public static Sequence<ConversationEnabled> getContinuatorsThrowers(@NotNull ConversationEnabled initiator, boolean includeErrors) {
        Sequence<ConversationEnabled> result = ConversationHelper.getConversationNodes(initiator.getProcess(), initiator.getBpmnType()).select(PredicateUtils.and(ConversationHelper.createContinuatorPredicate(initiator), IS_THROWER_PREDICATE));
        if (!includeErrors) {
            result = result.select(new Predicate<ConversationEnabled>(){

                @Override
                public boolean check(@Nullable ConversationEnabled value) {
                    return value != null && value.getAssociatedError() == null;
                }
            });
        }
        return result;
    }

    public static Sequence<ConversationEnabled> getContinuatorsCatchers(@NotNull ConversationEnabled initiator) {
        return ConversationHelper.getConversationNodes(initiator.getProcess(), initiator.getBpmnType()).select(PredicateUtils.and(ConversationHelper.createContinuatorPredicate(initiator), IS_CATCHER_PREDICATE));
    }

    public static Sequence<ConversationEnabled> getAllInitiatorCatchers(@NotNull Process process, BpmnType type) {
        return ConversationHelper.getConversationNodes(process, type).select(PredicateUtils.and(IS_INITIATOR_PREDICATE, IS_CATCHER_PREDICATE));
    }

    public static Sequence<ConversationEnabled> getAsyncInitiatorCatchers(@NotNull Process process, BpmnType type) {
        return ConversationHelper.getAllInitiatorCatchers(process, type).select(IS_ASYNC_PREDICATE);
    }

    public static boolean isCatcher(@Nullable ConversationEnabled conversationNode) {
        return conversationNode != null && (CatchEvent.class.isAssignableFrom(conversationNode.getRawClass()) || ReceiveTask.class.isAssignableFrom(conversationNode.getRawClass()));
    }

    public static boolean isDefiner(@Nullable ConversationEnabled conversationNode) {
        return conversationNode != null && !Str.isEmpty(conversationNode.getDefinedOperationName());
    }

    public static boolean usesInitiatorOperation(ConversationEnabled conversationNode) {
        boolean result = false;
        if (conversationNode != null) {
            ConversationEnabled conversationInitiator = conversationNode.getConversationInitiator();
            if (conversationNode.getDefinedOperationName() != null && conversationInitiator != null) {
                result = Any.equals(conversationNode.getDefinedOperationName(), conversationInitiator.getDefinedOperationName());
            }
        }
        return result;
    }

    public static boolean usesService(@Nullable ConversationEnabled conversationNode) {
        return conversationNode != null && conversationNode.getParticipant() != null;
    }

    public static boolean usesProcess(@Nullable ConversationEnabled conversationNode) {
        return conversationNode != null && conversationNode.getAssociatedProcess() != null;
    }

    public static boolean usesError(@Nullable ConversationEnabled conversationNode) {
        return conversationNode != null && conversationNode.getAssociatedError() != null;
    }

    public static boolean hasImplementation(@Nullable ConversationEnabled conversationNode) {
        return ConversationHelper.isDefiner(conversationNode) || ConversationHelper.usesService(conversationNode) || ConversationHelper.usesProcess(conversationNode) || ConversationHelper.usesError(conversationNode);
    }

    public static InterfaceObject getCallbackInterface(@NotNull InterfaceObject service) {
        for (InterfaceObject child : service.getChildrenByType(InterfaceObject.class)) {
            if (!child.isCallback()) continue;
            return child;
        }
        return null;
    }

    public static String getDefaultOperationName(@NotNull ConversationEnabled conversationalNode) {
        Process process = conversationalNode.getProcess();
        String defaultOperationRoot = ConversationHelper.isCatcher(conversationalNode) ? DEFAULT_INVOKE_OPERATION_NAME : DEFAULT_CALLBACK_OPERATION_NAME;
        int count = 0;
        String result = defaultOperationRoot;
        while (ConversationHelper.operationNameExists(process, result, null)) {
            result = defaultOperationRoot + ++count;
        }
        return result;
    }

    public static boolean operationNameExists(@NotNull String operationName, ConversationEnabled excludedNode) {
        Process process = excludedNode.getProcess();
        return ConversationHelper.operationNameExists(process, operationName, excludedNode);
    }

    public static boolean mustImplement(@NotNull ConversationEnabled conversationEnabled) {
        boolean result = false;
        ActivityPermissionFeature feature = conversationEnabled.getFeature(ActivityPermissionFeature.class);
        if (feature != null) {
            ActivityPermissionType type = (ActivityPermissionType)feature.getValue();
            result = type == ActivityPermissionType.SHOULD_DEFINE;
        }
        return result;
    }

    public static boolean isConversationServiceInUse(@NotNull ConversationEnabled serviceNode) {
        CatalogMember operation;
        CatalogMember catalogMember = operation = ConversationHelper.usesService(serviceNode) ? serviceNode.getOperation() : null;
        if (operation != null) {
            Process process = serviceNode.getProcess();
            Sequence<ConversationEnabled> nodes = ConversationHelper.getConversationNodes(process, null).select(IS_INITIATOR_PREDICATE);
            for (ConversationEnabled node : nodes) {
                if (serviceNode.getId().equals(node.getId()) || node.getOperation() == null || !node.getOperation().equals(operation)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean operationNameExists(@NotNull Process process, @NotNull String operationName, @Nullable ConversationEnabled excludedNode) {
        for (ConversationEnabled node : ConversationHelper.getConversationNodes(process, null)) {
            boolean excludeValidation = false;
            if (excludedNode != null) {
                boolean bl = excludeValidation = excludedNode.getId().equals(node.getId()) || ConversationHelper.isSyncPair(excludedNode, node) || ConversationHelper.isSyncPair(node, excludedNode) || ConversationHelper.isCatcherCatcherAsyncPair(excludedNode, node) || ConversationHelper.isCatcherCatcherAsyncPair(node, excludedNode);
            }
            if (excludeValidation || node.getDefinedOperationName() == null || !operationName.equals(node.getDefinedOperationName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSyncPair(@NotNull ConversationEnabled initiator, @NotNull ConversationEnabled continuator) {
        return initiator.isSync() && continuator.getConversationInitiator() == initiator;
    }

    private static boolean isCatcherCatcherAsyncPair(@NotNull ConversationEnabled initiator, @NotNull ConversationEnabled continuator) {
        return ConversationHelper.isCatcher(initiator) && ConversationHelper.isCatcher(continuator) && !initiator.isSync() && continuator.getConversationInitiator() == initiator;
    }

    private static Sequence<ConversationEnabled> getConversationNodes(@NotNull Process process, final BpmnType type) {
        Predicate<ConversationEnabled> predicate = new Predicate<ConversationEnabled>(){

            @Override
            public boolean check(@Nullable ConversationEnabled value) {
                return value != null && value.isConversationMember() && value.getBpmnType() != BpmnType.SERVICE_TASK && (type == null || value.getBpmnType().isActivity() == type.isActivity() && value.getBpmnType().isEvent() == type.isEvent());
            }
        };
        return process.getDescendants(ConversationEnabled.class).select(predicate);
    }

    private static Predicate<ConversationEnabled> createContinuatorPredicate(final ConversationEnabled initiator) {
        return new Predicate<ConversationEnabled>(){

            @Override
            public boolean check(@Nullable ConversationEnabled value) {
                ConversationEnabled conversationInitiator;
                boolean result = value != null ? (conversationInitiator = value.getConversationInitiator()) != null && conversationInitiator.getId().equals(initiator.getId()) : false;
                return result;
            }
        };
    }
}

