/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.msg;

import oracle.bpm.log.ErrorRange;
import oracle.bpm.log.LogComponent;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.TErrorMsg;
import oracle.bpm.resources.TMsg;
import org.jetbrains.annotations.NotNull;

public class ProjectCompileMsg
extends MsgBundle {
    public static final Msg UNASSIGNED_ROLE = ProjectCompileMsg.msg("Unassigned role");
    public static final Msg ACTIVITY_GUIDE_IN_CASE_PROJECT = ProjectCompileMsg.msg("Milestones defined in Activity Guide in a Project with Case. Since Case has a first class concept of Milestones, Activity Guide is not needed for Milestone tracking.");
    private static final TMsg DUPLICATE_DATAOBJECT_NAME = ProjectCompileMsg.tmsg("Can not have a process data object named the same as a project data object: %0");
    private static final TMsg UNKNOWN_DATAOBJECT_TYPE = ProjectCompileMsg.tmsg("Unknown type: %1 for dataobject: %0");
    private static final TMsg PROJECT_DATA_OBJECT_SHOULD_BE_PREDEFINED = ProjectCompileMsg.tmsg("Project data object (%0) should have a primitive type and has type (%1)");
    private static final TMsg BUSINESS_INDICATOR_NOT_A_COUNTER = ProjectCompileMsg.tmsg("Flow node (%0) contains a business indicator that is not a counter (%1)");
    public static final TMsg MORE_THAN_ONE_INTERRUPTING_TIMER = ProjectCompileMsg.tmsg("Flow node %0 has more than one interrupting timer event");
    private static final TMsg MESSAGE_ALREADY_HANDLED = ProjectCompileMsg.tmsg("Service/Operation (%0/%1) already handled in boundary event from activity (%2)");
    public static final Msg BOUNDARY_EVENT_NOT_ALLOWED_IN_EBG_PATHS = ProjectCompileMsg.msg("Boundary Events are not allowed in tasks that are part of an Event-based Gateway");
    public static final Msg EBG_SHOULD_HAVE_AT_LEAST_2_OUTFLOWS = ProjectCompileMsg.msg("Event-based Gateway should have at least 2 outgoing Sequence Flows");
    public static final TMsg ROUTE_BETWEEN_MESSAGE_START_AND_INITIATE_RECEIVE = ProjectCompileMsg.tmsg("There is a possible path between a Message-based Start Event (%0) and an Initiator Receive Task (%1)");
    public static final TMsg INITIATE_RECEIVE_MUST_BE_THE_FIRST = ProjectCompileMsg.tmsg("An Initiator Receive Task (%0) must be the first task after a None Event");
    public static final TMsg INITIATE_RECEIVE_MUST_USE_INBOUND_CONVERSATION = ProjectCompileMsg.tmsg("An Initiator Receive Task (%0) can only be used on inbound conversations");
    public static final Msg CALLABLE_SUBPROCESS_ALLOWS_NONE_ONLY = ProjectCompileMsg.msg("Start Event can only be of type None in Callable Subprocesses");
    public static final Msg CALLABLE_SUBPROCESS_WITH_MULTIPLE_STARTS = ProjectCompileMsg.msg("Callable Subprocess allow only one Start Event of type None");
    public static final TMsg CALLABLE_SUBPROCESS_NODE_CANNOT_CREATE_INSTANCE = ProjectCompileMsg.tmsg("Flow Node %0 cannot create instance in a Callable Subprocess");
    public static final Msg RANGE_NAME_IS_EMPTY = ProjectCompileMsg.msg("Range name must not be empty");
    public static final Msg EMPTY_EXPRESSION_NOT_ALLOWED = ProjectCompileMsg.msg("Expression should not be empty");
    private static final TMsg BI_MUST_BE_MEASURE = ProjectCompileMsg.tmsg("Business Indicator (%0) used in Measurement Mark should be of type Measure");
    public static final Msg SUBPROCESS_HAS_NO_START_OR_END_EVENT = ProjectCompileMsg.msg("Subprcess should have at least a Start and an End Event");
    public static final Msg NO_INITIATOR_TASK_ALLOWED_IN_CALLABLE_SUBPROCESS = ProjectCompileMsg.msg("Initiator tasks are not allowed in Callable Subprocesses");
    public static final Msg MEASUREMENT_HAS_NO_BI = ProjectCompileMsg.msg("Measurement should have at least one Business Indicator defined");
    public static final Msg INVALID_TRIGGER_TYPE_FOR_BOUNDARY = ProjectCompileMsg.msg("Invalid trigger type for Boundary Event");
    public static final Msg INVALID_BOUNDARY = ProjectCompileMsg.msg("This construct does not allow Boundary Events");
    public static final Msg THROW_EVENTS_NOT_ALLOWED_IN_EBG = ProjectCompileMsg.msg("Throw Events are not allowed as target of Event-based Gateways, only Catch Events are");
    public static final Msg INVALID_EVENT_TYPE_FOR_EBG = ProjectCompileMsg.msg("Invalid event type for Event-based Gateway");
    public static final Msg EVENT_BASED_SHOULD_CONNECT_TO_EVENTS = ProjectCompileMsg.msg("Event-based Gateways cannot combine Message-catch Events and Receive Tasks as triggers.");
    public static final Msg EVENT_BASED_SHOULD_CONNECT_TO_EVENTS_OR_RECEIVE = ProjectCompileMsg.msg("Only Catch Events and Receive Tasks are allowed as target of Event--based Gateways.");
    public static final Msg NESTED_EVENT_SUBPROCESS_NOT_ALLOWED = ProjectCompileMsg.msg("An Event-triggered Subprocess cannot be inside an Event-triggered Subprocess");
    public static final Msg INTEMEDIATE_ERROR_EVENTS_SHOULD_NOT_BE_INTERMEDIATE = ProjectCompileMsg.msg("Error-catch Events must start a flow. They cannot be intermediate nodes.");
    private static final TMsg BOUNDARY_ALREADY_HANDLED = ProjectCompileMsg.tmsg("%0 already defined in boundary event %1 of task %2");
    private static final TMsg ERROR_NOT_DEFINED = ProjectCompileMsg.tmsg("Error not defined in Event '%0'");
    private static final TMsg MULTIPLE_START_NOT_ALLOWED = ProjectCompileMsg.tmsg("Multiple Start nodes are not allowed in this context (%0)");
    private static final TMsg CANNOT_EXIT_ABORT_PENDING_FLOWS = ProjectCompileMsg.tmsg("Cannot exit a gateway circuit that aborts pending flows (%0)");
    private static final TMsg CALL_ACTIVITY_HAS_NO_CALLABLE = ProjectCompileMsg.tmsg("Call activity '%0' has no reusable process defined");
    private static final TMsg CALL_ACTIVITY_HAS_RELATED_NON_CALLABLE = ProjectCompileMsg.tmsg("Call activity '%0' is calling a non reusable process");
    private static final TMsg ARGUMENT_INVALID_TYPE = ProjectCompileMsg.tmsg("Argument %1 has an invalid type in node %0");
    private static final TMsg ARGUMENT_MORE_THAN_ONE_FROM_WSDL = ProjectCompileMsg.tmsg("When using one argument of an inner type defined in a WSDL, there must be only one argument defined (Node %0)");
    private static final TMsg ARGUMENT_NON_ELEMENT_FROM_WSDL = ProjectCompileMsg.tmsg("The argument %1 of node %0 must be of element type if defined in a WSDL");
    private static final TMsg INVALID_CONDITIONAL_FLOW = ProjectCompileMsg.tmsg("Node %0 cannot have outgoing Conditional Flows");
    private static final TMsg MEASUREMENT_MARK_STOP_WITHOUT_START = ProjectCompileMsg.tmsg("Measurement Mark '%0' of type 'Interval Stop' should have a Measurement Mark of type 'Interval Start' associated.");
    private static final TMsg MEASUREMENT_MARK_START_WITHOUT_STOP = ProjectCompileMsg.tmsg("Measurement Mark '%0' of type 'Interval Start' should have at least a Measurement Mark of type 'Interval Stop' associated.");
    public static final TMsg COMPONENT_NOT_FOUND_IN_CATALOG = ProjectCompileMsg.tmsg("Service '%0' was not found in Business Catalog");
    public static final TMsg PRJ_00046 = ProjectCompileMsg.tmsg("Activity %0 is an exception handler but also belongs to Flow %1. All Exception Handling Flows must be isolated from other Flows (Exception Handling, Compensation, or Main).");
    private static final TMsg PRJ_00048 = ProjectCompileMsg.tmsg("Converging Gateway '%0' was already matched with the Diverging Gateway '%1'. Each Diverging Gateway activity must have their own corresponding Converging Gateway.");
    private static final TMsg PRJ_00049 = ProjectCompileMsg.tmsg("Data Association expression is not valid in node '%0':  %1");
    public static final TMsg MTM_02012 = ProjectCompileMsg.tmsg("The Gateway Circuit is not complete. The reason this has occurred is most likely because activity ('%0') is a Converging Gateway with no corresponding Diverging Gateway or because there is a sequence flow from a node outside the Gateway Circuit to a node inside the Gateway Circuit.");
    public static final Msg MTM_02001 = ProjectCompileMsg.msg("Process should have at least one Start Event");
    public static final Msg MTM_02002 = ProjectCompileMsg.msg("Process should have at least one End Event");
    public static final TMsg MTM_02044 = ProjectCompileMsg.tmsg("Node ('%0') belongs to flow ('%1') and has an incoming Sequence Flow from another flow type ('%2') that comes from node ('%3'). This is probably occurring because: 1) You are adding a sequence flow from a node inside a Gateway Circuit to a node outside of a Gateway Circuit or 2) You are connecting an Exception or Compensate flow to the Main flow.");
    public static final TMsg MOVED_FROM_TO = ProjectCompileMsg.tmsg("Moved from %0 to %1");
    public static final Msg DSG_00004 = ProjectCompileMsg.msg("The process name cannot be empty.");
    public static final TMsg DSG_01003 = ProjectCompileMsg.tmsg("Error in method: '%0'");
    public static final TMsg MTM_02005 = ProjectCompileMsg.tmsg("Node '%0' does not have any incoming Sequence Flows.");
    public static final TMsg MTM_02024 = ProjectCompileMsg.tmsg("Node '%0' does not have an outgoing Default Sequence Flow");
    public static final TMsg MTM_02026 = ProjectCompileMsg.tmsg("Node '%0' has more than one outgoing Unconditional Sequence Flow.");
    public static final TMsg MTM_02027 = ProjectCompileMsg.tmsg("Node '%0' has more than one outgoing Sequence Flow going to the same destination node.");
    public static final TMsg MTM_02037 = ProjectCompileMsg.tmsg("Node '%0' cannot be moved to that position. There is no Role available.");
    public static final TMsg MTM_02054 = ProjectCompileMsg.tmsg("('%0') is a Diverging Gateway and has Sequence Flows that came out from it but never passed through a Converging Gateway.");
    public static final TMsg MTM_02058 = ProjectCompileMsg.tmsg("Name ('%0') already exists in the design.");
    public static final TMsg MTM_02061 = ProjectCompileMsg.tmsg("Node ('%0') cannot be placed in an anonymous role.");
    public static final TMsg MTM_02064 = ProjectCompileMsg.tmsg("Node name '%0' contains invalid characters.");
    public static final TMsg MTM_02065 = ProjectCompileMsg.tmsg("Node name '%0' cannot start with a number.");
    public static final TMsg MTM_02097 = ProjectCompileMsg.tmsg("Node '%0' does not match with any Converging Gateway.");
    public static final TMsg MTM_02112 = ProjectCompileMsg.tmsg("Sequence Flows from node '%0' outside group '%1' to node '%2' inside the group are not allowed.");
    public static final TMsg MTM_02113 = ProjectCompileMsg.tmsg("Sequence Flows from node '%0' inside group '%1' to node '%2' outside the group are not allowed.");
    public static final TMsg MTM_02121 = ProjectCompileMsg.tmsg("Diverging Gateway '%0' and Converging Gateway '%1' must belong to the same Group");
    public static final TMsg MTM_03002 = ProjectCompileMsg.tmsg("An I/O exception occurred while reading process file [%0].");
    public static final TMsg MTM_03003 = ProjectCompileMsg.tmsg("The process source is not a well formed file [%0].");
    public static final TMsg MTM_03006 = ProjectCompileMsg.tmsg("A general exception occurred while parsing process file [%0].");
    public static final TMsg PRJ_00001 = ProjectCompileMsg.tmsg("Node '%0' has incoming Sequence Flows when it should not.");
    public static final TMsg PRJ_00002 = ProjectCompileMsg.tmsg("Node '%0' does not have any outgoing Sequence Flows.");
    public static final TMsg PRJ_00003 = ProjectCompileMsg.tmsg("Node '%0' has outgoing Sequence Flows when it should not");
    public static final TMsg PRJ_00011 = ProjectCompileMsg.tmsg("%0 '%1' has more than one default outgoing sequence flow.");
    public static final TMsg PRJ_00025 = ProjectCompileMsg.tmsg("Role %0 is Parametric but it does not have a Data Object defined as a parameter.");
    public static final TMsg PRJ_00058 = ProjectCompileMsg.tmsg("Variable %0 was not found in the model.");
    public static final TMsg PRJ_00066 = ProjectCompileMsg.tmsg("Measurement '%0' is marked as 'Interval End' but does not have a Interval Start Measurement configured.");
    public static final TMsg PRJ_00080 = ProjectCompileMsg.tmsg("Event-triggered Subprocess (%0) with more than one Start Event.");
    public static final TMsg PRJ_00081 = ProjectCompileMsg.tmsg("Event-triggered Subprocess (%0) with Start Event with a trigger of type None.");
    public static final TMsg PRJ_00082 = ProjectCompileMsg.tmsg("The %0 expression from node (%1) is empty.");
    public static final TMsg EMPTY_EXPRESSION_IN_SEQUENCE_FLOW = ProjectCompileMsg.tmsg("The condition in Sequence Flow (%0) is empty.");
    public static final Msg MTM_02063 = ProjectCompileMsg.msg("This node does not have a name.");
    public static final Msg MTM_03001 = ProjectCompileMsg.msg("A general exception occurred while parsing the process source.");
    public static final TMsg MTM_03008 = ProjectCompileMsg.tmsg("File cannot be parsed. Caused by: %0");
    public static final Msg PRJ_00090 = ProjectCompileMsg.msg("Crimson parser bug: Character ']' in a possition multiple of 8192. Add or remove a space in a previous position (inside CDATA) to avoid it.");
    private static final TMsg PRJ_00112 = ProjectCompileMsg.tmsg("Role '%0' associated to a model must exist.");
    public static final TMsg ERROR = ProjectCompileMsg.tmsg("Error: %0");
    private static final TMsg INVALID_LOCATION = ProjectCompileMsg.tmsg("Invalid location to place node %0");
    public static final Msg MAIN_FLOW = ProjectCompileMsg.msg("Main Flow");
    public static final Msg EXCEPTION_HANDLING_FLOW = ProjectCompileMsg.msg("Exception Handling Flow");
    private static final TMsg SERVICE_PROPERTY_EXPRESSION_IS_INVALID = ProjectCompileMsg.tmsg("The expression in service property '%1' of node '%0' is invalid: %2");
    private static final TMsg MESSAGE_HEADER_NAME_IS_INVALID = ProjectCompileMsg.tmsg("The message header '%1' of node '%0' is invalid");
    private static final TMsg MESSAGE_HEADER_TYPE_IS_INVALID = ProjectCompileMsg.tmsg("The message header type for '%1' of node '%0' is invalid");
    public static final Msg COMPENSATION_FLOW = ProjectCompileMsg.msg("Compensation Flow");
    public static final TMsg SPLIT_FLOW = ProjectCompileMsg.tmsg("Diverging Gateway flow originated by node '%0'");
    public static final TMsg FLOWNODE_HAS_NO_IMPLEMENTATION = ProjectCompileMsg.tmsg("Node '%0' has no implementation defined");
    private static final TMsg NO_ROLES_FOR_SIMULATION_RESOURCE = ProjectCompileMsg.tmsg("No roles selected for simulation resource %0");
    private static final TMsg SIMULATION_RESOURCE_EFFICIENCY_VALUE_ERROR = ProjectCompileMsg.tmsg("Efficiency value for simulation resource %0 should be between 0%% and 100%%");
    private static final TMsg SIMULATION_INVALID_RESOURCE_NAME = ProjectCompileMsg.tmsg("Invalid ID '%0' for resource.");
    private static final TMsg SIMULATION_RESOURCE_AVAILABILITY_VALUE_ERROR = ProjectCompileMsg.tmsg("Availability value for simulation resource %0 should be between 0%% and 100%%");
    private static final TMsg SIMULATION_CATEGORY_PROBABILITIES_VALUE_ERROR = ProjectCompileMsg.tmsg("Category probabilities for project simulation %0 exceed 100%%");
    private static final TMsg UNKNOWN_PROPERTY_IN_KEY = ProjectCompileMsg.tmsg("%2 has an unknown property (%0) in correlation key (%1)");
    public static final TErrorMsg CATALOG_OBJECT_INVALID_ATTRIBUTE = ProjectCompileMsg.tErrorMsg("Business Catalog object '%0' is not valid. The attribute name '%1' is referencing an XML Schema %2 '%3' that cannot be found in the project.\".", "This can happen if the XML Schema element or complex type is removed", "Check the project XML Schemas files");
    public static final TErrorMsg CATALOG_OBJECT_INVALID_METHOD_PARAMETER = ProjectCompileMsg.tErrorMsg("Business Catalog object '%0' is not valid. The parameter '%1' of the method '%2' is referencing an XML Schema %3 '%4' that cannot be found in the project.", "This can happen if the XML Schema element or complex type is removed", "Check the project XML Schemas files");
    public static final Msg PARALLEL_GATEWAY_HAS_CONDITIONAL_FLOWS = ProjectCompileMsg.msg("Parallel Gateway cannot have outgoing Conditional Sequence Flows");
    private static final TMsg EVENT_HAS_NO_SIGNAL_DEFINED = ProjectCompileMsg.tmsg("Event %0 has no Signal defined");
    private static final TMsg INITIATE_HAS_INVALID_PREDECESSORS = ProjectCompileMsg.tmsg("There is a possible path between start node %1 and User initiator task %0. Start event should be none ");
    private static final TMsg NO_BLOCKING_NODE_ALLOWED = ProjectCompileMsg.tmsg("No blocking nodes (%1) are allowed between start node and initiator task (%0)");
    private static final TMsg SERVICE_TASK_BEFORE_INITIATOR = ProjectCompileMsg.tmsg("Service Task (%0) should not be blocker.");
    private static final TMsg PROCESS_HAS_MORE_THAN_ONE_INITIATE_TASK = ProjectCompileMsg.tmsg("Process %0 has more than one initiate user task (%1, %2)");
    private static final TMsg INVALID_TYPE_FOR_CASE_DATA = ProjectCompileMsg.tmsg("Invalid type for case data '%0' in case definition");
    private static final TMsg INVALID_NAME_FOR_CASE_DATA = ProjectCompileMsg.tmsg("Invalid name for case data with type '%0' in case definition");
    private static final TMsg DUPLICATED_INPUT_DATA = ProjectCompileMsg.tmsg("Duplicated input data '%0' for case activity '%1'");
    private static final TMsg DUPLICATED_OUTPUT_DATA = ProjectCompileMsg.tmsg("Duplicated output data '%0' for case activity '%1'");
    private static final TMsg DUPLICATED_CASE_DATA = ProjectCompileMsg.tmsg("Duplicated data name '%0' in case definition");
    private static final TMsg DUPLICATED_CASE_EVENT = ProjectCompileMsg.tmsg("Duplicated event name '%0' in case definition");
    private static final TMsg DUPLICATED_CASE_MILESTONE = ProjectCompileMsg.tmsg("Duplicated milestone '%0' in case definition");
    private static final TMsg DUPLICATED_STAKEHOLDER = ProjectCompileMsg.tmsg("Duplicated stakeholder name '%0' in case definition");
    private static final TMsg DUPLICATED_PERMISSION = ProjectCompileMsg.tmsg("Duplicated permission name '%0' in case definition");
    private static final TMsg STAKEHOLDER_VALUE_IS_EMPTY = ProjectCompileMsg.tmsg("Stakeholder '%0' has an empty value");
    private static final TMsg INVALID_PROCESS_ROLE_IN_STAKEHOLDER = ProjectCompileMsg.tmsg("Stakeholder '%0' has an invalid Process Role named '%1'");
    private static final TMsg CASE_ACTIVITY_PERMISSION_NOT_AVAILABLE = ProjectCompileMsg.tmsg("Permission '%0' for case activity '%1' is not available in Case permissions");
    private static final TMsg CASE_ACTIVITY_AUTOMATIC_WITH_PAYLOAD = ProjectCompileMsg.tmsg("Case Activity '%0' cannot be marked automatic since has payload data defined in input parameters");
    private static final TMsg CASE_ACTIVITY_INPUT_DATA_EMPTY_CASE_DATA = ProjectCompileMsg.tmsg("Input data '%0' for case activity '%1' has an empty Case data name");
    private static final TMsg CASE_ACTIVITY_INPUT_DATA_CASE_DATA_INVALID = ProjectCompileMsg.tmsg("Input data '%0' for case activity '%1' has an invalid Case data name");
    private static final TMsg CASE_ACTIVITY_OUTPUT_DATA_CASE_DATA_INVALID = ProjectCompileMsg.tmsg("Output data '%0' for case activity '%1' has an invalid Case data name");
    private static final TMsg CASE_ACTIVITY_INPUT_DATA_TYPE_NOT_MATCH = ProjectCompileMsg.tmsg("Input data '%0' for case activity '%1' has a different type in Case data");
    private static final TMsg CASE_ACTIVITY_OUTPUT_DATA_TYPE_NOT_MATCH = ProjectCompileMsg.tmsg("Output data '%0' for case activity '%1' has a different type in Case data");
    private static final TMsg CASE_ACTIVITY_INPUT_DATA_BPMN_NOT_MATCH = ProjectCompileMsg.tmsg("Input data for case activity '%0' is not matching with operation '%1' in BPMN Process '%2'");
    private static final TMsg CASE_ACTIVITY_OUTPUT_DATA_BPMN_NOT_MATCH = ProjectCompileMsg.tmsg("Output data for case activity '%0' is not matching with operation '%1' in BPMN Process '%2'");
    private static final TMsg CASE_ACTIVITY_INPUT_DATA_NAME_BPMN_NOT_MATCH = ProjectCompileMsg.tmsg("Input data '%0' for case activity '%1' is not matching with operation '%2' in BPMN Process '%3'");
    private static final TMsg CASE_ACTIVITY_OUTPUT_DATA_NAME_BPMN_NOT_MATCH = ProjectCompileMsg.tmsg("Output data '%0' for case activity '%1' is not matching with operation '%2' in BPMN Process '%3'");
    private static final TMsg CASE_ACTIVITY_INPUT_DATA_TASK_NOT_MATCH = ProjectCompileMsg.tmsg("Input data for case activity '%0' is not matching with payload in Humantask '%1'");
    private static final TMsg CASE_ACTIVITY_OUTPUT_DATA_TASK_NOT_MATCH = ProjectCompileMsg.tmsg("Output data for case activity '%0' is not matching with payload in Humantask '%1'");
    private static final TMsg CASE_ACTIVITY_INPUT_DATA_NAME_TASK_NOT_MATCH = ProjectCompileMsg.tmsg("Input data '%0' for case activity '%1' is not matching with payload in Humantask '%2'");
    private static final TMsg CASE_ACTIVITY_OUTPUT_DATA_NAME_TASK_NOT_MATCH = ProjectCompileMsg.tmsg("Output data '%0' for case activity '%1' is not matching with payload in Humantask '%2'");
    private static final TMsg CASE_ACTIVITY_OUTPUT_DATA_EMPTY_CASE_DATA = ProjectCompileMsg.tmsg("Output data '%0' for case activity '%1' has an empty Case data name");
    private static final TMsg START_NONE_EVENT_IN_NON_CALLABLE = ProjectCompileMsg.tmsg("The start event %0 will never be used since the process is non callable");
    private static final TMsg INVALID_SEQUENCE_FLOW = ProjectCompileMsg.tmsg("Invalid sequence flow. Source %0, Target %1");
    private static final TMsg MAIN_TO_BOUNDARY_SEQUENCE_FLOW = ProjectCompileMsg.tmsg("Invalid Sequence Flow: it connects a node located in the Main flow (%0) to a node located in a Boundary Event flow (%1)");
    private static final TMsg BOUNDARY_TO_MAIN_SEQUENCE_FLOW = ProjectCompileMsg.tmsg("Invalid Sequence Flow connects a node located in a non-interrupting Boundary flow (%0) to a node located in Main flow (%1)");
    private static final TMsg DATA_ASSOCIATION_TARGET_REF_NULL = ProjectCompileMsg.tmsg("Null target reference in data association of node %0");
    private static final TMsg INVALID_USER_TASK_REINITIATE_SOURCE = ProjectCompileMsg.tmsg("The reinitiate source in user task %0 is null or invalid");
    private static final TMsg INVALID_USER_TASK_REINITIATE_INITIATOR = ProjectCompileMsg.tmsg("The user task %0 cannot reinitiate if it is defined as initiator");
    private static final TMsg INVALID_USER_TASK_DRAFT_INITIATOR = ProjectCompileMsg.tmsg("The user task %0 cannot be marked as draft if it is defined as initiator");
    private static final TMsg NON_INITIATOR_CORRELATION = ProjectCompileMsg.tmsg("The user task %0 cannot have correlations if it is not defined as initiator");
    private static final TMsg INVALID_ATTRIBUTE_EXPRESSION = ProjectCompileMsg.tmsg("'%1' expression in %0 is invalid: %2");
    private static final TMsg EMPTY_ATTRIBUTE_EXPRESSION = ProjectCompileMsg.tmsg("The '%1' expression in %0 cannot be null or empty");
    private static final TMsg INVALID_FLOWNODE_EXPRESSION = ProjectCompileMsg.tmsg("The expression in node %0 is invalid: %1");
    private static final TMsg INVALID_SEQUENCEFLOW_EXPRESSION = ProjectCompileMsg.tmsg("The expression in sequence flow (%0 to %1) is invalid: %2");
    private static final TMsg NO_VALID_PATH_FOR_MEASUREMENTS = ProjectCompileMsg.tmsg("There is no valid path between Interval Start (%0) and Interval Stop (%1)");
    private static final TMsg CORRELATION_PROPERTY_ALIAS_NULL_EMPTY_EXP = ProjectCompileMsg.tmsg("There is no expression defined for the correlation property %1 in node %0");
    private static final TMsg CORRELATION_PROPERTY_ALIAS_INVALID_EXP = ProjectCompileMsg.tmsg("The expression for the correlation property %1 in node %0 is invalid: %2");
    private static final TMsg CORRELATION_INVALID_KEY = ProjectCompileMsg.tmsg("The selected correlation key %1 in node %0 is invalid");
    private static final TMsg CORRELATION_INVALID_PROPERTY_IN_SELECTED_KEY = ProjectCompileMsg.tmsg("A selected correlation key references an invalid property (%1) in node %0");
    public static final TMsg EMPTY_MAIL_RECIPIENT_NOTIFICATION = ProjectCompileMsg.tmsg("At least one of the To, Cc or Bcc mail recipient expression is required in %0");
    private static final TMsg NULL_TARGET_TASK_IN_UPDATE = ProjectCompileMsg.tmsg("The target user task cannot be null in update task %0");
    public static final TMsg DATA_ASSOCIATION_EMPTY_SOURCE = ProjectCompileMsg.tmsg("Empty data association source expression in node %0");
    public static final TMsg DATA_ASSOCIATION_EMPTY_TARGET = ProjectCompileMsg.tmsg("Empty data association target expression in node %0");
    public static final TMsg DATA_ASSOCIATION_UNCHECKED_TARGET = ProjectCompileMsg.tmsg("Data association target expression in node %0 cannot not be checked. This could produce a runtime error: %1");
    private static final TMsg INVALID_LOG_HANDLER_TRIGGER = ProjectCompileMsg.tmsg("Log handler trigger '%1' is not available in node %0");
    private static final TMsg INVALID_LOG_HANDLER_EXPRESSION = ProjectCompileMsg.tmsg("Log handler expression for trigger '%1' in node %0 is not valid: %2");
    private static final TMsg UPDATE_TASK_WITH_NON_USER_TASK_IN_PROCESS = ProjectCompileMsg.tmsg("The update task %0 requires at least one user task in the current process");
    private static final TMsg CONVERSATIONAL_DEFINED_OPERATION_NAME_NULL = ProjectCompileMsg.tmsg("Defined operation name in node %0 cannot be null");
    private static final TMsg CONVERSATIONAL_DEFINED_OPERATION_NAME_DUPLICATED = ProjectCompileMsg.tmsg("The defined operation name in node %0 is already defined in the conversation");
    private static final TMsg CONVERSATIONAL_INVALID_REPLIER_ARGUMENTS = ProjectCompileMsg.tmsg("Invalid conversation arguments in node %0. All repliers of same node must implement the same arguments");
    private static final TMsg CONVERSATIONAL_MISSING_SYNC_VALID_PATH = ProjectCompileMsg.tmsg("There should be at least one valid path (non error) that replies the initiator node %0");
    private static final TMsg CONVERSATIONAL_INVALID_ERROR = ProjectCompileMsg.tmsg("The conversation error in node %0 is invalid");
    private static final TMsg CONVERSATIONAL_SERVICE_INVALID = ProjectCompileMsg.tmsg("The conversation service in node %0 is invalid");
    private static final TMsg CONVERSATIONAL_SERVICE_NULL = ProjectCompileMsg.tmsg("The conversation service in node %0 cannot be null");
    private static final TMsg CONVERSATIONAL_OPERATION_NULL = ProjectCompileMsg.tmsg("The conversation operation in node %0 cannot be null");
    private static final TMsg CONVERSATIONAL_OPERATION_INVALID = ProjectCompileMsg.tmsg("The conversation operation in node %0 cannot be invalid");
    private static final TMsg CONVERSATIONAL_REFERENCE_INVALID = ProjectCompileMsg.tmsg("The conversation reference in node %0 is invalid");
    private static final TMsg CONVERSATIONAL_REFERENCE_NULL = ProjectCompileMsg.tmsg("The conversation reference in node %0 cannot be null");
    private static final TMsg CONVERSATIONAL_INVALID_REPLY_TO = ProjectCompileMsg.tmsg("The node %0 replies to an invalid node");
    private static final TMsg CONVERSATIONAL_INVALID_CONVERSATION_TYPE = ProjectCompileMsg.tmsg("The node %0 has an invalid conversation type");
    private static final TMsg CONVERSATIONAL_PROCESS_NULL = ProjectCompileMsg.tmsg("The process in conversation of node %0 cannot be null");
    private static final TMsg CONVERSATIONAL_NULL_TARGET_CONVERSATIONAL = ProjectCompileMsg.tmsg("The target node in conversation of node %0 cannot be null");
    private static final TMsg CONVERSATIONAL_INVALID_TARGET_CONVERSATION = ProjectCompileMsg.tmsg("All nodes that participate in conversation of node %0 must call target nodes of the same conversation");
    private static final TMsg CONVERSATIONAL_INVALID_TARGET_CONVERSATIONAL = ProjectCompileMsg.tmsg("The target node in conversation of node %0 is invalid");
    private static final TMsg CONVERSATIONAL_INVALID_TWO_WAY_PROCESS_CALL = ProjectCompileMsg.tmsg("The selected target node in conversation of node %0 might not be valid. A target with a synchronous external interface or at least one replier must be selected. Use a Send Task instead.");
    private static final TMsg CONVERSATION_DUPLICATED_NAME = ProjectCompileMsg.tmsg("The conversation name in conversation %0 is already in use by another conversation in the process");
    private static final TMsg CONVERSATION_DUPLICATED_DEFAULT = ProjectCompileMsg.tmsg("The default conversation %0 is already defined in the process");
    private static final TMsg CONVERSATION_NOT_USED = ProjectCompileMsg.tmsg("The conversation %0 is not being used by any conversational node");
    private static final TMsg CONVERSATIONAL_INVOKE_MISSING = ProjectCompileMsg.tmsg("The node %0 defines a callback but the invoke operation is missing in the conversation");
    private static final TMsg CONVERSATION_SERVICE_INVALID = ProjectCompileMsg.tmsg("The service in conversation %0 is invalid");
    private static final TMsg CONVERSATION_SERVICE_NULL = ProjectCompileMsg.tmsg("The service in conversation %0 cannot be null");
    private static final TMsg CONVERSATION_REFERENCE_INVALID = ProjectCompileMsg.tmsg("The reference in conversation %0 is invalid");
    private static final TMsg CONVERSATION_REFERENCE_NULL = ProjectCompileMsg.tmsg("The reference in conversation %0 cannot be null");
    private static final TMsg CONVERSATION_PROCESS_NULL = ProjectCompileMsg.tmsg("The process in conversation %0 cannot be null");
    private static final TMsg CONVERSATION_PROCESS_INVALID = ProjectCompileMsg.tmsg("The process in conversation %0 is invalid");
    private static final TMsg BRACKETIZE = ProjectCompileMsg.tmsg("[%0]");
    private static final TMsg CONVERSATION_FULL_NAME = ProjectCompileMsg.tmsg("%0: %1");
    public static final Msg NOT_IMPLEMENTED = ProjectCompileMsg.msg("Not Implemented");

    public static Msg INVALID_TYPE_FOR_CASE_DATA(String type) {
        return INVALID_TYPE_FOR_CASE_DATA.args(type);
    }

    public static Msg INVALID_NAME_FOR_CASE_DATA(String type) {
        return INVALID_NAME_FOR_CASE_DATA.args(type);
    }

    public static Msg DUPLICATED_INPUT_DATA(String inputName, String caseActivity) {
        return DUPLICATED_INPUT_DATA.args(inputName, caseActivity);
    }

    public static Msg DUPLICATED_OUTPUT_DATA(String inputName, String caseActivity) {
        return DUPLICATED_OUTPUT_DATA.args(inputName, caseActivity);
    }

    public static Msg DUPLICATED_CASE_DATA(String name) {
        return DUPLICATED_CASE_DATA.args(name);
    }

    public static Msg DUPLICATED_CASE_EVENT(String name) {
        return DUPLICATED_CASE_EVENT.args(name);
    }

    public static Msg DUPLICATED_CASE_MILESTONE(String name) {
        return DUPLICATED_CASE_MILESTONE.args(name);
    }

    public static Msg DUPLICATED_STAKEHOLDER(String name) {
        return DUPLICATED_STAKEHOLDER.args(name);
    }

    public static Msg DUPLICATED_PERMISSION(String name) {
        return DUPLICATED_PERMISSION.args(name);
    }

    public static Msg STAKEHOLDER_VALUE_IS_EMPTY(String name) {
        return STAKEHOLDER_VALUE_IS_EMPTY.args(name);
    }

    public static Msg INVALID_PROCESS_ROLE_IN_STAKEHOLDER(String name, String role) {
        return INVALID_PROCESS_ROLE_IN_STAKEHOLDER.args(name, role);
    }

    public static Msg CASE_ACTIVITY_PERMISSION_NOT_AVAILABLE(String permission, String caseActivity) {
        return CASE_ACTIVITY_PERMISSION_NOT_AVAILABLE.args(permission, caseActivity);
    }

    public static Msg CASE_ACTIVITY_AUTOMATIC_WITH_PAYLOAD(String caseActivity) {
        return CASE_ACTIVITY_AUTOMATIC_WITH_PAYLOAD.args(caseActivity);
    }

    public static Msg CASE_ACTIVITY_INPUT_DATA_EMPTY_CASE_DATA(String inputName, String caseActivity) {
        return CASE_ACTIVITY_INPUT_DATA_EMPTY_CASE_DATA.args(inputName, caseActivity);
    }

    public static Msg CASE_ACTIVITY_INPUT_DATA_CASE_DATA_INVALID(String inputName, String caseActivity) {
        return CASE_ACTIVITY_INPUT_DATA_CASE_DATA_INVALID.args(inputName, caseActivity);
    }

    public static Msg CASE_ACTIVITY_OUTPUT_DATA_CASE_DATA_INVALID(String outName, String caseActivity) {
        return CASE_ACTIVITY_OUTPUT_DATA_CASE_DATA_INVALID.args(outName, caseActivity);
    }

    public static Msg CASE_ACTIVITY_INPUT_DATA_TYPE_NOT_MATCH(String inputName, String caseActivity) {
        return CASE_ACTIVITY_INPUT_DATA_TYPE_NOT_MATCH.args(inputName, caseActivity);
    }

    public static Msg CASE_ACTIVITY_OUTPUT_DATA_TYPE_NOT_MATCH(String inputName, String caseActivity) {
        return CASE_ACTIVITY_OUTPUT_DATA_TYPE_NOT_MATCH.args(inputName, caseActivity);
    }

    public static Msg CASE_ACTIVITY_INPUT_DATA_BPMN_NOT_MATCH(String caseActivity, String operation, String process) {
        return CASE_ACTIVITY_INPUT_DATA_BPMN_NOT_MATCH.args(caseActivity, operation, process);
    }

    public static Msg CASE_ACTIVITY_OUTPUT_DATA_BPMN_NOT_MATCH(String caseActivity, String operation, String process) {
        return CASE_ACTIVITY_OUTPUT_DATA_BPMN_NOT_MATCH.args(caseActivity, operation, process);
    }

    public static Msg CASE_ACTIVITY_INPUT_DATA_NAME_BPMN_NOT_MATCH(String name, String caseActivity, String operation, String process) {
        return CASE_ACTIVITY_INPUT_DATA_NAME_BPMN_NOT_MATCH.args(name, caseActivity, operation, process);
    }

    public static Msg CASE_ACTIVITY_OUTPUT_DATA_NAME_BPMN_NOT_MATCH(String name, String caseActivity, String operation, String process) {
        return CASE_ACTIVITY_OUTPUT_DATA_NAME_BPMN_NOT_MATCH.args(name, caseActivity, operation, process);
    }

    public static Msg CASE_ACTIVITY_INPUT_DATA_TASK_NOT_MATCH(String caseActivity, String task) {
        return CASE_ACTIVITY_INPUT_DATA_TASK_NOT_MATCH.args(caseActivity, task);
    }

    public static Msg CASE_ACTIVITY_OUTPUT_DATA_TASK_NOT_MATCH(String caseActivity, String task) {
        return CASE_ACTIVITY_OUTPUT_DATA_TASK_NOT_MATCH.args(caseActivity, task);
    }

    public static Msg CASE_ACTIVITY_INPUT_DATA_NAME_TASK_NOT_MATCH(String name, String caseActivity, String task) {
        return CASE_ACTIVITY_INPUT_DATA_NAME_TASK_NOT_MATCH.args(name, caseActivity, task);
    }

    public static Msg CASE_ACTIVITY_OUTPUT_DATA_NAME_TASK_NOT_MATCH(String name, String caseActivity, String task) {
        return CASE_ACTIVITY_OUTPUT_DATA_NAME_TASK_NOT_MATCH.args(name, caseActivity, task);
    }

    public static Msg CASE_ACTIVITY_OUTPUT_DATA_EMPTY_CASE_DATA(String inputName, String caseActivity) {
        return CASE_ACTIVITY_OUTPUT_DATA_EMPTY_CASE_DATA.args(inputName, caseActivity);
    }

    public static Msg PROCESS_HAS_MORE_THAN_ONE_INITIATE_TASK(String process, String firstUserTask, String secondUserTask) {
        return PROCESS_HAS_MORE_THAN_ONE_INITIATE_TASK.args(process, firstUserTask, secondUserTask);
    }

    public static Msg START_NONE_EVENT_IN_NON_CALLABLE(String process) {
        return START_NONE_EVENT_IN_NON_CALLABLE.args(process);
    }

    public static Msg ROUTE_BETWEEN_MESSAGE_START_AND_INITIATE_RECEIVE(String label, String label2) {
        return ROUTE_BETWEEN_MESSAGE_START_AND_INITIATE_RECEIVE.args(label, label2);
    }

    public static Msg INITIATE_RECEIVE_MUST_BE_THE_FIRST(String label) {
        return INITIATE_RECEIVE_MUST_BE_THE_FIRST.args(label);
    }

    public static Msg INITIATE_RECEIVE_MUST_USE_INBOUND_CONVERSATION(String label) {
        return INITIATE_RECEIVE_MUST_USE_INBOUND_CONVERSATION.args(label);
    }

    public static Msg NO_VALID_PATH_FOR_MEASUREMENTS(String defaultLabel, String defaultLabel1) {
        return NO_VALID_PATH_FOR_MEASUREMENTS.args(defaultLabel, defaultLabel1);
    }

    public static Msg MEASUREMENT_MARK_STOP_WITHOUT_START(String measurementMark) {
        return MEASUREMENT_MARK_STOP_WITHOUT_START.args(measurementMark);
    }

    public static Msg MEASUREMENT_MARK_START_WITHOUT_STOP(String measurementMark) {
        return MEASUREMENT_MARK_START_WITHOUT_STOP.args(measurementMark);
    }

    public static Msg FLOWNODE_HAS_NO_IMPLEMENTATION(String node) {
        return FLOWNODE_HAS_NO_IMPLEMENTATION.args(node);
    }

    public static Msg NO_ROLES_FOR_SIMULATION_RESOURCE(String simulationResourceId) {
        return NO_ROLES_FOR_SIMULATION_RESOURCE.args(simulationResourceId);
    }

    public static Msg SIMULATION_INVALID_RESOURCE_NAME(String id) {
        return SIMULATION_INVALID_RESOURCE_NAME.args(id);
    }

    public static Msg SIMULATION_RESOURCE_EFFICIENCY_VALUE_ERROR(String simulationResourceId) {
        return SIMULATION_RESOURCE_EFFICIENCY_VALUE_ERROR.args(simulationResourceId);
    }

    public static Msg SIMULATION_RESOURCE_AVAILABILITY_VALUE_ERROR(String simulationResourceId) {
        return SIMULATION_RESOURCE_AVAILABILITY_VALUE_ERROR.args(simulationResourceId);
    }

    public static Msg SIMULATION_CATEGORY_PROBABILITIES_VALUE_ERROR(String simulationResourceId) {
        return SIMULATION_CATEGORY_PROBABILITIES_VALUE_ERROR.args(simulationResourceId);
    }

    public static Msg PRJ_00046(String arg0, String arg1) {
        return PRJ_00046.args(arg0, arg1);
    }

    public static Msg PRJ_00048(String arg0, String arg1) {
        return PRJ_00048.args(arg0, arg1);
    }

    public static Msg PRJ_00049(String activity, String error) {
        return PRJ_00049.args(activity, error);
    }

    public static Msg MTM_02012(String arg0) {
        return MTM_02012.args(arg0);
    }

    public static Msg MTM_02044(String arg0, String arg1, String arg2, String arg3) {
        return MTM_02044.args(arg0, arg1, arg2, arg3);
    }

    public static Msg MOVED_FROM_TO(String from, String to) {
        return MOVED_FROM_TO.args(from, to);
    }

    public static Msg MTM_03008(String arg0) {
        return MTM_03008.args(arg0);
    }

    public static Msg MTM_02005(String arg0) {
        return MTM_02005.args(arg0);
    }

    public static Msg MTM_02024(String arg0) {
        return MTM_02024.args(arg0);
    }

    public static Msg MTM_02026(String arg0) {
        return MTM_02026.args(arg0);
    }

    public static Msg MTM_02027(String arg0) {
        return MTM_02027.args(arg0);
    }

    public static Msg MTM_02037(String arg0) {
        return MTM_02037.args(arg0);
    }

    public static Msg MTM_02054(String arg0) {
        return MTM_02054.args(arg0);
    }

    public static Msg MTM_02058(String arg0) {
        return MTM_02058.args(arg0);
    }

    public static Msg MTM_02061(String arg0) {
        return MTM_02061.args(arg0);
    }

    public static Msg MTM_02064(String arg0) {
        return MTM_02064.args(arg0);
    }

    public static Msg MTM_02065(String arg0) {
        return MTM_02065.args(arg0);
    }

    public static Msg MTM_02097(String arg0) {
        return MTM_02097.args(arg0);
    }

    public static Msg MTM_02112(String arg0, String arg1, String arg2) {
        return MTM_02112.args(arg0, arg1, arg2);
    }

    public static Msg MTM_02113(String arg0, String arg1, String arg2) {
        return MTM_02113.args(arg0, arg1, arg2);
    }

    public static Msg MTM_02121(String arg0, String arg1) {
        return MTM_02121.args(arg0, arg1);
    }

    public static Msg MTM_03002(String fileName) {
        return MTM_03002.args(fileName);
    }

    public static Msg MTM_03003(String fileName) {
        return MTM_03003.args(fileName);
    }

    public static Msg MTM_03006(String fileName) {
        return MTM_03006.args(fileName);
    }

    public static Msg PRJ_00001(String arg0) {
        return PRJ_00001.args(arg0);
    }

    public static Msg PRJ_00002(String arg0) {
        return PRJ_00002.args(arg0);
    }

    public static Msg PRJ_00003(String arg0) {
        return PRJ_00003.args(arg0);
    }

    public static Msg PRJ_00011(String gatewayType, String gatewayName) {
        return PRJ_00011.args(gatewayType, gatewayName);
    }

    public static Msg PRJ_00025(String arg0) {
        return PRJ_00025.args(arg0);
    }

    public static Msg PRJ_00058(String arg0) {
        return PRJ_00058.args(arg0);
    }

    public static Msg PRJ_00066(String measureName) {
        return PRJ_00066.args(measureName);
    }

    public static Msg PRJ_00080(String processName) {
        return PRJ_00080.args(processName);
    }

    public static Msg PRJ_00081(String processName) {
        return PRJ_00081.args(processName);
    }

    public static Msg PRJ_00082(String expressionName, String flowName) {
        return PRJ_00082.args(expressionName, flowName);
    }

    public static Msg EMPTY_EXPRESSION_IN_SEQUENCE_FLOW(String flowName) {
        return EMPTY_EXPRESSION_IN_SEQUENCE_FLOW.args(flowName);
    }

    public static Msg PRJ_00112(Lane lane) {
        return PRJ_00112.args(lane.getRole());
    }

    public static ErrorMsg CATALOG_OBJECT_INVALID_ATTRIBUTE(@NotNull String typeName, @NotNull String attributeName, @NotNull String elementDescription, @NotNull String name) {
        return CATALOG_OBJECT_INVALID_ATTRIBUTE.args(typeName, attributeName, elementDescription, name);
    }

    public static ErrorMsg CATALOG_OBJECT_INVALID_METHOD_PARAMETER(@NotNull String typeName, @NotNull String method, @NotNull String param, @NotNull String elementDescription, @NotNull String name) {
        return CATALOG_OBJECT_INVALID_METHOD_PARAMETER.args(typeName, param, method, elementDescription, name);
    }

    public static Msg INVALID_LOCATION(String id) {
        return INVALID_LOCATION.args(id);
    }

    public static Msg SPLIT_FLOW(String splitName) {
        return SPLIT_FLOW.args(splitName);
    }

    public static Msg DSG_01003(String arg0) {
        return DSG_01003.args(arg0);
    }

    public static Msg ERROR(String cause) {
        return ERROR.args(cause);
    }

    public static Msg COMPONENT_NOT_FOUND_IN_CATALOG(String component) {
        return COMPONENT_NOT_FOUND_IN_CATALOG.args(component);
    }

    public static Msg INVALID_CONDITIONAL_FLOW(String flowNode) {
        return INVALID_CONDITIONAL_FLOW.args(flowNode);
    }

    public static Msg EVENT_HAS_NO_SIGNAL_DEFINED(String eventName) {
        return EVENT_HAS_NO_SIGNAL_DEFINED.args(eventName);
    }

    public static Msg INITIATE_HAS_INVALID_PREDECESSORS(String defaultLabel, String predecessor) {
        return INITIATE_HAS_INVALID_PREDECESSORS.args(defaultLabel, predecessor);
    }

    public static Msg NO_BLOCKING_NODE_ALLOWED(String defaultLabel, String predecessor) {
        return NO_BLOCKING_NODE_ALLOWED.args(defaultLabel, predecessor);
    }

    public static Msg SERVICE_TASK_BEFORE_INITIATOR(String predecessor) {
        return SERVICE_TASK_BEFORE_INITIATOR.args(predecessor);
    }

    public static Msg INVALID_SEQUENCE_FLOW(String source, String target) {
        return INVALID_SEQUENCE_FLOW.args(source, target);
    }

    public static Msg MAIN_TO_BOUNDARY_SEQUENCE_FLOW(String sourceNode, String node) {
        return MAIN_TO_BOUNDARY_SEQUENCE_FLOW.args(sourceNode, node);
    }

    public static Msg BOUNDARY_TO_MAIN_SEQUENCE_FLOW(String sourceNode, String node) {
        return BOUNDARY_TO_MAIN_SEQUENCE_FLOW.args(sourceNode, node);
    }

    public static Msg ARGUMENT_INVALID_TYPE(String node, String argumentName) {
        return ARGUMENT_INVALID_TYPE.args(node, argumentName);
    }

    public static Msg ARGUMENT_MORE_THAN_ONE_FROM_WSDL(String node) {
        return ARGUMENT_MORE_THAN_ONE_FROM_WSDL.args(node);
    }

    public static Msg ARGUMENT_NON_ELEMENT_FROM_WSDL(String node, String argumentName) {
        return ARGUMENT_NON_ELEMENT_FROM_WSDL.args(node);
    }

    public static Msg CALL_ACTIVITY_HAS_NO_CALLABLE(String defaultLabel) {
        return CALL_ACTIVITY_HAS_NO_CALLABLE.args(defaultLabel);
    }

    public static Msg CALL_ACTIVITY_HAS_RELATED_NON_CALLABLE(String defaultLabel) {
        return CALL_ACTIVITY_HAS_RELATED_NON_CALLABLE.args(defaultLabel);
    }

    public static Msg CALLABLE_SUBPROCESS_NODE_CANNOT_CREATE_INSTANCE(String node) {
        return CALLABLE_SUBPROCESS_NODE_CANNOT_CREATE_INSTANCE.args(node);
    }

    public static Msg MULTIPLE_START_NOT_ALLOWED(String defaultLabel) {
        return MULTIPLE_START_NOT_ALLOWED.args(defaultLabel);
    }

    public static Msg CANNOT_EXIT_ABORT_PENDING_FLOWS(String defaultLabel) {
        return CANNOT_EXIT_ABORT_PENDING_FLOWS.args(defaultLabel);
    }

    public static Msg ERROR_NOT_DEFINED(String defaultLabel) {
        return ERROR_NOT_DEFINED.args(defaultLabel);
    }

    public static Msg BOUNDARY_ALREADY_HANDLED(String defaultLabel, String boundedTo, String label) {
        return BOUNDARY_ALREADY_HANDLED.args(label, defaultLabel, boundedTo);
    }

    public static Msg DATA_ASSOCIATION_TARGET_REF_NULL(String defaultLabel) {
        return DATA_ASSOCIATION_TARGET_REF_NULL.args(defaultLabel);
    }

    public static Msg INVALID_USER_TASK_REINITIATE_SOURCE(String userTaskName) {
        return INVALID_USER_TASK_REINITIATE_SOURCE.args(userTaskName);
    }

    public static Msg INVALID_USER_TASK_REINITIATE_INITIATOR(String userTaskName) {
        return INVALID_USER_TASK_REINITIATE_INITIATOR.args(userTaskName);
    }

    public static Msg INVALID_USER_TASK_DRAFT_INITIATOR(String userTaskName) {
        return INVALID_USER_TASK_DRAFT_INITIATOR.args(userTaskName);
    }

    public static Msg NON_INITIATOR_CORRELATION(String userTaskName) {
        return NON_INITIATOR_CORRELATION.args(userTaskName);
    }

    public static Msg INVALID_SEQUENCEFLOW_EXPRESSION(String fromNode, String toNode, String message) {
        return INVALID_SEQUENCEFLOW_EXPRESSION.args(fromNode, toNode, message);
    }

    public static Msg INVALID_FLOWNODE_EXPRESSION(String flowNode, String message) {
        return INVALID_FLOWNODE_EXPRESSION.args(flowNode, message);
    }

    public static Msg INVALID_ATTRIBUTE_EXPRESSION(String node, String attribute, String message) {
        return INVALID_ATTRIBUTE_EXPRESSION.args(node, attribute, message);
    }

    public static Msg EMPTY_ATTRIBUTE_EXPRESSION(String node, String attribute) {
        return EMPTY_ATTRIBUTE_EXPRESSION.args(node, attribute);
    }

    public static Msg BI_MUST_BE_MEASURE(String name) {
        return BI_MUST_BE_MEASURE.args(name);
    }

    public static Msg MESSAGE_ALREADY_HANDLED(String componentName, String operationName, String activityName) {
        return MESSAGE_ALREADY_HANDLED.args(componentName, operationName, activityName);
    }

    public static Msg BUSINESS_INDICATOR_NOT_A_COUNTER(String defaultLabel, String biLabel) {
        return BUSINESS_INDICATOR_NOT_A_COUNTER.args(defaultLabel, biLabel);
    }

    public static Msg DUPLICATE_DATAOBJECT_NAME(String name) {
        return DUPLICATE_DATAOBJECT_NAME.args(name);
    }

    public static Msg UNKNOWN_DATAOBJECT_TYPE(String name, String type) {
        return UNKNOWN_DATAOBJECT_TYPE.args(name, type);
    }

    public static Msg PROJECT_DATA_OBJECT_SHOULD_BE_PREDEFINED(String name, String type) {
        return PROJECT_DATA_OBJECT_SHOULD_BE_PREDEFINED.args(name, type);
    }

    public static Msg MORE_THAN_ONE_INTERRUPTING_TIMER(String node) {
        return MORE_THAN_ONE_INTERRUPTING_TIMER.args(node);
    }

    public static Msg SERVICE_PROPERTY_EXPRESSION_IS_INVALID(String node, String propertyName, String errorMessage) {
        return SERVICE_PROPERTY_EXPRESSION_IS_INVALID.args(node, propertyName, errorMessage);
    }

    public static Msg MESSAGE_HEADER_NAME_IS_INVALID(String node, String headerName) {
        return MESSAGE_HEADER_NAME_IS_INVALID.args(node, headerName);
    }

    public static Msg MESSAGE_HEADER_TYPE_IS_INVALID(String node, String headerName) {
        return MESSAGE_HEADER_TYPE_IS_INVALID.args(node, headerName);
    }

    public static Msg UNKNOWN_PROPERTY_IN_KEY(String property, String key, String container) {
        return UNKNOWN_PROPERTY_IN_KEY.args(property, key, container);
    }

    public static Msg CORRELATION_PROPERTY_ALIAS_NULL_EMPTY_EXP(String node, String property) {
        return CORRELATION_PROPERTY_ALIAS_NULL_EMPTY_EXP.args(node, property);
    }

    public static Msg CORRELATION_PROPERTY_ALIAS_INVALID_EXP(String node, String property, String message) {
        return CORRELATION_PROPERTY_ALIAS_INVALID_EXP.args(node, property, message);
    }

    public static Msg CORRELATION_INVALID_KEY(String node, String key) {
        return CORRELATION_INVALID_KEY.args(node, key);
    }

    public static Msg CORRELATION_INVALID_PROPERTY_IN_SELECTED_KEY(String node, String property) {
        return CORRELATION_INVALID_PROPERTY_IN_SELECTED_KEY.args(node, property);
    }

    public static Msg EMPTY_MAIL_RECIPIENT_NOTIFICATION(String node) {
        return EMPTY_MAIL_RECIPIENT_NOTIFICATION.args(node);
    }

    public static Msg NULL_TARGET_TASK_IN_UPDATE(String node) {
        return NULL_TARGET_TASK_IN_UPDATE.args(node);
    }

    public static Msg DATA_ASSOCIATION_EMPTY_SOURCE(String node) {
        return DATA_ASSOCIATION_EMPTY_SOURCE.args(node);
    }

    public static Msg DATA_ASSOCIATION_EMPTY_TARGET(String node) {
        return DATA_ASSOCIATION_EMPTY_TARGET.args(node);
    }

    public static Msg DATA_ASSOCIATION_UNCHECKED_TARGET(String node, String expression) {
        return DATA_ASSOCIATION_UNCHECKED_TARGET.args(node, expression);
    }

    public static Msg INVALID_LOG_HANDLER_TRIGGER(String node, String trigger) {
        return INVALID_LOG_HANDLER_TRIGGER.args(node, trigger);
    }

    public static Msg INVALID_LOG_HANDLER_EXPRESSION(String node, String trigger, String errorMessage) {
        return INVALID_LOG_HANDLER_EXPRESSION.args(node, trigger, errorMessage);
    }

    public static Msg UPDATE_TASK_WITH_NON_USER_TASK_IN_PROCESS(String node) {
        return UPDATE_TASK_WITH_NON_USER_TASK_IN_PROCESS.args(node);
    }

    public static Msg CONVERSATIONAL_DEFINED_OPERATION_NAME_NULL(String defaultLabel) {
        return CONVERSATIONAL_DEFINED_OPERATION_NAME_NULL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_DEFINED_OPERATION_NAME_DUPLICATED(String defaultLabel) {
        return CONVERSATIONAL_DEFINED_OPERATION_NAME_DUPLICATED.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_INVALID_REPLIER_ARGUMENTS(String defaultLabel) {
        return CONVERSATIONAL_INVALID_REPLIER_ARGUMENTS.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_MISSING_SYNC_VALID_PATH(String defaultLabel) {
        return CONVERSATIONAL_MISSING_SYNC_VALID_PATH.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_INVALID_ERROR(String defaultLabel) {
        return CONVERSATIONAL_INVALID_ERROR.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_SERVICE_INVALID(String defaultLabel) {
        return CONVERSATIONAL_SERVICE_INVALID.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_SERVICE_NULL(String defaultLabel) {
        return CONVERSATIONAL_SERVICE_NULL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_OPERATION_INVALID(String defaultLabel) {
        return CONVERSATIONAL_OPERATION_INVALID.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_OPERATION_NULL(String defaultLabel) {
        return CONVERSATIONAL_OPERATION_NULL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_REFERENCE_INVALID(String defaultLabel) {
        return CONVERSATIONAL_REFERENCE_INVALID.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_REFERENCE_NULL(String defaultLabel) {
        return CONVERSATIONAL_REFERENCE_NULL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_PROCESS_NULL(String defaultLabel) {
        return CONVERSATIONAL_PROCESS_NULL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_PROCESS_INVALID(String defaultLabel) {
        return CONVERSATIONAL_PROCESS_NULL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_INVALID_TARGET_CONVERSATION(String defaultLabel) {
        return CONVERSATIONAL_INVALID_TARGET_CONVERSATION.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_NULL_TARGET_CONVERSATIONAL(String defaultLabel) {
        return CONVERSATIONAL_NULL_TARGET_CONVERSATIONAL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_INVALID_TARGET_CONVERSATIONAL(String defaultLabel) {
        return CONVERSATIONAL_INVALID_TARGET_CONVERSATIONAL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_INVALID_TWO_WAY_PROCESS_CALL(String defaultLabel) {
        return CONVERSATIONAL_INVALID_TWO_WAY_PROCESS_CALL.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_INVALID_REPLY_TO(String defaultLabel) {
        return CONVERSATIONAL_INVALID_REPLY_TO.args(defaultLabel);
    }

    public static Msg CONVERSATIONAL_INVALID_CONVERSATION_TYPE(String defaultLabel) {
        return CONVERSATIONAL_INVALID_CONVERSATION_TYPE.args(defaultLabel);
    }

    public static Msg CONVERSATION_DUPLICATED_NAME(String conversationLabel) {
        return CONVERSATION_DUPLICATED_NAME.args(conversationLabel);
    }

    public static Msg CONVERSATION_DUPLICATED_DEFAULT(String conversationLabel) {
        return CONVERSATION_DUPLICATED_DEFAULT.args(conversationLabel);
    }

    public static Msg CONVERSATION_NOT_USED(String conversationLabel) {
        return CONVERSATION_NOT_USED.args(conversationLabel);
    }

    public static Msg CONVERSATIONAL_INVOKE_MISSING(String conversationLabel) {
        return CONVERSATIONAL_INVOKE_MISSING.args(conversationLabel);
    }

    public static Msg CONVERSATION_SERVICE_INVALID(String conversationLabel) {
        return CONVERSATION_SERVICE_INVALID.args(conversationLabel);
    }

    public static Msg CONVERSATION_SERVICE_NULL(String conversationLabel) {
        return CONVERSATION_SERVICE_NULL.args(conversationLabel);
    }

    public static Msg CONVERSATION_REFERENCE_INVALID(String conversationLabel) {
        return CONVERSATION_REFERENCE_INVALID.args(conversationLabel);
    }

    public static Msg CONVERSATION_REFERENCE_NULL(String conversationLabel) {
        return CONVERSATION_REFERENCE_NULL.args(conversationLabel);
    }

    public static Msg CONVERSATION_PROCESS_NULL(String conversationLabel) {
        return CONVERSATION_PROCESS_NULL.args(conversationLabel);
    }

    public static Msg CONVERSATION_PROCESS_INVALID(String conversationLabel) {
        return CONVERSATION_PROCESS_INVALID.args(conversationLabel);
    }

    public static Msg BRACKETIZE(Msg element) {
        return BRACKETIZE.args(element.getString());
    }

    public static Msg CONVERSATION_FULL_NAME(String conversationName, String implementation) {
        return CONVERSATION_FULL_NAME.args(conversationName, implementation);
    }

    static {
        ProjectCompileMsg.init(ProjectCompileMsg.class, LogComponent.DEFAULT, ErrorRange.PROJECT_COMPILER);
    }
}

