/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.exceptions;

import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.exception.ActivityException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;

public class DataAssociationException
extends ActivityException {
    private static final long serialVersionUID = 7932962666369765486L;

    private DataAssociationException(FlowNode node, Msg message) {
        super(node);
        this.setKey(message);
    }

    public static DataAssociationException createInvalidExpression(FlowNode node, String errorMessage) {
        return new DataAssociationException(node, ProjectCompileMsg.PRJ_00049(node.getDefaultLabel(), errorMessage));
    }

    public static DataAssociationException createNullTargetRef(FlowNode node) {
        return new DataAssociationException(node, ProjectCompileMsg.DATA_ASSOCIATION_TARGET_REF_NULL(node.getDefaultLabel()));
    }

    public static DataAssociationException createEmptySourceExpression(FlowNode node) {
        return new DataAssociationException(node, ProjectCompileMsg.DATA_ASSOCIATION_EMPTY_SOURCE(node.getDefaultLabel()));
    }

    public static DataAssociationException createEmptyTargetExpression(FlowNode node) {
        return new DataAssociationException(node, ProjectCompileMsg.DATA_ASSOCIATION_EMPTY_TARGET(node.getDefaultLabel()));
    }

    public static DataAssociationException createUncheckedTargetExpression(FlowNode node, String expression) {
        return new DataAssociationException(node, ProjectCompileMsg.DATA_ASSOCIATION_UNCHECKED_TARGET(node.getDefaultLabel(), expression));
    }
}

