/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.xpath.XPathGenerator;
import oracle.bpm.compiler.xpath.XPathGeneratorResult;
import oracle.bpm.compiler.xpath.XPathLiteralGenerator;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.log.Log;
import oracle.bpm.project.compile.ExpressionCompiler;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.XPathCompilerResult;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathCompiler
extends ExpressionCompiler {
    @NotNull
    private final DataDeclarationContainer context;
    @NotNull
    private final XPathGenerator generator;

    public XPathCompiler(@NotNull DataDeclarationContainer contextProvider) {
        this.context = contextProvider;
        ComponentCatalog catalog = contextProvider.getProject().getComponentCatalog();
        this.generator = new XPathGenerator(ExpressionCompiler.buildScope(contextProvider), catalog);
    }

    @NotNull
    public static String makeLiteral(String literal) {
        return XPathLiteralGenerator.makeLiteral((String)literal);
    }

    @NotNull
    public static XPathExpression makeXMLLiteral(String literal) {
        return new XPathLiteralGenerator(Collections.emptySet()).makeXMLLiteral(literal);
    }

    public void setCurrentNameSpaces(@Nullable Map<String, URI> nameSpaces) {
        this.generator.setCurrentNameSpaces(nameSpaces);
    }

    @NotNull
    public XPathCompilerResult generate(@NotNull String query, @NotNull ExpressionContext context) throws CilException {
        return this.generate(query, context.getResultType(), context.isLValue(), context.isIgnoreReadOnly());
    }

    @NotNull
    public XPathCompilerResult generate(@NotNull String query, @Nullable CatalogType targetType, boolean lvalue, boolean ignoreReadOnly) throws CilException {
        TypeDescription targetTD = targetType == null ? null : targetType.getDelegate();
        return this.buildResult(this.generator.generate(query, (TypeRef)targetTD, lvalue, ignoreReadOnly));
    }

    private List<DataDeclaration> asDataDeclarations(@Nullable List<AttributeTypeDescription> simpleReferences) {
        if (simpleReferences == null) {
            return null;
        }
        ArrayList<DataDeclaration> references = new ArrayList<DataDeclaration>(simpleReferences.size());
        DataDeclarationContainer currentContext = this.context;
        for (AttributeTypeDescription atd : simpleReferences) {
            String atdName = atd.getName();
            DataDeclaration declaration = currentContext.findDeclaration(atdName);
            if (declaration == null) {
                Log.logDebug("Could not find declaration=" + atdName);
                break;
            }
            references.add(declaration);
            currentContext = declaration;
        }
        return references;
    }

    @NotNull
    private XPathCompilerResult buildResult(@NotNull XPathGeneratorResult result) {
        List<DataDeclaration> references = this.asDataDeclarations(result.simpleReferences);
        return new XPathCompilerResult(result.expression, this.context.getProject().getCatalogType(result.returnType), references);
    }
}

