/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.compiler.xpath.XPathGeneratorUtils;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.compile.CatalogUtils;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public abstract class ExpressionCompiler {
    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull DataDeclarationContainer context) {
        Set<XPathVariable> scope = ExpressionCompiler.buildScope(context);
        ComponentCatalog catalog = context.getProject().getComponentCatalog();
        return XPathGeneratorUtils.buildMethod(scope, (ComponentCatalog)catalog);
    }

    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull ExpressionContext context) {
        DataDeclarationContainer declarations = context.getDeclarationsContainer();
        Set<XPathVariable> scope = ExpressionCompiler.buildScope(declarations);
        ComponentCatalog catalog = declarations.getProject().getComponentCatalog();
        CatalogType resultType = context.getResultType();
        boolean isLValue = context.isLValue();
        TypeRef typeRef = resultType == null ? null : resultType.getDynamicRef();
        return XPathGeneratorUtils.buildMethod(scope, (ComponentCatalog)catalog, (TypeRef)typeRef, (boolean)isLValue);
    }

    @NotNull
    public static Set<XPathVariable> buildScope(final @NotNull DataDeclarationContainer context) {
        return new AbstractSet<XPathVariable>(){

            @Override
            public Iterator<XPathVariable> iterator() {
                final Iterator<DataDeclaration> iterator = context.getDeclarations().iterator();
                return new Iterator<XPathVariable>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public XPathVariable next() {
                        return CatalogUtils.asXPathVariable((DataDeclaration)iterator.next(), context);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return CollectionUtils.size(context.getDeclarations());
            }
        };
    }

    @NotNull
    static Set<DataDeclaration> asDataDeclarations(@NotNull DataDeclarationContainer context, @NotNull Set<XPathVariable> expressionVariables) {
        LinkedHashSet<DataDeclaration> variables = new LinkedHashSet<DataDeclaration>(expressionVariables.size());
        for (XPathVariable variable : expressionVariables) {
            String varName = variable.getName();
            DataDeclaration declaration = context.findDeclaration(varName);
            if (declaration != null) {
                variables.add(declaration);
                continue;
            }
            assert (false) : "Unknown variable name \"" + varName + '\"';
        }
        return variables;
    }
}

