/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.builder;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.adapter.AdapterService;
import oracle.bpm.cil.CilException;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.ActivateEventMetadata;
import oracle.bpm.fusion.builder.FusionActivateEvent;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.compiler.ProjectCompilationListener;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.ide.Ide;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.ojc.interfaces.Storage;
import org.jetbrains.annotations.NotNull;

public class BuildProblems
implements ProjectCompilationListener {
    private final LinkedHashSet<ProjectException> errors = new LinkedHashSet();
    private final IdeLog.ActivateEvent event;
    private final LinkedHashSet<ProjectException> infos = new LinkedHashSet();
    private oracle.bpm.project.model.Project project;
    private final LinkedHashSet<ProjectException> warnings = new LinkedHashSet();
    private static final ProjectObjectType[] PREFERRED_LOCATIONS = new ProjectObjectType[]{ProjectObjectType.ACTIVITY, ProjectObjectType.TASK, ProjectObjectType.METHOD, ProjectObjectType.BPM_OBJECT_PRESENTATION};

    public BuildProblems(oracle.bpm.project.model.Project project) {
        this.project = project;
        this.event = this.createMessageActivateEvent();
    }

    public static Workspace getWorkspace(Project project) {
        Workspace result = null;
        Workspaces workspaces = Ide.getWorkspaces();
        for (Workspace workspace : workspaces.workspaces()) {
            if (!workspace.containsChild((Element)project)) continue;
            result = workspace;
            break;
        }
        return result;
    }

    public void onError(ProjectException exception) {
        this.errors.add(exception);
    }

    public void onWarning(ProjectException exception) {
        this.warnings.add(exception);
    }

    public void onInfo(ProjectException exception) {
        this.infos.add(exception);
    }

    public void onCheckFinished(ProjectObject projectObject) {
    }

    public void onCheckStarted(ProjectObject projectObject) {
    }

    public boolean onInterruptionCheck() {
        return false;
    }

    public Set<ProjectException> getErrors() {
        return this.errors;
    }

    public Set<ProjectException> getWarnings() {
        return this.warnings;
    }

    public void flushErrors() {
        LogPage log = JCompiler.getCompiler().getErrorLog();
        AdapterService service = Platform.getAdapterService();
        this.flushMessages(log, service, this.getErrors(), true);
        this.flushMessages(log, service, this.getWarnings(), false);
    }

    void flushAll() {
        for (ProjectException error : this.errors) {
            this.notifyError(error);
        }
        for (ProjectException warning : this.warnings) {
            this.notifyWarning(warning);
        }
        for (ProjectException info : this.infos) {
            this.notifyInfo(info);
        }
        this.errors.clear();
        this.warnings.clear();
        this.infos.clear();
    }

    void notifyError(ProjectException exception) {
        BuildProblems.addExceptionMark(exception, Severity.ERROR, this.project);
    }

    private static void addExceptionMark(ProjectException exception, Severity severity, oracle.bpm.project.model.Project project) {
        int line = -1;
        HashMap<ProjectObjectType, String> details = new HashMap<ProjectObjectType, String>();
        Throwable cause = exception.getCause();
        ProjectException source = exception;
        AdapterService adapterService = Platform.getAdapterService();
        ProjectObject projectObject = exception.getProjectObject();
        String projectObjectPart = exception.getProjectObjectPart();
        ProjectObjectNode resource = null;
        if (cause instanceof CilException) {
            TypeDescription description;
            CilException cilException = (CilException)cause;
            line = cilException.getLine();
            TypeDescription member = cilException.getMember();
            TypeDescription typeDescription = description = member != null ? member.getParent() : null;
            if (member != null) {
                source = cilException;
                if (member.isObject()) {
                    details.put(ProjectObjectType.COMPONENT, member.getName());
                }
                if (member.isMethod()) {
                    details.put(ProjectObjectType.METHOD, member.getName());
                    if (description != null) {
                        details.put(ProjectObjectType.COMPONENT, description.getName());
                    }
                }
                if (member.isAttribute()) {
                    details.put(ProjectObjectType.ATTRIBUTE, member.getName());
                    if (description != null) {
                        details.put(ProjectObjectType.COMPONENT, description.getName());
                    }
                }
                Map memberDetails = ProjectException.getDetails((TypeDescription)member);
                details.putAll(memberDetails);
                String part = ProjectException.getProjectObjectPart((TypeDescription)member);
                if (part != null) {
                    projectObjectPart = part;
                }
            }
            while (member != null && resource == null && !member.isSynthesized()) {
                resource = adapterService.adaptTo(member, ProjectObjectNode.class);
                member = member.getParent();
            }
        }
        if (resource == null) {
            for (ProjectObject current = projectObject; current != null && resource == null; current = current.getParentObject()) {
                resource = adapterService.adaptTo(current, ProjectObjectNode.class);
            }
        }
        details.putAll(exception.getDetails());
        if (resource == null) {
            System.err.println("Exception '" + exception.getClass().getName() + "' does not have a project object:");
            List<StackTraceElement> stack = Arrays.asList(exception.getStackTrace());
            String text = "\t" + stack.toString().replaceAll(",", "\n\t");
            System.err.println(text);
        }
        for (Map.Entry entry : details.entrySet()) {
        }
        StringBuilder location = new StringBuilder();
        for (ProjectObjectType type : PREFERRED_LOCATIONS) {
            String value = (String)details.get(type);
            if (value == null) continue;
            location.append(value);
            break;
        }
        if (location.length() == 0 && projectObject != null) {
            location.append(projectObject.getId());
        }
    }

    private static Node findNode(ProjectObject projectObject) {
        Node node = null;
        while (node == null && projectObject != null) {
            AdapterService service = Platform.getAdapterService();
            URL url = service.adaptTo(projectObject, URL.class);
            if (url != null) {
                try {
                    node = NodeFactory.findOrCreate((URL)url);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            projectObject = projectObject.getParentObject();
        }
        return node;
    }

    private void flushMessages(LogPage log, AdapterService service, Set<ProjectException> exceptions, boolean error) {
        for (ProjectException exception : exceptions) {
            ProjectObject projectObject = exception.getProjectObject();
            oracle.bpm.project.model.Project bpmProject = projectObject.getProject();
            Project jdevProject = service.adaptTo(bpmProject, Project.class);
            Node node = BuildProblems.findNode(projectObject);
            IdeStorage storage = new IdeStorage(node);
            int line = -1;
            int column = -1;
            int code = 0;
            IdeLog.Message message = new IdeLog.Message(BuildProblems.getWorkspace(jdevProject), jdevProject, (Storage)storage, exception.getMessage(), code, line, column, error ? 1 : 2);
            this.addActivateEvent(message, projectObject);
            log.log((Object)message);
        }
    }

    private void notifyWarning(ProjectException exception) {
        BuildProblems.addExceptionMark(exception, Severity.WARNING, this.project);
    }

    private void notifyInfo(ProjectException exception) {
        BuildProblems.addExceptionMark(exception, Severity.INFO, this.project);
    }

    private void addActivateEvent(@NotNull IdeLog.Message message, @NotNull ProjectObject object) {
        if (this.event != null) {
            message.userData = object;
            message.activateEvent = this.event;
        }
    }

    private IdeLog.ActivateEvent createMessageActivateEvent() {
        final FusionActivateEvent event = this.loadFusionActivateEvent();
        IdeLog.ActivateEvent result = event != null ? new IdeLog.ActivateEvent(){

            public void activate(IdeLog.Message message) {
                event.activate(message.userData, message.getMessage());
            }
        } : null;
        return result;
    }

    private FusionActivateEvent loadFusionActivateEvent() {
        FusionActivateEvent result = null;
        try {
            Extension<ActivateEventMetadata> extension;
            List<Extension<ActivateEventMetadata>> extensions = Platform.getExtensionService().getExtensionsByPoint(ActivateEventMetadata.class);
            Iterator<Extension<ActivateEventMetadata>> i$ = extensions.iterator();
            while (i$.hasNext() && (result = (extension = i$.next()).instantiateAs(FusionActivateEvent.class)) == null) {
            }
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return result;
    }

    static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

