/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemanagement.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.casemanagement.casedata.model.CaseData;
import oracle.bpm.casemanagement.caseheader.model.CaseHeader;
import oracle.bpm.casemanagement.impl.CaseManagementServiceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CaseManagementServiceWSIF {
    public Element insertCase(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        CaseHeader caseHeader = this.getCaseHeaderFromElement(param);
        CaseData caseData = this.getCaseDataFromElement(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseHeader result = cs.insertCase(caseHeader, caseData);
        return this.getElementFromCaseHeader(result);
    }

    public Element updateCase(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        CaseHeader caseHeader = this.getCaseHeaderFromElement(param);
        CaseData caseData = this.getCaseDataFromElement(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseHeader result = cs.updateCase(caseHeader, caseData);
        return this.getElementFromCaseHeader(result);
    }

    public void deleteCase(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        cs.deleteCase(caseId);
    }

    public Element queryCase(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String jpql = XMLUtil.getFirstChildElementValue((Element)param, (String)"jpql");
        Map<String, String> parametersMap = this.getParametersMap(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        List<CaseHeader> caseHeaderList = cs.queryCase(jpql, parametersMap);
        return this.createCaseHeaderList(caseHeaderList);
    }

    public Element queryCaseBasedonId(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseHeader result = cs.queryCaseBasedonId(caseId);
        return this.getElementFromCaseHeader(result);
    }

    public Element getCaseData(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        String name = this.getRootElement(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseData result = cs.getCaseData(caseId, name);
        return this.getElementFromCaseData(result);
    }

    public Element getAllCaseData(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseData result = cs.getAllCaseData(caseId);
        return this.getElementFromCaseData(result);
    }

    public Element insertCaseData(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        CaseData caseData = this.getCaseDataFromElement(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseData result = cs.insertCaseData(caseId, caseData);
        return this.getElementFromCaseData(result);
    }

    public Element updateCaseData(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        CaseData caseData = this.getCaseDataFromElement(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseData result = cs.updateCaseData(caseId, caseData);
        return this.getElementFromCaseData(result);
    }

    public void deleteAllCaseData(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        CaseData caseData = this.getCaseDataFromElement(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        cs.deleteAllCaseData(caseId, caseData);
    }

    public void deleteCaseData(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        String name = this.getRootElement(param);
        CaseData caseData = this.getCaseDataFromElement(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        cs.deleteCaseData(caseId, name);
    }

    public Element updateCaseState(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        String caseState = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseState");
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseHeader result = cs.updateCaseState(caseId, caseState);
        return this.getElementFromCaseHeader(result);
    }

    public void completeCase(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        cs.completeCase(caseId);
    }

    public Element updateCaseAttributes(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        return null;
    }

    public Element upsertCaseActivity(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        String caseId = this.getCaseId(param);
        String caseActivityType = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseActivityType");
        String caseActivityName = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseActivityName");
        String caseActivityId = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseActivityId");
        String caseActivityStatus = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseActivityStatus");
        String caseSubActivityType = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseSubActivityType");
        String caseSubActivityName = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseSubActivityName");
        String caseSubActivityId = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseSubActivityId");
        String caseSubActivityStatus = XMLUtil.getFirstChildElementValue((Element)param, (String)"caseSubActivityStatus");
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        CaseHeader result = cs.upsertCaseActivity(caseId, caseActivityId, caseActivityName, caseActivityType, caseActivityStatus, caseSubActivityId, caseSubActivityName, caseSubActivityType, caseSubActivityStatus);
        return this.getElementFromCaseHeader(result);
    }

    public void lockCase(Element param) throws Exception {
        param = XMLUtil.convertToXMLElement((Element)param);
        Element ctxElem = XMLUtil.getFirstChildElement((Element)param, (String)"bpmContext");
        IBPMContext bpmContext = (IBPMContext)VerificationService.createWorkflowContextFromWSRequest((Element)ctxElem);
        String caseId = this.getCaseId(param);
        CaseManagementServiceImpl cs = new CaseManagementServiceImpl();
        cs.lockCase(bpmContext, caseId);
    }

    private CaseHeader getCaseHeaderFromElement(Element param) throws JAXBException {
        NodeList nodeList = param.getElementsByTagName("caseHeader");
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element node = (Element)nodeList.item(0);
        JAXBContext context = JAXBContext.newInstance((String)"oracle.bpm.casemanagement.caseheader.model");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        CaseHeader caseHeader = (CaseHeader)unmarshaller.unmarshal((Node)node);
        return caseHeader;
    }

    private CaseData getCaseDataFromElement(Element param) throws JAXBException, Exception {
        NodeList nodeList = param.getElementsByTagName("caseData");
        Object node1 = null;
        if (nodeList.getLength() != 0) {
            Element node = (Element)nodeList.item(0);
            if (node == null) {
                return null;
            }
            JAXBContext context = JAXBContext.newInstance((String)"oracle.bpm.casemanagement.casedata.model");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            CaseData caseData = (CaseData)unmarshaller.unmarshal((Node)node);
            return caseData;
        }
        NodeList paramNodeList = param.getChildNodes();
        if (paramNodeList.getLength() != 0) {
            Element dataNode = (Element)paramNodeList.item(1);
            if (dataNode == null) {
                return null;
            }
            Document caseDoc = XMLUtil.createDocument();
            caseDoc.setDocumentURI("http://xmlns.oracle.com/CaseData");
            Element caseNode = caseDoc.createElementNS("http://xmlns.oracle.com/CaseData", "caseData");
            caseNode = XMLUtil.convertToXMLElement((Element)caseNode);
            Node newNode = XMLUtil.cloneNode((Document)caseDoc, (Node)dataNode);
            caseNode.appendChild(newNode);
            JAXBContext context = JAXBContext.newInstance((String)"oracle.bpm.casemanagement.casedata.model");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            CaseData caseData = (CaseData)unmarshaller.unmarshal((Node)caseNode);
            return caseData;
        }
        return null;
    }

    private Element getElementFromCaseHeader(CaseHeader result) throws Exception {
        JAXBContext context = JAXBContext.newInstance((String)"oracle.bpm.casemanagement.caseheader.model");
        Marshaller marshaller = context.createMarshaller();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        marshaller.marshal((Object)result, (Node)doc);
        return doc.getDocumentElement();
    }

    private String getCaseId(Element param) {
        return XMLUtil.getFirstChildElementValue((Element)param, (String)"caseId");
    }

    private String getRootElement(Element param) {
        return XMLUtil.getFirstChildElementValue((Element)param, (String)"rootElement");
    }

    private Element getElementFromCaseData(CaseData result) throws Exception {
        JAXBContext context = JAXBContext.newInstance((String)"oracle.bpm.casemanagement.casedata.model");
        Marshaller marshaller = context.createMarshaller();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        marshaller.marshal((Object)result, (Node)doc);
        return doc.getDocumentElement();
    }

    private Map<String, String> getParametersMap(Element param) {
        NodeList nodes = param.getElementsByTagName("parameterBinding");
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        if (nodes.getLength() == 0) {
            return Collections.emptyMap();
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            String key = XMLUtil.getFirstChildElementValue((Element)element, (String)"key");
            String value = XMLUtil.getFirstChildElementValue((Element)element, (String)"value");
            parametersMap.put(key, value);
        }
        return parametersMap;
    }

    private Element createCaseHeaderList(List<CaseHeader> caseHeaderList) throws Exception {
        Document document = XMLUtil.createDocument();
        Element parent = document.createElement("queryCaseResponse");
        for (CaseHeader caseHeader : caseHeaderList) {
            Element child = this.getElementFromCaseHeader(caseHeader);
            parent.appendChild(child);
        }
        return parent;
    }
}

