/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemanagement.impl;

import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.StaleObjectException;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.common.WorkflowServiceLocator;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.PredicateImpl;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.ITaskService;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.casemanagement.casedata.model.CaseData;
import oracle.bpm.casemanagement.casedata.model.ObjectFactory;
import oracle.bpm.casemanagement.caseheader.model.ActivitiesType;
import oracle.bpm.casemanagement.caseheader.model.ActivityType;
import oracle.bpm.casemanagement.caseheader.model.AssigneeType;
import oracle.bpm.casemanagement.caseheader.model.AssigneesType;
import oracle.bpm.casemanagement.caseheader.model.CaseAttributeType;
import oracle.bpm.casemanagement.caseheader.model.CaseAttributesType;
import oracle.bpm.casemanagement.caseheader.model.CaseHeader;
import oracle.bpm.casemanagement.metadata.impl.CaseMetadataServiceBean;
import oracle.bpm.casemanagement.metadata.impl.CaseMetadataUtil;
import oracle.bpm.casemanagement.metadata.model.CaseMetadata;
import oracle.bpm.casemanagement.persistence.model.Case;
import oracle.bpm.casemanagement.persistence.model.CaseActivity;
import oracle.bpm.casemanagement.persistence.model.CasePayload;
import oracle.bpm.casemanagement.persistence.model.CasePayloadPK;
import oracle.bpm.services.casemanagement.CaseManagementServiceException;
import oracle.bpm.services.casemanagement.ICaseManagementService;
import oracle.xml.parser.v2.XMLElement;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Repository
@Transactional
public class CaseManagementService
implements ICaseManagementService {
    private EntityManager entityManager;
    private ITaskQueryService taskQueryService;
    private ITaskService taskService;
    private static final String SYSTEMSTATUS_RUNNING = "RUNNING";
    private static final String SYSTEMSTATUS_COMPLETED = "COMPLETED";

    public static XMLGregorianCalendar getXMLGregorianCalendar(Calendar cal) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            if (cal instanceof GregorianCalendar) {
                return datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal);
            }
            return datatypeFactory.newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            return null;
        }
    }

    @PersistenceContext(unitName="CaseManagementPersistenceUnit")
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public CaseHeader insertCase(CaseHeader caseHeader, CaseData caseData) throws CaseManagementServiceException {
        Case persistenceCase = this.createCaseEntityFromJaxb(caseHeader, caseData, Util.getGuid());
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        persistenceCase.setCreatedDate(calendar);
        persistenceCase.setUpdatedDate(calendar);
        if (caseHeader.getSystemStatus() == null) {
            persistenceCase.setSystemStatus(SYSTEMSTATUS_RUNNING);
        }
        this.entityManager.persist((Object)persistenceCase);
        CaseHeader result = this.createCaseHeaderJaxbFromEntity(persistenceCase);
        return result;
    }

    public CaseHeader updateCase(CaseHeader caseHeader, CaseData caseData) throws CaseManagementServiceException {
        Case persistenceCase = this.createCaseEntityFromJaxb(caseHeader, caseData, null);
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        if (persistenceCase.getCreatedDate() == null) {
            persistenceCase.setCreatedDate(calendar);
        }
        persistenceCase.setUpdatedDate(calendar);
        persistenceCase.setSystemStatus(SYSTEMSTATUS_RUNNING);
        this.entityManager.merge((Object)persistenceCase);
        CaseHeader result = this.createCaseHeaderJaxbFromEntity(persistenceCase);
        return result;
    }

    public void deleteCase(String caseId) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        this.entityManager.remove((Object)persistenceCase);
    }

    public void completeCase(String caseId) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        persistenceCase.setSystemStatus(SYSTEMSTATUS_COMPLETED);
        this.entityManager.merge((Object)persistenceCase);
    }

    public List<CaseHeader> queryCase(String jpql, Map<String, String> parameterBinding) throws CaseManagementServiceException {
        Query query = this.entityManager.createQuery(jpql);
        String metadataId = this.getValidMetadataId();
        CaseMetadata caseMetadata = new CaseMetadataServiceBean().getCaseMetadata(metadataId);
        Map<String, String> labelCaseAttributeMapping = CaseMetadataUtil.getLabelCaseAttributeMapping(caseMetadata);
        for (Map.Entry<String, String> parameter : parameterBinding.entrySet()) {
            String value;
            String name = parameter.getKey();
            String attributeName = labelCaseAttributeMapping.get(name);
            if (attributeName == null) {
                value = parameter.getValue();
                query.setParameter(name, (Object)value);
                continue;
            }
            value = parameter.getValue();
            query.setParameter(attributeName, (Object)value);
        }
        ArrayList<CaseHeader> caseList = new ArrayList<CaseHeader>();
        List list = query.getResultList();
        for (Case caseHeader : list) {
            caseList.add(this.createCaseHeaderJaxbFromEntity(caseHeader));
        }
        return caseList;
    }

    public CaseHeader queryCaseBasedonId(String caseId) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        CaseHeader result = this.createCaseHeaderJaxbFromEntity(persistenceCase);
        return result;
    }

    public CaseData getAllCaseData(String caseId) throws CaseManagementServiceException {
        List casePayloadList = this.entityManager.createQuery("select p from CasePayload p where p.caseId = :caseId").setParameter("caseId", (Object)caseId).getResultList();
        return this.createCaseDataJaxbFromEntity(casePayloadList);
    }

    public CaseData insertCaseData(String caseId, CaseData caseData) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        List<CasePayload> casePayloadList = this.createCasePayloadList(persistenceCase, caseData);
        List<CasePayload> resultPayloadList = this.insertCasePayloadList(caseId, casePayloadList);
        return this.createCaseDataJaxbFromEntity(resultPayloadList);
    }

    public CaseData updateCaseData(String caseId, CaseData caseData) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        List<CasePayload> casePayloadList = this.createCasePayloadList(persistenceCase, caseData);
        List<CasePayload> resultPayloadList = this.updateCasePayloadList(caseId, casePayloadList);
        return this.createCaseDataJaxbFromEntity(resultPayloadList);
    }

    public void deleteAllCaseData(String caseId, CaseData caseData) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        List<CasePayload> casePayloadList = this.createCasePayloadList(persistenceCase, caseData);
        this.deleteCasePayloadList(casePayloadList);
    }

    public CaseHeader upsertCaseActivity(String caseId, String caseActivityId, String caseActivityName, String caseActivityType, String caseActivityStatus, String caseSubActivityId, String caseSubActivityName, String caseSubActivityType, String caseSubActivityStatus) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        if (persistenceCase == null) {
            return null;
        }
        if (caseActivityId == null || caseActivityType == null) {
            return null;
        }
        if (caseSubActivityId != null && caseSubActivityType != null) {
            CaseActivity caseActivity = (CaseActivity)this.entityManager.createNamedQuery("CaseActivity.findSubActivity").setParameter("caseActivityId", (Object)caseActivityId).setParameter("caseActivityType", (Object)caseActivityType).setParameter("caseId", (Object)caseId).setParameter("caseSubActivityId", (Object)caseSubActivityId).setParameter("caseSubActivityType", (Object)caseSubActivityType).getSingleResult();
            if (caseActivity != null) {
                if (caseActivityStatus != null) {
                    caseActivity.setCaseActivityStatus(caseActivityStatus);
                }
                if (caseSubActivityStatus != null) {
                    caseActivity.setCaseSubActivityStatus(caseSubActivityStatus);
                }
                if (caseActivityName != null) {
                    caseActivity.setCaseActivityName(caseActivityName);
                }
                if (caseSubActivityName != null) {
                    caseActivity.setCaseSubActivityName(caseSubActivityName);
                }
                this.entityManager.merge((Object)caseActivity);
            } else {
                CaseActivity newActivity = new CaseActivity();
                newActivity.setCase(persistenceCase);
                newActivity.setCaseActivityId(caseActivityId);
                newActivity.setCaseActivityName(caseActivityName);
                if (caseActivityStatus != null) {
                    newActivity.setCaseActivityStatus(caseActivityStatus);
                }
                newActivity.setCaseSubActivityType(caseSubActivityType);
                newActivity.setCaseSubActivityId(caseSubActivityId);
                newActivity.setCaseSubActivityName(caseSubActivityName);
                if (caseSubActivityStatus != null) {
                    newActivity.setCaseSubActivityStatus(caseSubActivityStatus);
                }
                newActivity.setCaseSubActivityType(caseSubActivityType);
                newActivity.setVersion(persistenceCase.getVersion());
                this.entityManager.persist((Object)newActivity);
                persistenceCase.getCaseActivity().add(newActivity);
            }
        } else if (caseSubActivityId == null && caseSubActivityType == null) {
            CaseActivity caseActivity = (CaseActivity)this.entityManager.createNamedQuery("CaseActivity.findActivity").setParameter("caseActivityId", (Object)caseActivityId).setParameter("caseActivityType", (Object)caseActivityType).setParameter("caseId", (Object)caseId).getSingleResult();
            if (caseActivity != null) {
                if (caseActivityStatus != null) {
                    caseActivity.setCaseActivityStatus(caseActivityStatus);
                }
                this.entityManager.merge((Object)caseActivity);
            } else {
                CaseActivity newActivity = new CaseActivity();
                newActivity.setCase(persistenceCase);
                newActivity.setCaseActivityId(caseActivityId);
                newActivity.setCaseActivityName(caseActivityName);
                if (caseActivityStatus != null) {
                    newActivity.setCaseActivityStatus(caseActivityStatus);
                }
                newActivity.setVersion(persistenceCase.getVersion());
                this.entityManager.persist((Object)newActivity);
                persistenceCase.getCaseActivity().add(newActivity);
            }
        }
        return this.createCaseHeaderJaxbFromEntity(persistenceCase);
    }

    public CaseHeader updateCaseState(String caseId, String caseState) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        persistenceCase.setCaseState(caseState);
        this.entityManager.merge((Object)persistenceCase);
        return this.createCaseHeaderJaxbFromEntity(persistenceCase);
    }

    public CaseHeader updateCaseAttributes(String caseId, Map<String, String> attributesMap) throws CaseManagementServiceException {
        Case persistenceCase = (Case)this.entityManager.find(Case.class, (Object)caseId);
        if (attributesMap == null || attributesMap.size() < 1) {
            return this.createCaseHeaderJaxbFromEntity(persistenceCase);
        }
        CaseMetadata caseMetadata = new CaseMetadataServiceBean().getCaseMetadata(persistenceCase.getCaseMetadataId());
        Map<String, String> labelCaseAttributeMapping = CaseMetadataUtil.getLabelCaseAttributeMapping(caseMetadata);
        for (String name : attributesMap.keySet()) {
            String value = attributesMap.get(name);
            if (name == null || name.trim().equals("")) continue;
            if (name != null && !name.trim().equals("")) {
                String positionString;
                if (name.contains("indexedFlexString")) {
                    positionString = name.replace("indexedFlexString", "");
                    int position = new Integer(positionString);
                    persistenceCase.setIndexedStringValue(value, position);
                    continue;
                }
                if (name.contains("StringAttribute")) {
                    positionString = name.replace("StringAttribute", "");
                    int position = new Integer(positionString);
                    persistenceCase.setStringValue(value, position);
                    continue;
                }
                if (name.contains("NumberAttribute")) {
                    positionString = name.replace("NumberAttribute", "");
                    int position = new Integer(positionString);
                    BigDecimal numberValue = new BigDecimal(value);
                    persistenceCase.setNumberValue(numberValue, position);
                    continue;
                }
                if (!name.contains("DateAttribute")) continue;
                positionString = name.replace("DateAttribute", "");
                int position = new Integer(positionString);
                Calendar calValue = this.convertStringToDate(value);
                persistenceCase.setDateValue(calValue, position);
                continue;
            }
            String attributeName = labelCaseAttributeMapping.get(name);
            if (attributeName == null || attributeName.trim().equals("")) continue;
            if (attributeName.contains("IndexedStringAttribute")) {
                String positionString = attributeName.replace("IndexedStringAttribute", "");
                int position = new Integer(positionString);
                persistenceCase.setIndexedStringValue(value, position);
                continue;
            }
            if (attributeName.contains("StringAttribute")) {
                String positionString = attributeName.replace("StringAttribute", "");
                int position = new Integer(positionString);
                persistenceCase.setStringValue(value, position);
                continue;
            }
            if (attributeName.contains("NumberAttribute")) {
                String positionString = attributeName.replace("NumberAttribute", "");
                int position = new Integer(positionString);
                BigDecimal numberValue = new BigDecimal(value);
                persistenceCase.setNumberValue(numberValue, position);
                continue;
            }
            if (!attributeName.contains("DateAttribute")) continue;
            String positionString = attributeName.replace("DateAttribute", "");
            int position = new Integer(positionString);
            Calendar calValue = this.convertStringToDate(value);
            persistenceCase.setDateValue(calValue, position);
        }
        return null;
    }

    public CaseData getCaseData(String caseId, String name) throws CaseManagementServiceException {
        CasePayload casePayload = (CasePayload)this.entityManager.createQuery("select p from CasePayload p where p.caseId = :caseId and p.name=:name").setParameter("caseId", (Object)caseId).setParameter("name", (Object)name).getSingleResult();
        ArrayList<CasePayload> casePayloadList = new ArrayList<CasePayload>();
        casePayloadList.add(casePayload);
        return this.createCaseDataJaxbFromEntity(casePayloadList);
    }

    public void deleteCaseData(String caseId, String name) throws CaseManagementServiceException {
        CasePayloadPK casePayloadPK = new CasePayloadPK(caseId, name);
        CasePayload casePayload = (CasePayload)this.entityManager.find(CasePayload.class, (Object)casePayloadPK);
        ArrayList<CasePayload> casePayloadList = new ArrayList<CasePayload>();
        casePayloadList.add(casePayload);
        this.deleteCasePayloadList(casePayloadList);
    }

    public void lockCase(IBPMContext bpmContext, String caseId) throws CaseManagementServiceException {
        System.out.println("Testing lock case");
        PredicateImpl predicate = null;
        List taskList = new ArrayList();
        int acquiredTasks = 0;
        try {
            predicate = new PredicateImpl(TableConstants.WFTASK_CASEID_COLUMN, 0, (Object)caseId);
            predicate.addClause(7, TableConstants.WFTASK_STATE_COLUMN, 0, (Object)"ASSIGNED");
            taskList = this.getTaskQueryService().queryTasks((IWorkflowContext)bpmContext, new ArrayList(), null, ITaskQueryService.AssignmentFilter.MY_AND_GROUP, null, (Predicate)predicate, null, 0, 0);
            if (taskList != null && !taskList.isEmpty()) {
                System.out.println("Task list size:" + taskList.size());
                for (Task task : taskList) {
                    try {
                        this.getTaskService().acquireTask((IWorkflowContext)bpmContext, task.getSystemAttributes().getTaskId());
                        ++acquiredTasks;
                    }
                    catch (StaleObjectException e) {
                        System.out.println("Stale Exception thrown during Acquire");
                        e.printStackTrace();
                    }
                    catch (WorkflowException e) {
                        System.out.println("WF Exception thrown during Acquire");
                        e.printStackTrace();
                    }
                }
            } else {
                System.out.println("No tasks retrieved for case id:" + caseId);
            }
        }
        catch (WorkflowException e) {
            System.out.println("WF Exception thrown during Acquire");
            e.printStackTrace();
        }
        System.out.println("Acquired " + acquiredTasks + " tasks");
    }

    public ITaskService getTaskService() {
        if (this.taskService != null) {
            System.out.println("Using Spring ref to taskQuerysvc");
            return this.taskService;
        }
        System.out.println("Spring ref to taskSvc doesnt work... Using WFlocator");
        this.taskService = WorkflowServiceLocator.getTaskService();
        return this.taskService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }

    public ITaskQueryService getTaskQueryService() {
        if (this.taskQueryService != null) {
            System.out.println("Using Spring ref to taskQuerysvc");
            return this.taskQueryService;
        }
        System.out.println("Spring ref to taskQuerysvc doesnt work... Using WFlocator");
        this.taskQueryService = WorkflowServiceLocator.getTaskQueryService();
        return this.taskQueryService;
    }

    public void setTaskQueryService(ITaskQueryService taskQueryService) {
        this.taskQueryService = taskQueryService;
    }

    private static IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private Case createCaseEntityFromJaxb(CaseHeader caseHeader, CaseData caseData, String guid) throws CaseManagementServiceException {
        ActivitiesType activities;
        List<CaseActivity> activityList;
        Case persistenceCase = new Case();
        persistenceCase.setCaseId(caseHeader.getCaseId());
        if (guid != null) {
            persistenceCase.setCaseId(guid);
        }
        persistenceCase.setCaseIdentificationKey(caseHeader.getCaseIdentificationKey());
        persistenceCase.setCaseMetadataId(caseHeader.getCaseMetadataId());
        persistenceCase.setSystemStatus(caseHeader.getSystemStatus());
        persistenceCase.setCaseActivityName(caseHeader.getCaseActivityName());
        persistenceCase.setCaseActivityId(caseHeader.getCaseActivityId());
        persistenceCase.setCaseActivityType(caseHeader.getCaseActivityType());
        persistenceCase.setVersion("1.0");
        persistenceCase.setCaseState(caseHeader.getCaseState());
        if (caseHeader.getCreatedDate() != null) {
            persistenceCase.setCreatedDate(caseHeader.getCreatedDate().toGregorianCalendar());
        }
        if (caseHeader.getUpdatedDate() != null) {
            persistenceCase.setUpdatedDate(caseHeader.getUpdatedDate().toGregorianCalendar());
        }
        if ((activityList = this.createCaseActivityEntityFromJaxb(persistenceCase, activities = caseHeader.getActivities())) != null) {
            persistenceCase.setCaseActivity(activityList);
        }
        CaseAttributesType caseAttributes = caseHeader.getCaseAttributes();
        this.setCaseAttributesValues(persistenceCase, caseAttributes);
        if (caseData != null && caseData.getAny() != null) {
            List<CasePayload> casePayloadList = this.createCasePayloadList(persistenceCase, caseData);
            persistenceCase.setCasePayload(casePayloadList);
        }
        return persistenceCase;
    }

    private List<CaseActivity> createCaseActivityEntityFromJaxb(Case persistenceCase, ActivitiesType activities) throws CaseManagementServiceException {
        if (activities == null) {
            return null;
        }
        List activityList = activities.getActivity();
        ArrayList<CaseActivity> caseActivityList = new ArrayList<CaseActivity>();
        if (activityList == null) {
            return null;
        }
        for (ActivityType activity : activityList) {
            CaseActivity caseActivity = new CaseActivity();
            caseActivity.setCaseActivityId(activity.getActivityId());
            caseActivity.setCaseActivityName(activity.getActivityName());
            caseActivity.setCaseActivityStatus(activity.getActivityStatus());
            caseActivity.setCaseActivityType(activity.getActivityType());
            caseActivity.setCaseSubActivityId(activity.getSubActivityId());
            caseActivity.setCaseSubActivityName(activity.getSubActivityName());
            caseActivity.setCaseSubActivityStatus(activity.getSubActivityStatus());
            caseActivity.setCaseSubActivityType(activity.getSubActivityType());
            caseActivity.setVersion("1.0");
            caseActivity.setGuid(Util.getGuid());
            caseActivity.setCase(persistenceCase);
            caseActivityList.add(caseActivity);
        }
        return caseActivityList;
    }

    private void setCaseAttributesValues(Case persistenceCase, CaseAttributesType caseAttributes) throws CaseManagementServiceException {
        if (caseAttributes == null) {
            return;
        }
        CaseMetadata caseMetadata = new CaseMetadataServiceBean().getCaseMetadata(persistenceCase.getCaseMetadataId());
        Map<String, String> labelCaseAttributeMapping = CaseMetadataUtil.getLabelCaseAttributeMapping(caseMetadata);
        List caseAttributeList = caseAttributes.getCaseAttribute();
        for (CaseAttributeType caseAttribute : caseAttributeList) {
            int position;
            String attributeName;
            String name = caseAttribute.getName();
            String label = caseAttribute.getLabel();
            if ((name == null || name.trim().equals("")) && (label == null || label.trim().equals(""))) continue;
            if (name != null && !name.trim().equals("")) {
                String positionString;
                if (name.contains("IndexedStringAttribute")) {
                    positionString = name.replace("IndexedStringAttribute", "");
                    int position2 = new Integer(positionString);
                    persistenceCase.setIndexedStringValue(caseAttribute.getStringValue(), position2);
                    continue;
                }
                if (name.contains("StringAttribute")) {
                    positionString = name.replace("StringAttribute", "");
                    int position3 = new Integer(positionString);
                    persistenceCase.setStringValue(caseAttribute.getStringValue(), position3);
                    continue;
                }
                if (name.contains("NumberAttribute")) {
                    positionString = name.replace("NumberAttribute", "");
                    int position4 = new Integer(positionString);
                    persistenceCase.setNumberValue(caseAttribute.getNumberValue(), position4);
                    continue;
                }
                if (name.contains("DateAttribute")) {
                    positionString = name.replace("DateAttribute", "");
                    int position5 = new Integer(positionString);
                    if (caseAttribute.getDateValue() == null) continue;
                    persistenceCase.setDateValue(caseAttribute.getDateValue().toGregorianCalendar(), position5);
                    continue;
                }
            }
            if (label == null || label.trim().equals("") || (attributeName = labelCaseAttributeMapping.get(label)) == null || attributeName.trim().equals("")) continue;
            if (attributeName.contains("IndexedStringAttribute")) {
                String positionString = attributeName.replace("IndexedStringAttribute", "");
                position = new Integer(positionString);
                persistenceCase.setIndexedStringValue(caseAttribute.getStringValue(), position);
                continue;
            }
            if (attributeName.contains("StringAttribute")) {
                String positionString = attributeName.replace("StringAttribute", "");
                position = new Integer(positionString);
                persistenceCase.setStringValue(caseAttribute.getStringValue(), position);
                continue;
            }
            if (attributeName.contains("NumberAttribute")) {
                String positionString = attributeName.replace("NumberAttribute", "");
                position = new Integer(positionString);
                persistenceCase.setNumberValue(caseAttribute.getNumberValue(), position);
                continue;
            }
            if (!attributeName.contains("DateAttribute")) continue;
            String positionString = attributeName.replace("DateAttribute", "");
            position = new Integer(positionString);
            if (caseAttribute.getDateValue() == null) continue;
            persistenceCase.setDateValue(caseAttribute.getDateValue().toGregorianCalendar(), position);
        }
    }

    private CaseHeader createCaseHeaderJaxbFromEntity(Case persistenceCase) {
        CaseHeader caseHeader = new CaseHeader();
        caseHeader.setCaseId(persistenceCase.getCaseId());
        caseHeader.setCaseIdentificationKey(persistenceCase.getCaseIdentificationKey());
        caseHeader.setCaseMetadataId(persistenceCase.getCaseMetadataId());
        caseHeader.setSystemStatus(persistenceCase.getSystemStatus());
        caseHeader.setCaseActivityName(persistenceCase.getCaseActivityName());
        caseHeader.setCaseActivityId(persistenceCase.getCaseActivityId());
        caseHeader.setCaseActivityType(persistenceCase.getCaseActivityType());
        caseHeader.setVersion(persistenceCase.getVersion());
        caseHeader.setCaseState(persistenceCase.getCaseState());
        caseHeader.setCreatedDate(CaseManagementService.getXMLGregorianCalendar(persistenceCase.getCreatedDate()));
        caseHeader.setUpdatedDate(CaseManagementService.getXMLGregorianCalendar(persistenceCase.getUpdatedDate()));
        List<CaseActivity> activities = persistenceCase.getCaseActivity();
        oracle.bpm.casemanagement.caseheader.model.ObjectFactory objFactory = new oracle.bpm.casemanagement.caseheader.model.ObjectFactory();
        ActivitiesType activitiesType = objFactory.createActivitiesType();
        for (CaseActivity caseActivity : activities) {
            ActivityType activity = objFactory.createActivityType();
            activity.setActivityId(caseActivity.getCaseActivityId());
            activity.setActivityName(caseActivity.getCaseActivityName());
            activity.setActivityType(caseActivity.getCaseActivityType());
            activity.setActivityStatus(caseActivity.getCaseActivityStatus());
            activity.setSubActivityId(caseActivity.getCaseSubActivityId());
            activity.setSubActivityName(caseActivity.getCaseSubActivityName());
            activity.setSubActivityType(caseActivity.getCaseSubActivityType());
            activity.setSubActivityStatus(caseActivity.getCaseSubActivityStatus());
            activitiesType.getActivity().add(activity);
        }
        CaseMetadata caseMetadata = new CaseMetadataServiceBean().getCaseMetadata(persistenceCase.getCaseMetadataId());
        Map<String, String> caseAttributeLabelMapping = CaseMetadataUtil.getCaseAttributeLabelMapping(caseMetadata);
        CaseAttributesType caseAttributes = objFactory.createCaseAttributesType();
        String[] attributeStringValues = persistenceCase.getStringValues();
        for (int i = 0; i < attributeStringValues.length; ++i) {
            CaseAttributeType caseAttribute = objFactory.createCaseAttributeType();
            int j = i + 1;
            caseAttribute.setName("StringAttribute" + j);
            caseAttribute.setStringValue(attributeStringValues[i]);
            if (caseAttributeLabelMapping.containsKey("StringAttribute" + j)) {
                String label = caseAttributeLabelMapping.get("StringAttribute" + j);
                caseAttribute.setLabel(label);
            }
            caseAttributes.getCaseAttribute().add(caseAttribute);
        }
        BigDecimal[] caseAttributeNumberValues = persistenceCase.getNumberValues();
        for (int i = 0; i < caseAttributeNumberValues.length; ++i) {
            CaseAttributeType caseAttribute = objFactory.createCaseAttributeType();
            int j = i + 1;
            caseAttribute.setName("NumberAttribute" + j);
            caseAttribute.setNumberValue(caseAttributeNumberValues[i]);
            if (caseAttributeLabelMapping.containsKey("NumberAttribute" + i)) {
                String label = caseAttributeLabelMapping.get("NumberAttribute" + i);
                caseAttribute.setLabel(label);
            }
            caseAttributes.getCaseAttribute().add(caseAttribute);
        }
        Calendar[] caseAttributeDateValues = persistenceCase.getDateValues();
        for (int i = 0; i < caseAttributeDateValues.length; ++i) {
            CaseAttributeType caseAttribute = objFactory.createCaseAttributeType();
            int j = i + 1;
            caseAttribute.setName("DateAttribute" + j);
            if (caseAttributeDateValues[i] != null) {
                caseAttribute.setDateValue(CaseManagementService.getXMLGregorianCalendar(caseAttributeDateValues[i]));
            }
            if (caseAttributeLabelMapping.containsKey("DateAttribute" + i)) {
                String label = caseAttributeLabelMapping.get("DateAttribute" + i);
                caseAttribute.setLabel(label);
            }
            caseAttributes.getCaseAttribute().add(caseAttribute);
        }
        String[] indexedCaseAttributeStringValues = persistenceCase.getIndexedStringValues();
        for (int i = 0; i < indexedCaseAttributeStringValues.length; ++i) {
            CaseAttributeType caseAttribute = objFactory.createCaseAttributeType();
            int j = i + 1;
            caseAttribute.setName("IndexedStringAttribute" + j);
            caseAttribute.setStringValue(indexedCaseAttributeStringValues[i]);
            if (caseAttributeLabelMapping.containsKey("IndexedStringAttribute" + i)) {
                String label = caseAttributeLabelMapping.get("IndexedStringAttribute" + i);
                caseAttribute.setLabel(label);
            }
            caseAttributes.getCaseAttribute().add(caseAttribute);
        }
        caseHeader.setCaseAttributes(caseAttributes);
        caseHeader.setAssignees(this.getCaseAssignees(caseHeader.getCaseId()));
        return caseHeader;
    }

    private AssigneesType getCaseAssignees(String caseId) {
        AssigneesType assignees = new AssigneesType();
        PredicateImpl predicate = null;
        List taskList = new ArrayList();
        try {
            predicate = new PredicateImpl(TableConstants.WFTASK_CASEID_COLUMN, 0, (Object)caseId);
            taskList = this.getTaskQueryService().queryTasks(CaseManagementService.getInternalWorkflowContext(), new ArrayList(), null, ITaskQueryService.AssignmentFilter.ALL, null, (Predicate)predicate, null, 0, 0);
            if (taskList != null && !taskList.isEmpty()) {
                System.out.println("Task list size:" + taskList.size());
                for (Task task : taskList) {
                    List identities = task.getSystemAttributes().getAssignees();
                    for (IdentityType identity : identities) {
                        AssigneeType assignee = new AssigneeType();
                        assignee.setAssigneeName(identity.getId());
                        assignee.setAssigneeType(identity.getType());
                        assignees.getAssignee().add(assignee);
                    }
                }
            }
        }
        catch (WorkflowException e) {
            System.out.println("Exception while querying task based on case id:" + caseId);
            e.printStackTrace();
        }
        return assignees;
    }

    private CaseData createCaseDataJaxbFromEntity(List<CasePayload> casePayloadList) throws CaseManagementServiceException {
        ObjectFactory objectFact = new ObjectFactory();
        CaseData caseData = objectFact.createCaseData();
        StringBuffer buffer = new StringBuffer();
        for (CasePayload payload : casePayloadList) {
            char[] any = payload.getData();
            buffer.append(any);
        }
        String anyObject = new String(buffer);
        try {
            Document document = XMLUtil.parseDocumentFromXMLString((String)anyObject);
            XMLElement element = (XMLElement)XMLUtil.convertToXMLElement((Element)document.getDocumentElement());
            caseData.setAny((Object)element);
        }
        catch (Exception e) {
            // empty catch block
        }
        return caseData;
    }

    private List<CasePayload> insertCasePayloadList(String caseId, List<CasePayload> casePayloadList) {
        for (CasePayload payload : casePayloadList) {
            this.entityManager.persist((Object)payload);
        }
        List result = this.entityManager.createQuery("select p from CasePayload p where p.caseId = :caseId").setParameter("caseId", (Object)caseId).getResultList();
        return result;
    }

    private List<CasePayload> updateCasePayloadList(String caseId, List<CasePayload> casePayloadList) {
        for (CasePayload payload : casePayloadList) {
            CasePayload returnedPayload = (CasePayload)this.entityManager.find(CasePayload.class, (Object)new CasePayloadPK(payload.getCaseId(), payload.getName()));
            if (returnedPayload == null) {
                this.entityManager.persist((Object)payload);
                continue;
            }
            this.entityManager.merge((Object)payload);
        }
        List result = this.entityManager.createQuery("select p from CasePayload p where p.caseId = :caseId").setParameter("caseId", (Object)caseId).getResultList();
        return result;
    }

    private void deleteCasePayloadList(List<CasePayload> casePayloadList) {
        for (CasePayload payload : casePayloadList) {
            CasePayload mergedPayload = (CasePayload)this.entityManager.find(CasePayload.class, (Object)new CasePayloadPK(payload.getCaseId(), payload.getName()));
            this.entityManager.remove((Object)mergedPayload);
        }
    }

    private List<CasePayload> createCasePayloadList(Case persistenceCase, CaseData caseData) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Element xmlData = (Element)caseData.getAny();
            char[] payload = XMLUtil.toString((Node)xmlData).toCharArray();
            ArrayList<CasePayload> payloadList = new ArrayList<CasePayload>();
            String name = xmlData.getLocalName();
            CasePayload casePayload = new CasePayload();
            casePayload.setData(payload);
            casePayload.setName(name);
            casePayload.setCase(persistenceCase);
            payloadList.add(casePayload);
            return payloadList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private Calendar convertStringToDate(String value) {
        Date d;
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.US);
        try {
            d = sdf.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    private String getValidMetadataId() {
        List caseList = this.entityManager.createNamedQuery("Case.findGlobalMetadataId").setFirstResult(0).setMaxResults(1).getResultList();
        return ((Case)caseList.get(0)).getCaseMetadataId();
    }
}

