/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.runtime.quartz.trigger;

import java.util.Date;
import oracle.bpm.runtime.quartz.trigger.ReschedulingPolicy;
import oracle.bpm.runtime.quartz.trigger.SchedulingLogger;
import oracle.bpm.runtime.quartz.trigger.TriggerWithReschedule;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class UniqueTriggerWithReschedule
extends TriggerWithReschedule {
    private ReschedulingPolicy reschedulingPolicy;

    @Override
    public Object clone() {
        UniqueTriggerWithReschedule copy = (UniqueTriggerWithReschedule)((Object)super.clone());
        copy.reschedulingPolicy = this.reschedulingPolicy;
        return copy;
    }

    @Override
    public void setReschedulingPolicy(ReschedulingPolicy reschedulingPolicy) {
        this.reschedulingPolicy = reschedulingPolicy;
    }

    @Override
    public ReschedulingPolicy getReschedulingPolicy() {
        return this.reschedulingPolicy;
    }

    @Override
    public Date getNextFireTime() {
        return this.getTrigger().getNextFireTime();
    }

    @Override
    public Date getPreviousFireTime() {
        return this.getTrigger().getPreviousFireTime();
    }

    public Date getStartTime() {
        return this.getTrigger().getStartTime();
    }

    public void setStartTime(Date startTime) {
        this.getTrigger().setStartTime(startTime);
    }

    public Date getEndTime() {
        return this.getTrigger().getEndTime();
    }

    public void setEndTime(Date endTime) {
        this.getTrigger().setEndTime(endTime);
    }

    public boolean mayFireAgain() {
        return this.getTrigger().mayFireAgain();
    }

    public int executionComplete(JobExecutionContext context, JobExecutionException result) {
        return this.getTrigger().executionComplete(context, result);
    }

    public void triggered(Calendar calendar) {
        Date nextFireTime = this.getNextFireTime();
        this.setPreviousFireTime(nextFireTime);
        nextFireTime = this.getFireTimeAfter(nextFireTime);
        nextFireTime = this.calculateNextFireTime(nextFireTime, calendar);
        this.setNextFireTime(nextFireTime);
        SchedulingLogger.log(new Date() + " method=triggered (next fire time=" + this.getNextFireTime() + ", previous fire time=" + this.getPreviousFireTime() + ")");
    }

    public Date computeFirstFireTime(Calendar calendar) {
        Date nextFireTime = new Date(this.getStartTime().getTime() - 1000L);
        nextFireTime = this.getFireTimeAfter(nextFireTime);
        nextFireTime = this.calculateNextFireTime(nextFireTime, calendar);
        this.setNextFireTime(nextFireTime);
        SchedulingLogger.log(new Date() + " method=computeFirstFireTime (next fire time=" + this.getNextFireTime() + ")");
        return nextFireTime;
    }

    public Date calculateNextFireTime(Date nextFireTime, Calendar calendar) {
        this.setPreRescheduleNextFireTime(nextFireTime);
        if (nextFireTime != null && calendar != null && !calendar.isTimeIncluded(nextFireTime.getTime())) {
            if (this.getReschedulingPolicy() == ReschedulingPolicy.NO_RESCHEDULE) {
                while ((nextFireTime = this.getFireTimeAfter(nextFireTime)) != null && !calendar.isTimeIncluded(nextFireTime.getTime())) {
                }
            } else if (this.getReschedulingPolicy() == ReschedulingPolicy.RESCHEDULE_AT_THE_SAME_HOUR) {
                DayCalculator dayCalculator = new DayCalculator(nextFireTime);
                while ((nextFireTime = dayCalculator.getNextDay()) != null && !calendar.isTimeIncluded(nextFireTime.getTime())) {
                }
            } else {
                nextFireTime = new Date(calendar.getNextIncludedTime(nextFireTime.getTime()));
            }
        }
        return nextFireTime;
    }

    private class DayCalculator {
        private int dayCount;
        private Date firstDay;
        private static final int MAX_DAYS_COUNT = 1000;

        public DayCalculator(Date firstDay) {
            this.firstDay = firstDay;
            this.dayCount = 0;
        }

        public Date getNextDay() {
            Date nextDay = new Date(this.getFirstDay().getTime() + (long)(this.getDayCount() * 24 * 60 * 60) * 1000L);
            if (this.getDayCount() < 1000) {
                this.setDayCount(this.getDayCount() + 1);
            } else {
                nextDay = null;
            }
            return nextDay;
        }

        private Date getFirstDay() {
            return this.firstDay;
        }

        private int getDayCount() {
            return this.dayCount;
        }

        private void setDayCount(int count) {
            this.dayCount = count;
        }
    }
}

