/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.runtime.quartz.trigger;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import oracle.bpm.runtime.quartz.trigger.ReschedulingPolicy;
import oracle.bpm.runtime.quartz.trigger.SchedulingLogger;
import oracle.bpm.runtime.quartz.trigger.TriggerWithReschedule;
import oracle.bpm.runtime.quartz.trigger.UniqueCronTriggerWithReschedule;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;

public class MultipleTriggerWithReschedule
extends TriggerWithReschedule {
    TriggerTimeLine triggerTimeLine;
    private static final long serialVersionUID = -6167503401310079846L;

    public MultipleTriggerWithReschedule(List<Trigger> triggerTimeLine) {
        this.triggerTimeLine = new TriggerTimeLine(triggerTimeLine);
    }

    @Override
    public Object clone() {
        MultipleTriggerWithReschedule copy = (MultipleTriggerWithReschedule)((Object)super.clone());
        copy.triggerTimeLine = (TriggerTimeLine)this.triggerTimeLine.clone();
        return copy;
    }

    public TriggerTimeLine getTriggerTimeLine() {
        return this.triggerTimeLine;
    }

    @Override
    public void setReschedulingPolicy(ReschedulingPolicy reschedulingPolicy) {
        this.getTriggerTimeLine().setReschedulingPolicy(reschedulingPolicy);
    }

    @Override
    public ReschedulingPolicy getReschedulingPolicy() {
        return this.getTriggerTimeLine().getReschedulingPolicy();
    }

    public void setStartTime(Date startTime) {
        this.getTriggerTimeLine().setStartTime(startTime);
    }

    public Date getStartTime() {
        return this.getTriggerTimeLine().getStartTime();
    }

    public void setEndTime(Date endTime) {
        this.getTriggerTimeLine().setEndTime(endTime);
    }

    public Date getEndTime() {
        return this.getTriggerTimeLine().getEndTime();
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    public int executionComplete(JobExecutionContext context, JobExecutionException result) {
        if (result != null && result.refireImmediately()) {
            return 1;
        }
        if (result != null && result.unscheduleFiringTrigger()) {
            return 2;
        }
        if (result != null && result.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public void triggered(Calendar calendar) {
        this.setPreviousFireTime(this.getNextFireTime());
        this.triggerTimeLine.callTriggered(calendar);
        this.setNextFireTime(this.triggerTimeLine.getFirstTrigger().getNextFireTime());
        SchedulingLogger.log(new Date() + " method=triggered (next fire time=" + this.getNextFireTime() + ", previous fire time=" + this.getPreviousFireTime() + ")");
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.triggerTimeLine.callComputeFirstFireTime(calendar);
        this.setNextFireTime(this.triggerTimeLine.getFirstTrigger().getNextFireTime());
        SchedulingLogger.log(new Date() + " method=computeFirstFireTime (next fire time=" + this.getNextFireTime() + ")");
        return this.getNextFireTime();
    }

    @Override
    public Trigger getTrigger() {
        return this.getTriggerTimeLine().getATrigger();
    }

    private static class TriggerTimeLine
    implements Serializable,
    Cloneable {
        Trigger firstOfRemainingTriggers;
        Trigger firstTrigger;
        List<Trigger> remainingTriggers;
        ReschedulingPolicy reschedulingPolicy;
        private static final long THRESHOLD = 20L;
        private static final long serialVersionUID = -6167503401388079846L;

        TriggerTimeLine(List<Trigger> remainingTriggers) {
            this.remainingTriggers = remainingTriggers;
        }

        public Object clone() {
            TriggerTimeLine copy;
            try {
                copy = (TriggerTimeLine)super.clone();
                copy.firstTrigger = (Trigger)this.firstTrigger.clone();
                copy.firstOfRemainingTriggers = (Trigger)this.firstOfRemainingTriggers.clone();
                copy.remainingTriggers = new LinkedList<Trigger>();
                for (Trigger trigger : this.remainingTriggers) {
                    copy.remainingTriggers.add((Trigger)trigger.clone());
                }
                copy.reschedulingPolicy = this.reschedulingPolicy;
            }
            catch (CloneNotSupportedException e) {
                throw new IncompatibleClassChangeError("Not Cloneable.");
            }
            return copy;
        }

        public ReschedulingPolicy getReschedulingPolicy() {
            return this.reschedulingPolicy;
        }

        public void setReschedulingPolicy(ReschedulingPolicy reschedulingPolicy) {
            this.reschedulingPolicy = reschedulingPolicy;
        }

        public Date getStartTime() {
            return this.remainingTriggers.get(0).getStartTime();
        }

        public void setStartTime(Date startTime) {
            for (Trigger aRemainingTrigger : this.remainingTriggers) {
                aRemainingTrigger.setStartTime(startTime);
            }
        }

        public Date getEndTime() {
            return this.remainingTriggers.get(0).getEndTime();
        }

        public void setEndTime(Date endTime) {
            for (Trigger aRemainingTrigger : this.remainingTriggers) {
                aRemainingTrigger.setEndTime(endTime);
            }
        }

        public Trigger getATrigger() {
            return this.remainingTriggers.get(0);
        }

        public Trigger getFirstTrigger() {
            return this.firstTrigger;
        }

        public void callTriggered(Calendar calendar) {
            this.computeFirstTrigger(calendar);
        }

        public void callComputeFirstFireTime(Calendar calendar) {
            for (Trigger trigger : this.remainingTriggers) {
                trigger.computeFirstFireTime(null);
            }
            this.computeFirstTrigger(calendar);
        }

        private Trigger getFirstOfRemainingTriggers() {
            return this.firstOfRemainingTriggers;
        }

        private void computeFirstOfRemainingTriggers() {
            boolean firstOfRemainingTriggersWasComputed = false;
            for (Trigger aRemainingTrigger : this.remainingTriggers) {
                if (firstOfRemainingTriggersWasComputed && this.firstOfRemainingTriggers.getNextFireTime() != null && (aRemainingTrigger.getNextFireTime() == null || !this.firstOfRemainingTriggers.getNextFireTime().after(aRemainingTrigger.getNextFireTime()))) continue;
                this.firstOfRemainingTriggers = aRemainingTrigger;
                firstOfRemainingTriggersWasComputed = true;
            }
        }

        private void computeFirstTrigger(Calendar calendar) {
            boolean firstTriggerWasComputed = false;
            while (!firstTriggerWasComputed) {
                this.computeFirstOfRemainingTriggers();
                if (this.getFirstOfRemainingTriggers().getNextFireTime() != null) {
                    if (calendar.isTimeIncluded(this.getFirstOfRemainingTriggers().getNextFireTime().getTime())) {
                        this.firstTrigger = (Trigger)this.getFirstOfRemainingTriggers().clone();
                        firstTriggerWasComputed = true;
                        this.getFirstOfRemainingTriggers().triggered(null);
                        continue;
                    }
                    UniqueCronTriggerWithReschedule uniqueCronTriggerWithReschedule = new UniqueCronTriggerWithReschedule((CronTrigger)this.getFirstOfRemainingTriggers().clone());
                    uniqueCronTriggerWithReschedule.setReschedulingPolicy(this.reschedulingPolicy);
                    uniqueCronTriggerWithReschedule.computeFirstFireTime(calendar);
                    this.getFirstOfRemainingTriggers().triggered(null);
                    this.computeFirstOfRemainingTriggers();
                    if (this.getFirstOfRemainingTriggers().getNextFireTime() != null && !this.isNotFarEnough(uniqueCronTriggerWithReschedule, this.getFirstOfRemainingTriggers())) continue;
                    this.firstTrigger = uniqueCronTriggerWithReschedule;
                    firstTriggerWasComputed = true;
                    continue;
                }
                this.firstTrigger = (Trigger)this.getFirstOfRemainingTriggers().clone();
                firstTriggerWasComputed = true;
            }
        }

        private boolean isNotFarEnough(UniqueCronTriggerWithReschedule rescheduledTrigger, Trigger nextTrigger) {
            long nextTriggerTime;
            boolean isNotFarEnough = false;
            long rescheduledTriggerTime = rescheduledTrigger.getNextFireTime().getTime();
            if (rescheduledTriggerTime < (nextTriggerTime = nextTrigger.getNextFireTime().getTime())) {
                long preRescheduledTriggerTime = rescheduledTrigger.getPreRescheduleNextFireTime().getTime();
                isNotFarEnough = nextTriggerTime - rescheduledTriggerTime >= (nextTriggerTime - preRescheduledTriggerTime) * 20L / 100L;
            }
            return isNotFarEnough;
        }
    }
}

