/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.runtime.classloader.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ContextClassloaderProxy
implements Serializable {
    private byte[] binaryObject;
    private transient Object object;
    static final long serialVersionUID = 123456788L;

    public ContextClassloaderProxy(Object object) {
        this.object = object;
    }

    public static <T> T createProxy(Class<T> iface, T object) {
        ContextClassloaderProxy proxy = new ContextClassloaderProxy(object);
        return iface.cast(Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ProxyInvocationHandler(proxy)));
    }

    public String toString() {
        return "Proxy{object=" + this.object + '}';
    }

    protected Object getObject() {
        return this.object;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.object = new ContextClassloaderObjectInputStream(new ByteArrayInputStream(this.binaryObject)).readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutputStream);
        oos.writeObject(this.object);
        oos.close();
        this.binaryObject = byteArrayOutputStream.toByteArray();
        objectOutputStream.defaultWriteObject();
    }

    private static class ContextClassloaderObjectInputStream
    extends ObjectInputStream {
        private ContextClassloaderObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, Thread.currentThread().getContextClassLoader());
        }
    }

    public static class ProxyInvocationHandler
    implements InvocationHandler,
    Serializable {
        private ContextClassloaderProxy proxy;
        static final long serialVersionUID = 123456789L;

        public ProxyInvocationHandler(ContextClassloaderProxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.proxy.getObject(), args);
        }
    }
}

