/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser.preprocessor;

import fuego.parser.collections.impl.Vector;
import fuego.parser.preprocessor.GrammarFile;
import fuego.parser.preprocessor.Hierarchy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public class Tool {
    protected fuego.parser.Tool antlrTool;
    protected String[] args;
    protected String grammarFileName;
    protected Vector<String> grammars;
    protected int nargs;
    protected Hierarchy theHierarchy;

    public Tool(fuego.parser.Tool t, String[] args) {
        this.antlrTool = t;
        this.processArguments(args);
    }

    public static void main(String[] args) {
        fuego.parser.Tool antlrTool = new fuego.parser.Tool();
        Tool theTool = new Tool(antlrTool, args);
        theTool.preprocess();
        for (String arg : theTool.preprocessedArgList()) {
            System.out.print(' ' + arg);
        }
        System.out.println();
    }

    public boolean preprocess() {
        boolean complete;
        if (this.grammarFileName == null) {
            this.antlrTool.toolError("no grammar file specified");
            return false;
        }
        if (this.grammars != null) {
            this.theHierarchy = new Hierarchy(this.antlrTool);
            for (String f : this.grammars) {
                try {
                    this.theHierarchy.readGrammarFile(f);
                }
                catch (FileNotFoundException fe) {
                    this.antlrTool.toolError("file " + f + " not found");
                    return false;
                }
            }
        }
        if (!(complete = this.theHierarchy.verifyThatHierarchyIsComplete())) {
            return false;
        }
        this.theHierarchy.expandGrammarsInFile(this.grammarFileName);
        GrammarFile gf = this.theHierarchy.getFile(this.grammarFileName);
        String expandedFileName = gf.nameForExpandedGrammarFile(this.grammarFileName);
        if (expandedFileName.equals(this.grammarFileName)) {
            this.args[this.nargs++] = this.grammarFileName;
        } else {
            try {
                gf.generateExpandedFile();
                this.args[this.nargs++] = this.antlrTool.getOutputDirectory() + System.getProperty("file.separator") + expandedFileName;
            }
            catch (IOException io) {
                this.antlrTool.toolError("cannot write expanded grammar file " + expandedFileName);
                this.antlrTool.toolError(io.getMessage());
                return false;
            }
        }
        return true;
    }

    public String[] preprocessedArgList() {
        this.args = Arrays.copyOf(this.args, this.nargs);
        return this.args;
    }

    private void processArguments(String[] incomingArgs) {
        this.nargs = 0;
        this.args = new String[incomingArgs.length];
        for (int i = 0; i < incomingArgs.length; ++i) {
            if ("-glib".equals(incomingArgs[i])) {
                if ("\\".equals(File.separator) && incomingArgs[i].indexOf(47) != -1) {
                    this.antlrTool.warning("-glib cannot deal with '/' on a PC: use '\\'; ignoring...");
                    continue;
                }
                this.grammars = fuego.parser.Tool.parseSeparatedList(incomingArgs[i + 1], ';');
                ++i;
                continue;
            }
            if ("-o".equals(incomingArgs[i])) {
                this.args[this.nargs++] = incomingArgs[i];
                if (i + 1 >= incomingArgs.length) {
                    this.antlrTool.error("missing output directory with -o option; ignoring");
                    continue;
                }
                this.args[this.nargs++] = incomingArgs[++i];
                this.antlrTool.setOutputDirectory(incomingArgs[i]);
                continue;
            }
            if (incomingArgs[i].charAt(0) == '-') {
                this.args[this.nargs++] = incomingArgs[i];
                continue;
            }
            this.grammarFileName = incomingArgs[i];
            if (this.grammars == null) {
                this.grammars = new Vector(10);
            }
            this.grammars.appendElement(this.grammarFileName);
            if (i + 1 >= incomingArgs.length) continue;
            this.antlrTool.warning("grammar file must be last; ignoring other arguments...");
            break;
        }
    }
}

