/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import fuego.parser.Tool;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ParserTool
extends Tool {
    private static final String BASE_GRAMMAR_OPTION = "-glib";

    public static void main(String[] args) {
        if (args.length < 3 || BASE_GRAMMAR_OPTION.equals(args[2]) && args.length < 5) {
            System.err.println("Usage: sourceDir outputDir [-b base-grammar] grammar-files");
        }
        version = "2.7.2a6 (20021130-1)";
        try {
            new ParserTool().run(args);
        }
        catch (FatalException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String changeExt(@NotNull String fileName, @NotNull String ext) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/parser/ParserTool.changeExt must not be null");
        }
        if (ext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of fuego/parser/ParserTool.changeExt must not be null");
        }
        int dot = fileName.lastIndexOf(46);
        String baseName = dot == -1 ? fileName : fileName.substring(0, dot);
        return baseName + (ext.charAt(0) == '.' ? ext : '.' + ext);
    }

    @Override
    public void fatalError(String message) {
        System.err.println(message);
        throw new FatalException();
    }

    private void run(String[] arguments) {
        int i;
        String out = arguments[0];
        String src = arguments[1];
        boolean hasBaseGrammar = BASE_GRAMMAR_OPTION.equals(arguments[2]);
        String baseGrammar = hasBaseGrammar ? arguments[3] : "";
        int n = i = hasBaseGrammar ? 4 : 2;
        while (i < arguments.length) {
            String g = arguments[i];
            File grammar = new File(src, g);
            File java = new File(out, ParserTool.changeExt(g, ".java"));
            if (grammar.lastModified() > java.lastModified()) {
                System.out.println("Processing Grammar = " + g);
                this.processGrammar(grammar, new File(g).getParent(), out, src, hasBaseGrammar, baseGrammar);
            }
            ++i;
        }
    }

    private void processGrammar(File grammar, String pkg, String out, String src, boolean hasBaseGrammar, String baseGrammar) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-o");
        args.add(new File(out, pkg).getPath());
        if (hasBaseGrammar) {
            args.add(BASE_GRAMMAR_OPTION);
            args.add(new File(src, baseGrammar).getPath());
        }
        args.add(grammar.getPath());
        this.doEverything(args);
    }

    static class FatalException
    extends RuntimeException {
        private static final long serialVersionUID = -5927467747261044419L;

        FatalException() {
        }
    }
}

