/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import fuego.parser.ASTFactory;
import fuego.parser.MismatchedTokenException;
import fuego.parser.NoViableAltException;
import fuego.parser.ParserSharedInputState;
import fuego.parser.RecognitionException;
import fuego.parser.Token;
import fuego.parser.TokenBuffer;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import fuego.parser.collections.AST;
import fuego.parser.collections.impl.BitSet;
import fuego.parser.debug.MessageListener;
import fuego.parser.debug.ParserListener;
import fuego.parser.debug.ParserMatchListener;
import fuego.parser.debug.ParserTokenListener;
import fuego.parser.debug.SemanticPredicateListener;
import fuego.parser.debug.SyntacticPredicateListener;
import fuego.parser.debug.TraceListener;

public abstract class Parser {
    protected ASTFactory astFactory = new ASTFactory();
    protected ParserSharedInputState inputState;
    protected AST returnAST;
    protected String[] tokenNames;
    protected int traceDepth = 0;
    private boolean ignoreInvalidDebugCalls = false;

    public Parser() {
        this.inputState = new ParserSharedInputState();
    }

    public Parser(ParserSharedInputState state) {
        this.inputState = state;
    }

    public abstract int LA(int var1) throws TokenStreamException;

    public abstract Token LT(int var1) throws TokenStreamException;

    public abstract void consume() throws TokenStreamException;

    public void setASTFactory(ASTFactory f) {
        this.astFactory = f;
    }

    public ASTFactory getASTFactory() {
        return this.astFactory;
    }

    public void setASTNodeClass(String cl) {
        this.astFactory.setASTNodeType(cl);
    }

    public void setDebugMode(boolean debugMode) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new RuntimeException("setDebugMode() only valid if parser built for debugging");
        }
    }

    public boolean isDebugMode() {
        return false;
    }

    public void setFilename(String f) {
        this.inputState.filename = f;
    }

    public String getFilename() {
        return this.inputState.filename;
    }

    public void setIgnoreInvalidDebugCalls(boolean value) {
        this.ignoreInvalidDebugCalls = value;
    }

    public void setInputState(ParserSharedInputState state) {
        this.inputState = state;
    }

    public ParserSharedInputState getInputState() {
        return this.inputState;
    }

    public void setTokenBuffer(TokenBuffer t) {
        this.inputState.input = t;
    }

    public String getTokenName(int num) {
        return this.tokenNames[num];
    }

    public String[] getTokenNames() {
        return this.tokenNames;
    }

    public void addMessageListener(MessageListener l) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new IllegalArgumentException("addMessageListener() is only valid if parser built for debugging");
        }
    }

    public void addParserListener(ParserListener l) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new IllegalArgumentException("addParserListener() is only valid if parser built for debugging");
        }
    }

    public void addParserMatchListener(ParserMatchListener l) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new IllegalArgumentException("addParserMatchListener() is only valid if parser built for debugging");
        }
    }

    public void addParserTokenListener(ParserTokenListener l) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new IllegalArgumentException("addParserTokenListener() is only valid if parser built for debugging");
        }
    }

    public void addSemanticPredicateListener(SemanticPredicateListener l) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new IllegalArgumentException("addSemanticPredicateListener() is only valid if parser built for debugging");
        }
    }

    public void addSyntacticPredicateListener(SyntacticPredicateListener l) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new IllegalArgumentException("addSyntacticPredicateListener() is only valid if parser built for debugging");
        }
    }

    public void addTraceListener(TraceListener l) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new IllegalArgumentException("addTraceListener() is only valid if parser built for debugging");
        }
    }

    public AST getAST() {
        return this.returnAST;
    }

    public void consumeUntil(int tokenType) throws TokenStreamException {
        while (this.LA(1) != 1 && this.LA(1) != tokenType) {
            this.consume();
        }
    }

    public void consumeUntil(BitSet set) throws TokenStreamException {
        while (this.LA(1) != 1 && !set.member(this.LA(1))) {
            this.consume();
        }
    }

    public int mark() {
        return this.inputState.input.mark();
    }

    public void match(int t) throws MismatchedTokenException, TokenStreamException {
        if (this.LA(1) != t) {
            throw new MismatchedTokenException(this.tokenNames, this.LT(1), t, false, this.getFilename());
        }
        this.consume();
    }

    public void match(BitSet b) throws MismatchedTokenException, TokenStreamException {
        if (!b.member(this.LA(1))) {
            throw new MismatchedTokenException(this.tokenNames, this.LT(1), b, false, this.getFilename());
        }
        this.consume();
    }

    public void matchNot(int t) throws MismatchedTokenException, TokenStreamException {
        if (this.LA(1) == t) {
            throw new MismatchedTokenException(this.tokenNames, this.LT(1), t, true, this.getFilename());
        }
        this.consume();
    }

    public AST noViableAlt(Token token, String filename) throws RecognitionException {
        return this.noViableAlt(token, filename, null);
    }

    public AST noViableAlt(Token token, String filename, String rule) throws RecognitionException {
        NoViableAltException e = new NoViableAltException(token, filename);
        e.setRule(rule);
        throw e;
    }

    public void removeMessageListener(MessageListener l) {
        this.removeListener("removeMessageListener");
    }

    public void removeParserListener(ParserListener l) {
        this.removeListener("removeParserListener");
    }

    public void removeParserMatchListener(ParserMatchListener l) {
        this.removeListener("removeParserMatchListener");
    }

    public void removeParserTokenListener(ParserTokenListener l) {
        this.removeListener("removeParserTokenListener");
    }

    public void removeSemanticPredicateListener(SemanticPredicateListener l) {
        this.removeListener("removeSemanticPredicateListener");
    }

    public void removeSyntacticPredicateListener(SyntacticPredicateListener l) {
        this.removeListener("removeSyntacticPredicateListener");
    }

    public void removeTraceListener(TraceListener l) {
        this.removeListener("removeTraceListener");
    }

    public void reportError(RecognitionException ex) {
        System.err.println(ex);
    }

    public void reportError(String s) {
        if (this.getFilename() == null) {
            System.err.println("error: " + s);
        } else {
            System.err.println(this.getFilename() + ": error: " + s);
        }
    }

    public void reportWarning(String s) {
        if (this.getFilename() == null) {
            System.err.println("warning: " + s);
        } else {
            System.err.println(this.getFilename() + ": warning: " + s);
        }
    }

    public void rewind(int pos) {
        this.inputState.input.rewind(pos);
    }

    public void traceIn(String rname) throws TokenStreamException {
        ++this.traceDepth;
        this.traceIndent();
        System.out.println("> " + rname + "; LA(1)==" + this.LT(1).getText() + (this.inputState.guessing > 0 ? " [guessing]" : ""));
    }

    public void traceIndent() {
        for (int i = 0; i < this.traceDepth; ++i) {
            System.out.print(" ");
        }
    }

    public void traceOut(String rname) throws TokenStreamException {
        this.traceIndent();
        System.out.println("< " + rname + "; LA(1)==" + this.LT(1).getText() + (this.inputState.guessing > 0 ? " [guessing]" : ""));
        --this.traceDepth;
    }

    protected void defaultDebuggingSetup(TokenStream lexer, TokenBuffer tokBuf) {
    }

    private void removeListener(String methodName) {
        if (!this.ignoreInvalidDebugCalls) {
            throw new RuntimeException(methodName + "() is only valid if parser built for debugging");
        }
    }
}

