/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import fuego.parser.ANTLRTokdefLexer;
import fuego.parser.ANTLRTokdefParser;
import fuego.parser.Grammar;
import fuego.parser.SimpleTokenManager;
import fuego.parser.StringLiteralSymbol;
import fuego.parser.TokenStreamException;
import fuego.parser.TokenSymbol;
import fuego.parser.Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

class ImportVocabTokenManager
extends SimpleTokenManager
implements Cloneable {
    protected Grammar grammar;
    private String filename;

    ImportVocabTokenManager(Grammar grammar, String filename_, String name_, Tool tool_) {
        super(name_, tool_);
        this.grammar = grammar;
        this.filename = filename_;
        File grammarFile = new File(this.filename);
        if (!grammarFile.exists() && !(grammarFile = new File(this.antlrTool.getOutputDirectory(), this.filename)).exists()) {
            this.antlrTool.fatalError("panic: " + "Cannot find importVocab file '" + grammarFile + "'");
        }
        this.setReadOnly(true);
        try {
            BufferedReader fileIn = new BufferedReader(new FileReader(grammarFile));
            ANTLRTokdefLexer tokdefLexer = new ANTLRTokdefLexer(fileIn);
            ANTLRTokdefParser tokdefParser = new ANTLRTokdefParser(tokdefLexer);
            tokdefParser.setTool(this.antlrTool);
            tokdefParser.setFilename(this.filename);
            tokdefParser.file(this);
        }
        catch (FileNotFoundException fnf) {
            this.antlrTool.fatalError("panic: " + "Cannot find importVocab file '" + this.filename + "'");
        }
        catch (TokenStreamException ex) {
            this.antlrTool.fatalError("panic: " + "Error reading importVocab file '" + this.filename + "'");
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public ImportVocabTokenManager clone() {
        ImportVocabTokenManager tm = (ImportVocabTokenManager)super.clone();
        tm.filename = this.filename;
        tm.grammar = this.grammar;
        return tm;
    }

    @Override
    public void define(TokenSymbol ts) {
        super.define(ts);
    }

    public void define(String s, int ttype) {
        TokenSymbol ts = s.startsWith("\"") ? new StringLiteralSymbol(s) : new TokenSymbol(s);
        ts.setTokenType(ttype);
        super.define(ts);
        this.maxToken = ttype + 1 > this.maxToken ? ttype + 1 : this.maxToken;
    }

    @Override
    public int nextTokenType() {
        return super.nextTokenType();
    }
}

