/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.datacontrol.util;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import com.sun.tools.xjc.runtime.JAXBContextFactory;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.xml.bind.JAXBException;
import oracle.adf.share.logging.ADFLogger;
import oracle.adfdt.model.DataControlManager;
import oracle.adfdt.model.ModelDesignTimeContext;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.transaction.Task;
import oracle.adfdtinternal.model.ide.factories.adapter.DCFactoryAdapter;
import oracle.adfdtinternal.model.ide.jdev.ContextFactory;
import oracle.adfdtinternal.model.ide.managers.ConfigurationManager;
import oracle.adfdtinternal.model.ide.navigator.nodes.DataControlConfigurationNode;
import oracle.adfdtinternal.model.ide.resource.AdfModelIdeRes;
import oracle.adfinternal.model.adapter.generic.DCStructureProviderFactory;
import oracle.adfinternal.model.adapter.generic.DataControlStructureProvider;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.bpm.datacontrol.adapter.BpmBeanDataControlProviderImpl;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.xml.jaxb.JaxbUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class PayloadObjGenerator {
    public final String SUPPORTS_CRITERIA = "_SupportsCriteria";
    public final String SUPPORTS_UPDATES = "_SupportsUpdates";
    private ADFLogger _logger = ADFLogger.createADFLogger((String)"oracle.adf.model.adapter.bean");
    private final String ACTIVITY_FORM = "Activity";
    private String activitySvc = null;
    private Context context;
    private final String DATA_FORM = "Data";
    private DataControl dataControl;
    private String datacontrolName = null;
    private String dataObject = null;
    private String dataObjNameSpace = null;
    private String elementName = null;
    private DCFactoryAdapter factory;
    private String formType;
    private String packageName;
    private ProgressBar progressBar;
    private String projectSourceFolder;
    private String serviceType;
    private String topLevelClassName = null;
    private URL xsdURL;
    public static final String LOGGER = "oracle.adf.model.adapter.bean";
    public static final String GENERATE_DC_METADATA = "GENERATE_DC_METADATA";
    public static final String CREATABLE_TYPES = "CREATABLE_TYPES";

    public PayloadObjGenerator(URL xsdURL, Context ctx, String datacontrolName, String dataObjName, String elementName, String dataObjNameSpace, String serviceType, String formType, String activitySvc) {
        this.context = ctx;
        this.xsdURL = xsdURL;
        this.dataObject = dataObjName;
        this.dataObjNameSpace = dataObjNameSpace;
        this.elementName = elementName;
        this.topLevelClassName = this.resolveClassName(elementName);
        this.serviceType = serviceType;
        this.datacontrolName = datacontrolName;
        this.formType = formType == null ? "Data" : formType;
        if (formType == "Activity") {
            if (activitySvc == null) {
                this._logger.severe("Case Activity cannot be null!");
            } else {
                this.activitySvc = activitySvc;
            }
        }
    }

    public DataControl generateDataControl() throws JAXBException, MalformedURLException, IllegalAccessException, InstantiationException, Exception {
        DataControl dc = null;
        this._logger.fine("Printing the xsd content.");
        this.xsdContent(this.xsdURL.openStream());
        this.generateJaxbObjs();
        if (this.projectSourceFolder == null) {
            this._logger.severe("cannot generate Data Control. No source files exist");
            return dc;
        }
        this._logger.fine("top level class " + this.topLevelClassName);
        URL topLevelClassURL = this.searchFile(this.projectSourceFolder, this.topLevelClassName);
        if (topLevelClassURL == null) {
            this._logger.severe("Datacontrol cannot be generated. Invalid Data Object");
            throw new Exception("Datacontrol cannot be generated. Invalid Data Object");
        }
        this.packageName = topLevelClassURL.getPath();
        this.writePropertiesFile(this.projectSourceFolder);
        Node topJavaNode = this.createJavaSourceNode(this.context.getProject(), topLevelClassURL);
        if (topJavaNode == null) {
            this._logger.warning("top level java class is null");
            return dc;
        }
        this.context.setElement((oracle.ide.model.Element)topJavaNode);
        BpmBeanDataControlProviderImpl provider = new BpmBeanDataControlProviderImpl(this.datacontrolName, this.dataObject, this.elementName, this.dataObjNameSpace, this.serviceType, this.formType);
        DCStructureProviderFactory.instance().addProviderBuilder("bean", (DataControlStructureProvider)provider);
        DataControlManager.getInstance().populateDataControlListNow();
        ModelDesignTimeContext modelContext = ContextFactory.create((Context)this.context);
        DCFactoryAdapter factory = new DCFactoryAdapter();
        boolean b = factory.canCreateDataControl(this.context);
        DataControl beanDC = this.createDataControl(this.context, factory);
        beanDC.setDesigntimeContext(modelContext);
        DataControlDefinition dcDefinition = beanDC.getDataControlDefinition();
        StructureDefinition beanDef = dcDefinition.getStructure();
        return beanDC;
    }

    public void generateJaxbObjs() throws JAXBException, MalformedURLException, IllegalAccessException, InstantiationException {
        URL projectURL = Ide.getActiveProject().getURL();
        Project dataControlProj = this.context.getProject();
        if (dataControlProj == null) {
            System.out.println("context project is not set");
        }
        if (dataControlProj != null) {
            String shortLabel = dataControlProj.getShortLabel().toLowerCase();
            String projName = shortLabel.substring(0, shortLabel.lastIndexOf(".jpr"));
            dataControlProj.setProperty("defaultPackage", projName);
            this.packageName = projName;
            File srcDir = null;
            srcDir = new File(dataControlProj.getBaseDirectory(), "src");
            if (!srcDir.exists()) {
                srcDir.mkdir();
            }
            this.generate(srcDir);
            this.projectSourceFolder = srcDir.getAbsolutePath();
        }
    }

    public void generate(File srcDir) {
        JaxbErrorHandler handler = new JaxbErrorHandler();
        SchemaCompiler compiler = XJC.createSchemaCompiler();
        compiler.setErrorListener((ErrorListener)handler);
        try {
            URL xjbURL = Thread.currentThread().getContextClassLoader().getResource("oracle/bpm/datacontrol/type/Bindings.xjb");
            this.xsdContent(xjbURL.openStream());
            InputSource inputSrc = new InputSource(xjbURL.openStream());
            inputSrc.setSystemId(xjbURL.toString());
            compiler.getOptions().addBindFile(inputSrc);
        }
        catch (IOException e) {
            this._logger.warning("failed to compile jaxb binding file");
        }
        if (handler.hasErrors()) {
            this._logger.warning("Errors found during Xjb parsing");
        }
        try {
            InputSource inputSrc = new InputSource(this.xsdURL.openStream());
            inputSrc.setSystemId(this.xsdURL.toString());
            compiler.parseSchema(inputSrc);
        }
        catch (IOException e) {
            this._logger.warning("Jaxb parser failed to parse xsd");
        }
        if (handler.hasErrors()) {
            handler.getException().printStackTrace();
            this._logger.warning("Errors found during Jaxb parsing");
        }
        S2JJAXBModel model = null;
        try {
            model = compiler.bind();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (handler.hasErrors()) {
            handler.getException().printStackTrace();
            this._logger.warning("Errors found during Jaxb parsing");
        }
        JCodeModel codeModel = model.generateCode(new Plugin[0], (ErrorListener)handler);
        try {
            codeModel.build(srcDir);
        }
        catch (IOException e) {
            this._logger.severe("Exception during Jaxb generation");
        }
    }

    public URL searchFile(String dirName, String fileName) {
        File f = new File(dirName);
        File[] files = f.listFiles();
        boolean fileFound = false;
        URL fileURL = null;
        for (int i = 0; i < files.length && !fileFound; ++i) {
            if (files[i].isDirectory()) {
                String newDir = dirName + File.separator + files[i].getName();
                fileURL = this.searchFile(newDir, fileName);
                if (fileURL == null) continue;
                return fileURL;
            }
            if (!files[i].getName().equalsIgnoreCase(fileName + ".java")) continue;
            if (fileName.equals("ActivityInputsType")) {
                String filePath = files[i].getAbsolutePath();
                if (this.activitySvc.equals("htSvc") && filePath.contains("task")) {
                    try {
                        fileURL = files[i].toURI().toURL();
                        fileFound = true;
                        return fileURL;
                    }
                    catch (MalformedURLException e) {
                        this._logger.severe("file url not found");
                        return null;
                    }
                }
                if (!filePath.contains(this.activitySvc.toLowerCase())) continue;
                try {
                    fileURL = files[i].toURI().toURL();
                    fileFound = true;
                    return fileURL;
                }
                catch (MalformedURLException e) {
                    this._logger.severe("file url not found");
                    return null;
                }
            }
            try {
                fileURL = files[i].toURI().toURL();
                fileFound = true;
                return fileURL;
            }
            catch (MalformedURLException e) {
                this._logger.severe("file url not found");
                return null;
            }
        }
        if (!fileFound) {
            return null;
        }
        return fileURL;
    }

    public Node createJavaSourceNode(Project project, URL url) {
        if (url == null) {
            return null;
        }
        try {
            Node node = NodeFactory.find((URL)url);
            if (node != null) {
                NodeFactory.uncache((URL)url);
            }
            if ((node = NodeFactory.findOrCreate(JavaSourceNode.class, (URL)url)) != null) {
                if (!URLFileSystem.exists((URL)url)) {
                    try {
                        URLFileSystem.openOutputStream((URL)url).close();
                    }
                    catch (IOException e) {
                        this._logger.severe("Error when trying to open url " + url.toString());
                    }
                }
                if (!project.containsChild((oracle.ide.model.Element)node)) {
                    project.add((oracle.ide.model.Element)node);
                }
            }
            return node;
        }
        catch (Exception e) {
            this._logger.severe("Java source node generation failed for " + url.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xsdContent(InputStream is) {
        try {
            String s;
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            while ((s = dis.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (MalformedURLException mue) {
            System.exit(1);
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected void writeContents(String contents, String nodeURLPath) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(nodeURLPath));
            writer.write(contents);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            this._logger.fine("error when writing to " + nodeURLPath);
        }
    }

    private void writePropertiesFile(String sourceDir) throws Exception {
        StringBuilder content = new StringBuilder();
        content.append(JaxbUtil.getPrefaceString());
        content.append("# Generated by Oracle JAXB Class Generator on ");
        content.append(new Date().toString());
        content.append(System.getProperty("line.separator"));
        content.append("javax.xml.bind.context.factory = ");
        content.append(JAXBContextFactory.class.getName());
        File file = new File(sourceDir, "jaxb.properties");
        FileOutputStream outputStream = new FileOutputStream(file);
        OutputStreamWriter fileWriter = new OutputStreamWriter(outputStream);
        fileWriter.write(content.toString());
        fileWriter.flush();
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataControl createDataControl(Context context, DCFactoryAdapter factory) {
        oracle.ide.model.Element node = context.getElement();
        try {
            if (factory == null) {
                String sMessage = AdfModelIdeRes.format((int)31, (Object)node.getShortLabel());
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)sMessage, (String)AdfModelIdeRes.getString((int)32), (String)"f1_cantcreate_datacontrol_html");
                return null;
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
            return null;
        }
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        wc.show();
        try {
            this.context = context;
            this.factory = factory;
            try {
                DataControl dc = this.createDataControl();
                Thread.sleep(1000L);
                this.initializeDataControlDefinition(dc);
                DataControlConfigurationNode cnode = ConfigurationManager.findConfigurationNodeInProject((Project)context.getProject());
                if (cnode != null) {
                    try {
                        cnode.save();
                    }
                    catch (IOException e) {
                        this._logger.severe("Failed to save datacontrol configuration node");
                    }
                }
                this.dataControl = dc;
            }
            catch (Exception e) {
                this._logger.severe("Failed to create and initiatloze data control");
            }
        }
        finally {
            wc.hide();
        }
        return this.dataControl;
    }

    private DataControl createDataControl() {
        DataControl dc;
        Project project = this.context.getProject();
        if (project != null) {
            JavaManager.getJavaManager((Project)project).getCacheSupport().flushCache();
        }
        if ((dc = this.factory.createDataControl(this.context)) != null) {
            DataControlManager.getInstance().refreshAndGetAllDataControls();
            DataControlConfigurationNode dataControlConfigurationNode = ConfigurationManager.findConfigurationNodeInProject((Project)project);
        }
        return dc;
    }

    private void initializeDataControlDefinition(DataControl dc) {
        if (dc instanceof JUDTAdapterDataControl) {
            final JUDTAdapterDataControl adapterdc = (JUDTAdapterDataControl)dc;
            Task setDCImplDef = new Task(){

                public void run() {
                    try {
                        String defClassName = adapterdc.getDefinitionClass();
                        adapterdc.setAttribute("ImplDef", "oracle.bpm.datacontrol.definition.BPMBeanDefinition");
                        adapterdc.setDefinitionClass(defClassName);
                        adapterdc.internalRefreshStructure();
                    }
                    catch (Exception e) {
                        PayloadObjGenerator.this._logger.warning("transaction mgr failed when initializing data control definition");
                    }
                }
            };
            adapterdc.getTransactionManager().runTaskUnderTransaction("setImplDef", setDCImplDef);
            StructureDefinition dcDef = adapterdc.getNativeStructure();
            if (dcDef != null) {
                Object o = dcDef.getProperty("_SupportsCriteria");
                if (o == null || Boolean.parseBoolean((String)o)) {
                    // empty if block
                }
                if ((o = dcDef.getProperty(GENERATE_DC_METADATA)) == null || Boolean.parseBoolean((String)o)) {
                    // empty if block
                }
            }
        }
    }

    private Element getDefElement(JUDTAdapterDataControl adapterdc) {
        XMLDocument doc = new XMLDocument();
        return doc.createElementNS(adapterdc.getNameSpaceUrl(), adapterdc.getXMLElementTag());
    }

    private String resolveClassName(String dataObjName) {
        this._logger.fine("Element Name is " + dataObjName);
        String className = dataObjName;
        try {
            XMLSchemaNode schemaNode;
            XSDNode[] topNodeSet;
            XSDBuilder schemaBuilder = new XSDBuilder();
            XMLSchema schema = schemaBuilder.build(this.xsdURL);
            if (schema != null && (topNodeSet = (schemaNode = schema.getSchemaByTargetNS(this.dataObjNameSpace)).getElementSet()).length > 0) {
                for (int i = 0; i < topNodeSet.length; ++i) {
                    String elementName = topNodeSet[i].getName();
                    if (!dataObjName.equalsIgnoreCase(elementName) || !(topNodeSet[i] instanceof XSDElement) || ((XSDElement)topNodeSet[i]).getRefLocalname() == null) continue;
                    className = ((XSDElement)topNodeSet[i]).getRefLocalname();
                }
            }
        }
        catch (XSDException e) {
            this._logger.severe("xsd schema parsing failed");
        }
        return className;
    }

    private static class JaxbErrorHandler
    implements ErrorListener {
        private Exception exception;

        private JaxbErrorHandler() {
        }

        public void error(SAXParseException exception) {
            if (this.exception == null) {
                this.exception = exception;
            }
        }

        public void fatalError(SAXParseException exception) {
            if (this.exception == null) {
                this.exception = exception;
            }
        }

        public void info(SAXParseException exception) {
            if (this.exception == null) {
                this.exception = exception;
            }
        }

        public void warning(SAXParseException exception) {
            if (this.exception == null) {
                this.exception = exception;
            }
        }

        protected Exception getException() {
            return this.exception;
        }

        protected boolean hasErrors() {
            return this.exception != null;
        }
    }
}

