/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.datacontrol.type.convertor;

import javax.xml.bind.DatatypeConverter;

public class GregorianConvertor {
    private static final String[] validMonthStrings = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final String[] validDayStrings = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};

    public static String parseGMonth(String gMonth) throws Exception {
        String gregorianMonth = DatatypeConverter.parseString((String)gMonth);
        if (gregorianMonth != null && gregorianMonth != "") {
            String validMonth;
            int i;
            if (!gregorianMonth.startsWith("--")) {
                throw new Exception("Gregorian Month must be of --MM format");
            }
            String month = gregorianMonth.substring(2, 4);
            for (i = 0; i < validMonthStrings.length && !(validMonth = validMonthStrings[i]).equals(month); ++i) {
            }
            if (i == validMonthStrings.length) {
                throw new Exception("Gregorian Month must be of --MM format");
            }
        }
        return gregorianMonth;
    }

    public static String printGMonth(String gMonth) throws Exception {
        String gregorianMonth = DatatypeConverter.printString((String)gMonth);
        if (gregorianMonth != null && gregorianMonth != "") {
            String validMonth;
            int i;
            if (!gregorianMonth.startsWith("--")) {
                throw new Exception("Gregorian Month must be of --MM format");
            }
            String month = gregorianMonth.substring(2, 4);
            for (i = 0; i < validMonthStrings.length && !(validMonth = validMonthStrings[i]).equals(month); ++i) {
            }
            if (i == validMonthStrings.length) {
                throw new Exception("Gregorian Month must be of --MM format");
            }
        }
        return gregorianMonth;
    }

    public static String parseGDay(String gDay) throws Exception {
        String gregorianDay = DatatypeConverter.parseString((String)gDay);
        if (gregorianDay != null && gregorianDay != "") {
            String validDay;
            int i;
            if (!gregorianDay.startsWith("---")) {
                throw new Exception("Gregorian Day must be of ---DD format");
            }
            String day = gregorianDay.substring(3, 5);
            for (i = 0; i < validDayStrings.length && !(validDay = validDayStrings[i]).equals(day); ++i) {
            }
            if (i == validDayStrings.length) {
                throw new Exception("Gregorian Day must be of ---DD format");
            }
        }
        return gregorianDay;
    }

    public static String printGDay(String gDay) throws Exception {
        String gregorianDay = DatatypeConverter.printString((String)gDay);
        if (gregorianDay != null && gregorianDay != "") {
            String validDay;
            int i;
            if (!gregorianDay.startsWith("---")) {
                throw new Exception("Gregorian Day must be of ---DD format");
            }
            String day = gregorianDay.substring(3, 5);
            for (i = 0; i < validDayStrings.length && !(validDay = validDayStrings[i]).equals(day); ++i) {
            }
            if (i == validDayStrings.length) {
                throw new Exception("Gregorian Day must be of ---DD format");
            }
        }
        return gregorianDay;
    }

    public static String parseGYear(String gYear) throws Exception {
        String gregorianYear = DatatypeConverter.parseString((String)gYear);
        if (gregorianYear != null && gregorianYear != "") {
            if (gregorianYear.length() != 4) {
                throw new Exception("Gregorian Year must be of YYYY format");
            }
            try {
                int year = Integer.parseInt(gregorianYear);
            }
            catch (Exception e) {
                throw new Exception("Gregorian Year must be of YYYY format");
            }
        }
        return gregorianYear;
    }

    public static String printGYear(String gYear) throws Exception {
        String gregorianYear = DatatypeConverter.printString((String)gYear);
        if (gregorianYear != null && gregorianYear != "") {
            if (gregorianYear.length() != 4) {
                throw new Exception("Gregorian Year must be of YYYY format");
            }
            try {
                int year = Integer.parseInt(gregorianYear);
            }
            catch (Exception e) {
                throw new Exception("Gregorian Year must be of YYYY format");
            }
        }
        return gregorianYear;
    }

    public static String parseGMonthDay(String gMonthDay) throws Exception {
        String gregorianMonthDay = DatatypeConverter.parseString((String)gMonthDay);
        if (gregorianMonthDay != null && gregorianMonthDay != "") {
            String validDay;
            String validMonth;
            int i;
            if (!gregorianMonthDay.startsWith("--") || gregorianMonthDay.charAt(4) != '-') {
                throw new Exception("Gregorian Month Day must be of --MM-DD format");
            }
            String month = gregorianMonthDay.substring(2, 4);
            for (i = 0; i < validMonthStrings.length && !(validMonth = validMonthStrings[i]).equals(month); ++i) {
            }
            if (i == validMonthStrings.length) {
                throw new Exception("Gregorian Month Day must be of --MM-DD format");
            }
            String day = gregorianMonthDay.substring(5, 7);
            for (i = 0; i < validDayStrings.length && !(validDay = validDayStrings[i]).equals(day); ++i) {
            }
            if (i == validDayStrings.length) {
                throw new Exception("Gregorian Month Day must be of ---M-DD format");
            }
        }
        return gregorianMonthDay;
    }

    public static String printGMonthDay(String gMonthDay) throws Exception {
        String gregorianMonthDay = DatatypeConverter.printString((String)gMonthDay);
        if (gregorianMonthDay != null && gregorianMonthDay != "") {
            String validDay;
            String validMonth;
            int i;
            if (!gregorianMonthDay.startsWith("--") || gregorianMonthDay.charAt(4) != '-') {
                throw new Exception("Gregorian Month Day must be of --MM-DD format");
            }
            String month = gregorianMonthDay.substring(2, 4);
            for (i = 0; i < validMonthStrings.length && !(validMonth = validMonthStrings[i]).equals(month); ++i) {
            }
            if (i == validMonthStrings.length) {
                throw new Exception("Gregorian Month Day must be of --MM-DD format");
            }
            String day = gregorianMonthDay.substring(5, 7);
            for (i = 0; i < validDayStrings.length && !(validDay = validDayStrings[i]).equals(day); ++i) {
            }
            if (i == validDayStrings.length) {
                throw new Exception("Gregorian Month Day must be of ---M-DD format");
            }
        }
        return gregorianMonthDay;
    }

    public static String parseGYearMonth(String gYearMonth) throws Exception {
        String gregorianYearMonth = DatatypeConverter.parseString((String)gYearMonth);
        if (gregorianYearMonth != null && gregorianYearMonth != "") {
            String validMonth;
            int i;
            String year = gregorianYearMonth.substring(0, 4);
            try {
                int yearInt = Integer.parseInt(year);
            }
            catch (Exception e) {
                throw new Exception("Gregorian YearMonth must be of YYYY-MM format");
            }
            if (gregorianYearMonth.charAt(4) != '-') {
                throw new Exception("Gregorian YearMonth must be of YYYY-MM format");
            }
            String month = gregorianYearMonth.substring(5, 7);
            for (i = 0; i < validMonthStrings.length && !(validMonth = validMonthStrings[i]).equals(month); ++i) {
            }
            if (i == validMonthStrings.length) {
                throw new Exception("Gregorian YearMonth must be of YYYY-MM format");
            }
        }
        return gregorianYearMonth;
    }

    public static String printGYearMonth(String gYearMonth) throws Exception {
        String gregorianYearMonth = DatatypeConverter.printString((String)gYearMonth);
        if (gregorianYearMonth != null && gregorianYearMonth != "") {
            String validMonth;
            int i;
            String year = gregorianYearMonth.substring(0, 4);
            try {
                int yearInt = Integer.parseInt(year);
            }
            catch (Exception e) {
                throw new Exception("Gregorian YearMonth must be of YYYY-MM format");
            }
            if (gregorianYearMonth.charAt(4) != '-') {
                throw new Exception("Gregorian YearMonth must be of YYYY-MM format");
            }
            String month = gregorianYearMonth.substring(5, 7);
            for (i = 0; i < validMonthStrings.length && !(validMonth = validMonthStrings[i]).equals(month); ++i) {
            }
            if (i == validMonthStrings.length) {
                throw new Exception("Gregorian YearMonth must be of YYYY-MM format");
            }
        }
        return gregorianYearMonth;
    }
}

